/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakMain;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.HostnameV2PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.HttpPropertyMappers;
import picocli.CommandLine;

public abstract class AbstractStartCommand
extends AbstractCommand
implements Runnable {
    public static final String OPTIMIZED_BUILD_OPTION_LONG = "--optimized";
    private boolean skipStart;

    @Override
    public void run() {
        Environment.setParsedCommand(this);
        this.doBeforeRun();
        CommandLine cmd = this.spec.commandLine();
        HttpPropertyMappers.validateConfig();
        HostnameV2PropertyMappers.validateConfig();
        this.validateConfig();
        if (ConfigArgsConfigSource.getAllCliArgs().contains(OPTIMIZED_BUILD_OPTION_LONG) && !AbstractStartCommand.wasBuildEverRun()) {
            this.executionError(this.spec.commandLine(), Messages.optimizedUsedForFirstStartup());
        }
        if (!this.skipStart) {
            KeycloakMain.start((ExecutionExceptionHandler)cmd.getExecutionExceptionHandler(), cmd.getErr(), cmd.getParseResult().originalArgs().toArray(new String[0]));
        }
    }

    protected void doBeforeRun() {
    }

    public static boolean wasBuildEverRun() {
        return !Configuration.getRawPersistedProperties().isEmpty();
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        EnumSet<OptionCategory> excludedCategories = this.excludedCategories();
        return super.getOptionCategories().stream().filter(optionCategory -> !excludedCategories.contains(optionCategory)).collect(Collectors.toList());
    }

    protected EnumSet<OptionCategory> excludedCategories() {
        return EnumSet.of(OptionCategory.IMPORT, OptionCategory.EXPORT);
    }

    public void setSkipStart(boolean skipStart) {
        this.skipStart = skipStart;
    }
}

