/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.provider.Provider;
import org.keycloak.theme.Theme;

public interface ThemeSelectorProvider
extends Provider {
    public static final String DEFAULT = "keycloak";
    public static final String DEFAULT_V2 = "keycloak.v2";
    public static final String DEFAULT_V3 = "keycloak.v3";

    public String getThemeName(Theme.Type var1);

    default public String getDefaultThemeName(Theme.Type type) {
        String name = Config.scope((String[])new String[]{"theme"}).get("default");
        if (name != null && !name.isEmpty()) {
            return name;
        }
        if (type == Theme.Type.ACCOUNT && Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT3)) {
            return DEFAULT_V3;
        }
        if (type == Theme.Type.ACCOUNT && Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT2)) {
            return DEFAULT_V2;
        }
        if (type == Theme.Type.ADMIN && Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN2)) {
            return DEFAULT_V2;
        }
        return DEFAULT;
    }
}

