/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.email;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.email.EmailException;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.resources.flows.Urls;

public class EmailSender {
    private static final Logger log = Logger.getLogger(EmailSender.class);
    private Map<String, String> config;

    public EmailSender(Map<String, String> config) {
        this.config = config;
    }

    public void send(String address, String subject, String body) throws EmailException {
        try {
            Properties props = new Properties();
            props.setProperty("mail.smtp.host", this.config.get("host"));
            boolean auth = "true".equals(this.config.get("auth"));
            boolean ssl = "true".equals(this.config.get("ssl"));
            boolean starttls = "true".equals(this.config.get("starttls"));
            if (this.config.containsKey("port")) {
                props.setProperty("mail.smtp.port", this.config.get("port"));
            }
            if (auth) {
                props.put("mail.smtp.auth", "true");
            }
            if (ssl) {
                props.put("mail.smtp.socketFactory.port", this.config.get("port"));
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            if (starttls) {
                props.put("mail.smtp.starttls.enable", "true");
            }
            String from = this.config.get("from");
            Session session = Session.getInstance((Properties)props);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setHeader("To", address);
            msg.setSubject(subject);
            msg.setText(body);
            msg.saveChanges();
            Transport transport = session.getTransport("smtp");
            if (auth) {
                transport.connect(this.config.get("user"), this.config.get("password"));
            } else {
                transport.connect();
            }
            transport.sendMessage((Message)msg, (Address[])new InternetAddress[]{new InternetAddress(address)});
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
    }

    public void sendEmailVerification(UserModel user, RealmModel realm, AccessCodeEntry accessCode, UriInfo uriInfo) throws EmailException {
        UriBuilder builder = Urls.loginActionEmailVerificationBuilder(uriInfo.getBaseUri());
        builder.queryParam("key", new Object[]{accessCode.getId()});
        URI uri = builder.build(new Object[]{realm.getName()});
        StringBuilder sb = this.getHeader(user);
        sb.append("Someone has created a Keycloak account with this email address. ");
        sb.append("If this was you, click the link below to verify your email address:\n");
        sb.append(uri.toString());
        sb.append("\n\nThis link will expire within ").append(TimeUnit.SECONDS.toMinutes(realm.getAccessCodeLifespanUserAction()));
        sb.append(" minutes.\n\n");
        sb.append("If you didn't create this account, just ignore this message.\n");
        this.addFooter(sb);
        this.send(user.getEmail(), "Verify email", sb.toString());
    }

    public void sendPasswordReset(UserModel user, RealmModel realm, AccessCodeEntry accessCode, UriInfo uriInfo) throws EmailException {
        UriBuilder builder = Urls.loginPasswordResetBuilder(uriInfo.getBaseUri());
        builder.queryParam("key", new Object[]{accessCode.getId()});
        URI uri = builder.build(new Object[]{realm.getName()});
        StringBuilder sb = this.getHeader(user);
        sb.append("Someone just requested to change your Keycloak account's password. ");
        sb.append("If this was you, click on the link below to set a new password:\n");
        sb.append(uri.toString());
        sb.append("\n\nThis link will expire within ").append(TimeUnit.SECONDS.toMinutes(realm.getAccessCodeLifespanUserAction()));
        sb.append(" minutes.\n\n");
        sb.append("If you don't want to reset your password, just ignore this message and nothing will be changed.\n");
        this.addFooter(sb);
        this.send(user.getEmail(), "Reset password link", sb.toString());
    }

    public void sendUsernameReminder(UserModel user) throws EmailException {
        StringBuilder sb = this.getHeader(user);
        sb.append("The username for your Keycloak account is ").append(user.getLoginName()).append(".\n");
        this.addFooter(sb);
        this.send(user.getEmail(), "Username reminder", sb.toString());
    }

    private StringBuilder getHeader(UserModel user) {
        StringBuilder sb = new StringBuilder();
        sb.append("Hi");
        if (user.getFirstName() != null) {
            sb.append(" ").append(user.getFirstName());
        }
        sb.append(",\n\n");
        return sb;
    }

    private void addFooter(StringBuilder sb) {
        sb.append("\nThanks,\nThe Keycloak Team");
    }
}

