/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.UUID;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.RealmManager;

public class ApplianceBootstrap {
    private static final Logger logger = Logger.getLogger(ApplianceBootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap(KeycloakSessionFactory factory) {
        KeycloakSession session = factory.createSession();
        session.getTransaction().begin();
        try {
            this.bootstrap(session);
            session.getTransaction().commit();
        }
        finally {
            session.close();
        }
    }

    public void bootstrap(KeycloakSession session) {
        if (session.getRealm("keycloak-admin") != null) {
            return;
        }
        logger.info("Initializing keycloak-admin realm");
        RealmManager manager = new RealmManager(session);
        RealmModel realm = manager.createRealm("keycloak-admin", "keycloak-admin");
        realm.setName("keycloak-admin");
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.addRequiredOAuthClientCredential("password");
        realm.addRequiredResourceCredential("password");
        realm.setTokenLifespan(300);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setSslNotRequired(true);
        realm.setRegistrationAllowed(false);
        manager.generateRealmKeys(realm);
        ApplicationModel adminConsole = realm.addApplication("admin-console");
        adminConsole.setEnabled(true);
        UserCredentialModel adminConsolePassword = new UserCredentialModel();
        adminConsolePassword.setType("password");
        adminConsolePassword.setValue(UUID.randomUUID().toString());
        realm.updateCredential(adminConsole.getApplicationUser(), adminConsolePassword);
        RoleModel applicationRole = realm.getRole("KEYCLOAK__APPLICATION");
        realm.grantRole(adminConsole.getApplicationUser(), applicationRole);
        RoleModel adminRole = adminConsole.addRole("admin");
        UserModel adminUser = realm.addUser("admin");
        adminUser.setEnabled(true);
        UserCredentialModel password = new UserCredentialModel();
        password.setType("password");
        password.setValue("admin");
        realm.updateCredential(adminUser, password);
        adminUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        adminConsole.grantRole(adminUser, adminRole);
        ApplicationModel accountApp = (ApplicationModel)realm.getApplicationNameMap().get("account");
        for (String r : accountApp.getDefaultRoles()) {
            accountApp.grantRole(adminUser, accountApp.getRole(r));
        }
    }
}

