/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.adapters.config.BaseRealmConfig;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;

public class OAuthClientManager {
    protected RealmModel realm;

    public OAuthClientManager(RealmModel realm) {
        this.realm = realm;
    }

    public UserCredentialModel generateSecret(RealmModel realm, OAuthClientModel app) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        realm.updateCredential(app.getOAuthAgent(), secret);
        return secret;
    }

    public OAuthClientModel create(String name) {
        OAuthClientModel model = this.realm.addOAuthClient(name);
        RoleModel role = this.realm.getRole("KEYCLOAK__IDENTITY_REQUESTER");
        this.realm.grantRole(model.getOAuthAgent(), role);
        this.generateSecret(this.realm, model);
        return model;
    }

    public OAuthClientModel create(OAuthClientRepresentation rep) {
        OAuthClientModel model = this.create(rep.getName());
        this.update(rep, model);
        UserModel resourceUser = model.getOAuthAgent();
        if (rep.getCredentials() != null) {
            for (CredentialRepresentation cred : rep.getCredentials()) {
                UserCredentialModel credential = new UserCredentialModel();
                credential.setType(cred.getType());
                credential.setValue(cred.getValue());
                this.realm.updateCredential(resourceUser, credential);
            }
        }
        return model;
    }

    public void update(OAuthClientRepresentation rep, OAuthClientModel model) {
        List webOrigins;
        model.getOAuthAgent().setEnabled(rep.isEnabled());
        List redirectUris = rep.getRedirectUris();
        if (redirectUris != null) {
            model.getOAuthAgent().setRedirectUris(new HashSet(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            model.getOAuthAgent().setWebOrigins(new HashSet(webOrigins));
        }
    }

    public static OAuthClientRepresentation toRepresentation(OAuthClientModel model) {
        Set webOrigins;
        OAuthClientRepresentation rep = new OAuthClientRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getOAuthAgent().getLoginName());
        rep.setEnabled(model.getOAuthAgent().isEnabled());
        Set redirectUris = model.getOAuthAgent().getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList(redirectUris));
        }
        if ((webOrigins = model.getOAuthAgent().getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList(webOrigins));
        }
        return rep;
    }

    public InstallationAdapterConfig toInstallationRepresentation(RealmModel realmModel, OAuthClientModel model, URI baseUri) {
        InstallationAdapterConfig rep = new InstallationAdapterConfig();
        rep.setRealm(realmModel.getName());
        rep.setRealmKey(realmModel.getPublicKeyPem());
        rep.setSslNotRequired(realmModel.isSslNotRequired());
        rep.setAuthServerUrl(baseUri.toString());
        rep.setResource(model.getOAuthAgent().getLoginName());
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("secret", realmModel.getSecret(model.getOAuthAgent()).getValue());
        rep.setCredentials(creds);
        return rep;
    }

    @JsonPropertyOrder(value={"realm", "realm-public-key", "auth-server-url", "ssl-not-required", "resource", "credentials"})
    public static class InstallationAdapterConfig
    extends BaseRealmConfig {
        @JsonProperty(value="resource")
        protected String resource;
        @JsonProperty(value="credentials")
        protected Map<String, String> credentials = new HashMap<String, String>();

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, String> credentials) {
            this.credentials = credentials;
        }
    }
}

