/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.SocialMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserRoleMappingRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.OAuthClientManager;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    protected KeycloakSession identitySession;

    public RealmManager(KeycloakSession identitySession) {
        this.identitySession = identitySession;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm("keycloak-admin");
    }

    public RealmModel getRealm(String id) {
        return this.identitySession.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.identitySession.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.identitySession.createRealm(id, name);
        realm.setName(name);
        realm.addRole("KEYCLOAK__APPLICATION");
        realm.addRole("KEYCLOAK__IDENTITY_REQUESTER");
        this.setupAccountManagement(realm);
        realm.addRequiredOAuthClientCredential("secret");
        realm.addRequiredResourceCredential("secret");
        return realm;
    }

    public void generateRealmKeys(RealmModel realm) {
        KeyPair keyPair = null;
        try {
            keyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        realm.setPrivateKey(keyPair.getPrivate());
        realm.setPublicKey(keyPair.getPublic());
    }

    public void updateRealm(RealmRepresentation rep, RealmModel realm) {
        if (rep.getRealm() != null) {
            logger.info("Updating realm name to " + rep.getRealm());
            realm.setName(rep.getRealm());
        }
        if (rep.isEnabled() != null) {
            realm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            realm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            realm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            realm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            realm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            realm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.isSslNotRequired() != null) {
            realm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.getAccessCodeLifespan() != null) {
            realm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            realm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        }
        if (rep.getTokenLifespan() != null) {
            realm.setTokenLifespan(rep.getTokenLifespan().intValue());
        }
        if (rep.getRequiredCredentials() != null) {
            realm.updateRequiredCredentials(rep.getRequiredCredentials());
        }
        realm.setLoginTheme(rep.getLoginTheme());
        realm.setAccountTheme(rep.getAccountTheme());
        realm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        if (rep.getDefaultRoles() != null) {
            realm.updateDefaultRoles(rep.getDefaultRoles().toArray(new String[rep.getDefaultRoles().size()]));
        }
        if (rep.getSmtpServer() != null) {
            realm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            realm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
        if ("GENERATE".equals(rep.getPublicKey())) {
            this.generateRealmKeys(realm);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null) {
            application = new ApplicationManager(this).createApplication(realm, "account");
            application.setEnabled(true);
            application.addDefaultRole("view-profile");
            application.addDefaultRole("manage-account");
        }
    }

    public RealmModel importRealm(RealmRepresentation rep, UserModel realmCreator) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.createRealm(id, rep.getRealm());
        this.importRealm(rep, realm);
        return realm;
    }

    public void importRealm(RealmRepresentation rep, RealmModel newRealm) {
        UserModel user;
        ApplicationModel app;
        RoleModel role;
        Map appMap;
        newRealm.setName(rep.getRealm());
        if (rep.isEnabled() != null) {
            newRealm.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isSocial() != null) {
            newRealm.setSocial(rep.isSocial().booleanValue());
        }
        if (rep.getTokenLifespan() != null) {
            newRealm.setTokenLifespan(rep.getTokenLifespan().intValue());
        } else {
            newRealm.setTokenLifespan(300);
        }
        if (rep.getAccessCodeLifespan() != null) {
            newRealm.setAccessCodeLifespan(rep.getAccessCodeLifespan().intValue());
        } else {
            newRealm.setAccessCodeLifespan(60);
        }
        if (rep.getAccessCodeLifespanUserAction() != null) {
            newRealm.setAccessCodeLifespanUserAction(rep.getAccessCodeLifespanUserAction().intValue());
        } else {
            newRealm.setAccessCodeLifespanUserAction(300);
        }
        if (rep.isSslNotRequired() != null) {
            newRealm.setSslNotRequired(rep.isSslNotRequired().booleanValue());
        }
        if (rep.isRegistrationAllowed() != null) {
            newRealm.setRegistrationAllowed(rep.isRegistrationAllowed().booleanValue());
        }
        if (rep.isVerifyEmail() != null) {
            newRealm.setVerifyEmail(rep.isVerifyEmail().booleanValue());
        }
        if (rep.isResetPasswordAllowed() != null) {
            newRealm.setResetPasswordAllowed(rep.isResetPasswordAllowed().booleanValue());
        }
        if (rep.isUpdateProfileOnInitialSocialLogin() != null) {
            newRealm.setUpdateProfileOnInitialSocialLogin(rep.isUpdateProfileOnInitialSocialLogin().booleanValue());
        }
        if (rep.getPrivateKey() == null || rep.getPublicKey() == null) {
            this.generateRealmKeys(newRealm);
        } else {
            newRealm.setPrivateKeyPem(rep.getPrivateKey());
            newRealm.setPublicKeyPem(rep.getPublicKey());
        }
        newRealm.setLoginTheme(rep.getLoginTheme());
        newRealm.setAccountTheme(rep.getAccountTheme());
        HashMap<String, UserModel> userMap = new HashMap<String, UserModel>();
        if (rep.getRequiredCredentials() != null) {
            for (String string : rep.getRequiredCredentials()) {
                this.addRequiredCredential(newRealm, string);
            }
        } else {
            this.addRequiredCredential(newRealm, "password");
        }
        newRealm.setPasswordPolicy(new PasswordPolicy(rep.getPasswordPolicy()));
        if (rep.getUsers() != null) {
            for (UserRepresentation userRepresentation : rep.getUsers()) {
                UserModel userModel = this.createUser(newRealm, userRepresentation);
                userMap.put(userModel.getLoginName(), userModel);
            }
        }
        if (rep.getApplications() != null) {
            appMap = this.createApplications(rep, newRealm);
            for (ApplicationModel applicationModel : appMap.values()) {
                userMap.put(applicationModel.getApplicationUser().getLoginName(), applicationModel.getApplicationUser());
            }
        }
        if (rep.getRoles() != null) {
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    this.createRole(newRealm, roleRepresentation);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    ApplicationModel applicationModel = newRealm.getApplicationByName((String)entry.getKey());
                    if (applicationModel == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = applicationModel.addRole(roleRep.getName());
                        role.setDescription(roleRep.getDescription());
                    }
                }
            }
            if (rep.getRoles().getRealm() != null) {
                for (RoleRepresentation roleRepresentation : rep.getRoles().getRealm()) {
                    RoleModel roleModel = newRealm.getRole(roleRepresentation.getName());
                    this.addComposites(roleModel, roleRepresentation, newRealm);
                }
            }
            if (rep.getRoles().getApplication() != null) {
                for (Map.Entry entry : rep.getRoles().getApplication().entrySet()) {
                    ApplicationModel applicationModel = newRealm.getApplicationByName((String)entry.getKey());
                    if (applicationModel == null) {
                        throw new RuntimeException("App doesn't exist in role definitions: " + (String)entry.getKey());
                    }
                    for (RoleRepresentation roleRep : (List)entry.getValue()) {
                        role = applicationModel.getRole(roleRep.getName());
                        this.addComposites(role, roleRep, newRealm);
                    }
                }
            }
        }
        if (rep.getDefaultRoles() != null) {
            for (String string : rep.getDefaultRoles()) {
                newRealm.addDefaultRole(string.trim());
            }
        }
        if (rep.getOauthClients() != null) {
            Map<String, OAuthClientModel> oauthMap = this.createOAuthClients(rep, newRealm);
            for (OAuthClientModel oAuthClientModel : oauthMap.values()) {
                userMap.put(oAuthClientModel.getOAuthAgent().getLoginName(), oAuthClientModel.getOAuthAgent());
            }
        }
        appMap = newRealm.getApplicationNameMap();
        if (rep.getApplicationRoleMappings() != null) {
            ApplicationManager applicationManager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationRoleMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                applicationManager.createRoleMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getApplicationScopeMappings() != null) {
            ApplicationManager applicationManager = new ApplicationManager(this);
            for (Map.Entry entry : rep.getApplicationScopeMappings().entrySet()) {
                app = (ApplicationModel)appMap.get(entry.getKey());
                if (app == null) {
                    throw new RuntimeException("Unable to find application role mappings for app: " + (String)entry.getKey());
                }
                applicationManager.createScopeMappings(newRealm, app, (List)entry.getValue());
            }
        }
        if (rep.getRoleMappings() != null) {
            for (UserRoleMappingRepresentation userRoleMappingRepresentation : rep.getRoleMappings()) {
                user = (UserModel)userMap.get(userRoleMappingRepresentation.getUsername());
                for (String roleString : userRoleMappingRepresentation.getRoles()) {
                    RoleModel role3 = newRealm.getRole(roleString.trim());
                    if (role3 == null) {
                        role3 = newRealm.addRole(roleString.trim());
                    }
                    newRealm.grantRole(user, role3);
                }
            }
        }
        if (rep.getScopeMappings() != null) {
            for (ScopeMappingRepresentation scopeMappingRepresentation : rep.getScopeMappings()) {
                for (String roleString : scopeMappingRepresentation.getRoles()) {
                    role = newRealm.getRole(roleString.trim());
                    if (role == null) {
                        role = newRealm.addRole(roleString.trim());
                    }
                    UserModel user3 = (UserModel)userMap.get(scopeMappingRepresentation.getUsername());
                    newRealm.addScopeMapping(user3, role);
                }
            }
        }
        if (rep.getSocialMappings() != null) {
            for (SocialMappingRepresentation socialMappingRepresentation : rep.getSocialMappings()) {
                user = (UserModel)userMap.get(socialMappingRepresentation.getUsername());
                for (SocialLinkRepresentation link : socialMappingRepresentation.getSocialLinks()) {
                    SocialLinkModel mappingModel = new SocialLinkModel(link.getSocialProvider(), link.getSocialUsername());
                    newRealm.addSocialLink(user, mappingModel);
                }
            }
        }
        if (rep.getSmtpServer() != null) {
            newRealm.setSmtpConfig(new HashMap(rep.getSmtpServer()));
        }
        if (rep.getSocialProviders() != null) {
            newRealm.setSocialConfig(new HashMap(rep.getSocialProviders()));
        }
    }

    public void addComposites(RoleModel role, RoleRepresentation roleRep, RealmModel realm) {
        if (roleRep.getComposites() == null) {
            return;
        }
        if (roleRep.getComposites().getRealm() != null) {
            for (String string : roleRep.getComposites().getRealm()) {
                RoleModel realmRole = realm.getRole(string);
                if (realmRole == null) {
                    throw new RuntimeException("Unable to find composite realm role: " + string);
                }
                role.addCompositeRole(realmRole);
            }
        }
        if (roleRep.getComposites().getApplication() != null) {
            for (Map.Entry entry : roleRep.getComposites().getApplication().entrySet()) {
                ApplicationModel app = realm.getApplicationByName((String)entry.getKey());
                if (app == null) {
                    throw new RuntimeException("App doesn't exist in role definitions: " + roleRep.getName());
                }
                for (String roleStr : (List)entry.getValue()) {
                    RoleModel appRole = app.getRole(roleStr);
                    if (appRole == null) {
                        throw new RuntimeException("Unable to find composite app role: " + roleStr);
                    }
                    role.addCompositeRole(appRole);
                }
            }
        }
    }

    public void createRole(RealmModel newRealm, RoleRepresentation roleRep) {
        RoleModel role = newRealm.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    public void createRole(RealmModel newRealm, ApplicationModel app, RoleRepresentation roleRep) {
        RoleModel role = app.addRole(roleRep.getName());
        if (roleRep.getDescription() != null) {
            role.setDescription(roleRep.getDescription());
        }
    }

    public UserModel createUser(RealmModel newRealm, UserRepresentation userRep) {
        UserModel user = newRealm.addUser(userRep.getUsername());
        user.setEnabled(userRep.isEnabled());
        user.setEmail(userRep.getEmail());
        if (userRep.getAttributes() != null) {
            for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                user.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (userRep.getRequiredActions() != null) {
            for (String requiredAction : userRep.getRequiredActions()) {
                user.addRequiredAction(UserModel.RequiredAction.valueOf((String)requiredAction));
            }
        }
        if (userRep.getCredentials() != null) {
            for (CredentialRepresentation cred : userRep.getCredentials()) {
                UserCredentialModel credential = RealmManager.fromRepresentation(cred);
                newRealm.updateCredential(user, credential);
            }
        }
        return user;
    }

    public static UserCredentialModel fromRepresentation(CredentialRepresentation cred) {
        UserCredentialModel credential = new UserCredentialModel();
        credential.setType(cred.getType());
        credential.setValue(cred.getValue());
        return credential;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return realmModel.searchForUser(searchString.trim());
    }

    public void addRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredCredential(requiredCred);
    }

    public void addResourceRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredResourceCredential(requiredCred);
    }

    public void addOAuthClientRequiredCredential(RealmModel newRealm, String requiredCred) {
        newRealm.addRequiredOAuthClientCredential(requiredCred);
    }

    protected Map<String, ApplicationModel> createApplications(RealmRepresentation rep, RealmModel realm) {
        HashMap<String, ApplicationModel> appMap = new HashMap<String, ApplicationModel>();
        RoleModel loginRole = realm.getRole("KEYCLOAK__APPLICATION");
        ApplicationManager manager = new ApplicationManager(this);
        for (ApplicationRepresentation resourceRep : rep.getApplications()) {
            ApplicationModel app = manager.createApplication(realm, loginRole, resourceRep);
            appMap.put(app.getName(), app);
        }
        return appMap;
    }

    protected Map<String, OAuthClientModel> createOAuthClients(RealmRepresentation realmRep, RealmModel realm) {
        HashMap<String, OAuthClientModel> appMap = new HashMap<String, OAuthClientModel>();
        OAuthClientManager manager = new OAuthClientManager(realm);
        for (OAuthClientRepresentation rep : realmRep.getOauthClients()) {
            OAuthClientModel app = manager.create(rep);
            appMap.put(app.getOAuthAgent().getLoginName(), app);
        }
        return appMap;
    }
}

