/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.SkeletonKeyScope;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.util.Base64Url;
import org.keycloak.util.JsonSerialization;

public class TokenManager {
    protected static final Logger logger = Logger.getLogger(TokenManager.class);
    protected Map<String, AccessCodeEntry> accessCodeMap = new ConcurrentHashMap<String, AccessCodeEntry>();

    public void clearAccessCodes() {
        this.accessCodeMap.clear();
    }

    public AccessCodeEntry getAccessCode(String key) {
        return this.accessCodeMap.get(key);
    }

    public AccessCodeEntry pullAccessCode(String key) {
        return this.accessCodeMap.remove(key);
    }

    protected boolean desiresScope(SkeletonKeyScope scope, String key, String roleName) {
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        List val = (List)scope.get((Object)key);
        if (val == null) {
            return false;
        }
        return val.contains(roleName);
    }

    protected boolean desiresScopeGroup(SkeletonKeyScope scope, String key) {
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        return scope.containsKey((Object)key);
    }

    protected boolean isEmpty(SkeletonKeyScope scope) {
        return scope == null || scope.isEmpty();
    }

    public static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        for (RoleModel contained : scope.getComposites()) {
            TokenManager.applyScope(role, contained, visited, requested);
        }
    }

    public AccessCodeEntry createAccessCode(String scopeParam, String state, String redirect, RealmModel realm, UserModel client, UserModel user) {
        Set clientAppRoles;
        AccessCodeEntry code = new AccessCodeEntry();
        SkeletonKeyScope scopeMap = null;
        if (scopeParam != null) {
            scopeMap = this.decodeScope(scopeParam);
        }
        List<RoleModel> realmRolesRequested = code.getRealmRolesRequested();
        MultivaluedMap<String, RoleModel> resourceRolesRequested = code.getResourceRolesRequested();
        Set roleMappings = realm.getRoleMappings(user);
        Set scopeMappings = realm.getScopeMappings(client);
        ApplicationModel clientApp = realm.getApplicationByName(client.getLoginName());
        Set set = clientAppRoles = clientApp == null ? null : clientApp.getRoles();
        if (clientAppRoles != null) {
            scopeMappings.addAll(clientAppRoles);
        }
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            if (clientApp != null && role.getContainer().equals(clientApp)) {
                requestedRoles.add(role);
            }
            for (RoleModel desiredRole : scopeMappings) {
                HashSet<RoleModel> visited = new HashSet<RoleModel>();
                TokenManager.applyScope(role, desiredRole, visited, requestedRoles);
            }
        }
        for (RoleModel role : requestedRoles) {
            ApplicationModel app;
            if (role.getContainer() instanceof RealmModel && this.desiresScope(scopeMap, "realm", role.getName())) {
                realmRolesRequested.add(role);
                continue;
            }
            if (!(role.getContainer() instanceof ApplicationModel) || !this.desiresScope(scopeMap, (app = (ApplicationModel)role.getContainer()).getName(), role.getName())) continue;
            resourceRolesRequested.add((Object)app.getName(), (Object)role);
        }
        this.createToken(code, realm, client, user);
        code.setRealm(realm);
        code.setExpiration(System.currentTimeMillis() / 1000L + (long)realm.getAccessCodeLifespan());
        code.setClient(client);
        code.setUser(user);
        code.setState(state);
        code.setRedirectUri(redirect);
        this.accessCodeMap.put(code.getId(), code);
        String accessCode = null;
        try {
            accessCode = new JWSBuilder().content(code.getId().getBytes("UTF-8")).rsa256(realm.getPrivateKey());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        code.setCode(accessCode);
        return code;
    }

    protected SkeletonKeyToken initToken(RealmModel realm, UserModel client, UserModel user) {
        Set allowedOrigins;
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(KeycloakModelUtils.generateId());
        token.principal(user.getLoginName());
        token.audience(realm.getName());
        token.issuedNow();
        token.issuedFor(client.getLoginName());
        if (realm.getTokenLifespan() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)realm.getTokenLifespan());
        }
        if ((allowedOrigins = client.getWebOrigins()) != null) {
            token.setAllowedOrigins(allowedOrigins);
        }
        return token;
    }

    protected void addComposites(SkeletonKeyToken token, RoleModel role) {
        SkeletonKeyToken.Access access = null;
        if (role.getContainer() instanceof RealmModel) {
            access = token.getRealmAccess();
            if (token.getRealmAccess() == null) {
                access = new SkeletonKeyToken.Access();
                token.setRealmAccess(access);
            } else if (token.getRealmAccess().getRoles() != null && token.getRealmAccess().isUserInRole(role.getName())) {
                return;
            }
        } else {
            ApplicationModel app = (ApplicationModel)role.getContainer();
            access = token.getResourceAccess(app.getName());
            if (access == null) {
                access = token.addAccess(app.getName());
                if (app.isSurrogateAuthRequired()) {
                    access.verifyCaller(Boolean.valueOf(true));
                }
            } else if (access.isUserInRole(role.getName())) {
                return;
            }
        }
        access.addRole(role.getName());
        if (!role.isComposite()) {
            return;
        }
        for (RoleModel composite : role.getComposites()) {
            this.addComposites(token, composite);
        }
    }

    protected void createToken(AccessCodeEntry accessCodeEntry, RealmModel realm, UserModel client, UserModel user) {
        SkeletonKeyToken token = this.initToken(realm, client, user);
        if (accessCodeEntry.getRealmRolesRequested().size() > 0) {
            for (RoleModel role : accessCodeEntry.getRealmRolesRequested()) {
                this.addComposites(token, role);
            }
        }
        if (accessCodeEntry.getResourceRolesRequested().size() > 0) {
            for (List roles : accessCodeEntry.getResourceRolesRequested().values()) {
                for (RoleModel role : roles) {
                    this.addComposites(token, role);
                }
            }
        }
        accessCodeEntry.setToken(token);
    }

    public String encodeScope(SkeletonKeyScope scope) {
        String token = null;
        try {
            token = JsonSerialization.writeValueAsString((Object)scope);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Base64Url.encode((byte[])token.getBytes());
    }

    public SkeletonKeyScope decodeScope(String scopeParam) {
        SkeletonKeyScope scope = null;
        byte[] bytes = Base64Url.decode((String)scopeParam);
        try {
            scope = (SkeletonKeyScope)JsonSerialization.readValue((byte[])bytes, SkeletonKeyScope.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return scope;
    }

    public SkeletonKeyToken createAccessToken(RealmModel realm, UserModel user) {
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(KeycloakModelUtils.generateId());
        token.issuedNow();
        token.principal(user.getLoginName());
        token.audience(realm.getName());
        if (realm.getTokenLifespan() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)realm.getTokenLifespan());
        }
        for (RoleModel role : realm.getRoleMappings(user)) {
            this.addComposites(token, role);
        }
        return token;
    }

    public String encodeToken(RealmModel realm, Object token) {
        String encodedToken = new JWSBuilder().jsonContent(token).rsa256(realm.getPrivateKey());
        return encodedToken;
    }
}

