/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.security.PublicKey;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.account.Account;
import org.keycloak.account.AccountLoader;
import org.keycloak.account.AccountPages;
import org.keycloak.jaxrs.JaxrsOAuthClient;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;

public class AccountService {
    private static final Logger logger = Logger.getLogger(AccountService.class);
    public static final String ACCOUNT_IDENTITY_COOKIE = "KEYCLOAK_ACCOUNT_IDENTITY";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    private AuthenticationManager authManager = new AuthenticationManager();
    private ApplicationModel application;
    private TokenManager tokenManager;

    public AccountService(RealmModel realm, ApplicationModel application, TokenManager tokenManager) {
        this.realm = realm;
        this.application = application;
        this.tokenManager = tokenManager;
    }

    private Response forwardToPage(String path, AccountPages page) {
        AuthenticationManager.Auth auth = this.getAuth(false);
        if (auth != null) {
            if (!this.hasAccess(auth)) {
                return this.noAccess();
            }
            Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
            String referrer = this.getReferrer();
            if (referrer != null) {
                account.setReferrer(referrer);
            }
            return account.createResponse(page);
        }
        return this.login(path);
    }

    private Response noAccess() {
        return Flows.forms(this.realm, this.request, this.uriInfo).setError("No access").createErrorPage();
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    public Response accountPage() {
        List types = this.headers.getAcceptableMediaTypes();
        if (types.contains(MediaType.WILDCARD_TYPE) || types.contains(MediaType.TEXT_HTML_TYPE)) {
            return this.forwardToPage(null, AccountPages.ACCOUNT);
        }
        if (types.contains(MediaType.APPLICATION_JSON_TYPE)) {
            AuthenticationManager.Auth auth = this.getAuth(true);
            if (!this.hasAccess(auth, "view-profile")) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Cors.add(this.request, Response.ok((Object)ModelToRepresentation.toRepresentation(auth.getUser()))).auth().allowedOrigins(auth.getClient()).build();
        }
        return Response.notAcceptable((List)Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build()).build();
    }

    @Path(value="totp")
    @GET
    public Response totpPage() {
        return this.forwardToPage("totp", AccountPages.TOTP);
    }

    @Path(value="password")
    @GET
    public Response passwordPage() {
        return this.forwardToPage("password", AccountPages.PASSWORD);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processAccountUpdate(MultivaluedMap<String, String> formData) {
        AuthenticationManager.Auth auth = this.getAuth(true);
        if (!this.hasAccess(auth)) {
            return this.noAccess();
        }
        UserModel user = auth.getUser();
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            return account.setError(error).createResponse(AccountPages.ACCOUNT);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
        return account.setSuccess("accountUpdated").createResponse(AccountPages.ACCOUNT);
    }

    @Path(value="totp-remove")
    @GET
    public Response processTotpRemove() {
        AuthenticationManager.Auth auth = this.getAuth(true);
        if (!this.hasAccess(auth)) {
            return this.noAccess();
        }
        UserModel user = auth.getUser();
        user.setTotp(false);
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        return account.setSuccess("successTotpRemoved").createResponse(AccountPages.TOTP);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processTotpUpdate(MultivaluedMap<String, String> formData) {
        AuthenticationManager.Auth auth = this.getAuth(true);
        if (!this.hasAccess(auth)) {
            return this.noAccess();
        }
        UserModel user = auth.getUser();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        if (Validation.isEmpty(totp)) {
            return account.setError("missingTotp").createResponse(AccountPages.TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return account.setError("invalidTotp").createResponse(AccountPages.TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.realm.updateCredential(user, credentials);
        user.setTotp(true);
        return account.setSuccess("successTotp").createResponse(AccountPages.TOTP);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processPasswordUpdate(MultivaluedMap<String, String> formData) {
        AuthenticationManager.Auth auth = this.getAuth(true);
        if (!this.hasAccess(auth)) {
            return this.noAccess();
        }
        UserModel user = auth.getUser();
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        String password = (String)formData.getFirst((Object)"password");
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        if (Validation.isEmpty(passwordNew)) {
            return account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return account.setError("invalidPasswordConfirm").createResponse(AccountPages.PASSWORD);
        }
        if (Validation.isEmpty(password)) {
            return account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!this.realm.validatePassword(user, password)) {
            return account.setError("invalidPasswordExisting").createResponse(AccountPages.PASSWORD);
        }
        String error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        if (error != null) {
            return account.setError(error).createResponse(AccountPages.PASSWORD);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("password");
        credentials.setValue(passwordNew);
        this.realm.updateCredential(user, credentials);
        return account.setSuccess("accountPasswordUpdated").createResponse(AccountPages.PASSWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer, @Context HttpHeaders headers) {
        try {
            URI redirectUri;
            if (error != null) {
                logger.debug("error from oauth");
                throw new ForbiddenException("error");
            }
            if (!this.realm.isEnabled()) {
                logger.debug("realm not enabled");
                throw new ForbiddenException();
            }
            UserModel client = this.application.getApplicationUser();
            if (!client.isEnabled() || !this.application.isEnabled()) {
                logger.debug("account management app not enabled");
                throw new ForbiddenException();
            }
            if (code == null) {
                logger.debug("code not specified");
                throw new BadRequestException();
            }
            if (state == null) {
                logger.debug("state not specified");
                throw new BadRequestException();
            }
            JWSInput input = new JWSInput(code);
            boolean verifiedCode = false;
            try {
                verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
            }
            catch (Exception ignored) {
                logger.debug("Failed to verify signature", (Throwable)ignored);
            }
            if (!verifiedCode) {
                logger.debug("unverified access code");
                throw new BadRequestException();
            }
            String key = input.readContentAsString();
            AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
            if (accessCode == null) {
                logger.debug("bad access code");
                throw new BadRequestException();
            }
            if (accessCode.isExpired()) {
                logger.debug("access code expired");
                throw new BadRequestException();
            }
            if (!accessCode.getToken().isActive()) {
                logger.debug("access token expired");
                throw new BadRequestException();
            }
            if (!accessCode.getRealm().getId().equals(this.realm.getId())) {
                logger.debug("bad realm");
                throw new BadRequestException();
            }
            if (!client.getLoginName().equals(accessCode.getClient().getLoginName())) {
                logger.debug("bad client");
                throw new BadRequestException();
            }
            URI accountUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()});
            URI uRI = redirectUri = path != null ? accountUri.resolve(path) : accountUri;
            if (referrer != null) {
                redirectUri = redirectUri.resolve("?referrer=" + referrer);
            }
            NewCookie cookie = this.authManager.createAccountIdentityCookie(this.realm, accessCode.getUser(), client, Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()}));
            Response response = Response.status((int)302).cookie(new NewCookie[]{cookie}).location(redirectUri).build();
            return response;
        }
        finally {
            this.authManager.expireCookie("OAuth_Token_Request_State", this.uriInfo.getAbsolutePath().getRawPath());
        }
    }

    @Path(value="logout")
    @GET
    public Response logout() {
        URI baseUri = Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()});
        this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
        this.authManager.expireAccountIdentityCookie(baseUri);
        return Response.status((int)302).location(baseUri).build();
    }

    private Response login(String path) {
        String referrer;
        JaxrsOAuthClient oauth = new JaxrsOAuthClient();
        String authUrl = Urls.realmLoginPage(this.uriInfo.getBaseUri(), this.realm.getName()).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("account");
        UriBuilder uriBuilder = Urls.accountPageBuilder(this.uriInfo.getBaseUri()).path(AccountService.class, "loginRedirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = this.getReferrer()) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect(this.uriInfo, accountUri.toString());
    }

    private AuthenticationManager.Auth getAuth(boolean error) {
        AuthenticationManager.Auth auth = this.authManager.authenticateAccountIdentity(this.realm, this.uriInfo, this.headers);
        if (auth == null && error) {
            throw new ForbiddenException();
        }
        return auth;
    }

    private boolean hasAccess(AuthenticationManager.Auth auth) {
        return this.hasAccess(auth, null);
    }

    private boolean hasAccess(AuthenticationManager.Auth auth, String role) {
        UserModel user;
        UserModel client = auth.getClient();
        if (this.realm.hasRole(client, this.realm.getRole("KEYCLOAK__APPLICATION")) && (this.hasRole(user = auth.getUser(), "manage-account") || role != null && this.hasRole(user, role))) {
            return true;
        }
        SkeletonKeyToken.Access access = auth.getToken().getResourceAccess(this.application.getName());
        return access != null && (access.isUserInRole("manage-account") || role != null && access.isUserInRole(role));
    }

    private boolean hasRole(UserModel user, String role) {
        return this.realm.hasRole(user, this.application.getRole(role));
    }

    private String getReferrer() {
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer != null) {
            return referrer;
        }
        String referrerUrl = this.headers.getHeaderString("Referer");
        if (referrerUrl != null) {
            for (ApplicationModel a : this.realm.getApplications()) {
                if (a.getBaseUrl() == null || !referrerUrl.startsWith(a.getBaseUrl())) continue;
                return a.getName();
            }
            return null;
        }
        return null;
    }
}

