/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.SkeletonKeyContextResolver;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelProvider;
import org.keycloak.models.utils.ModelProviderUtils;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.admin.AdminService;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory factory = KeycloakApplication.createSessionFactory();
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context) {
        this.contextPath = context.getContextPath();
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.factory);
        TokenManager tokenManager = new TokenManager();
        this.singletons.add(new RealmsResource(tokenManager));
        this.singletons.add(new AdminService(tokenManager));
        this.singletons.add(new SocialResource(tokenManager, new SocialRequestManager()));
        this.classes.add(SkeletonKeyContextResolver.class);
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.setupDefaultRealm();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    protected void setupDefaultRealm() {
        new ApplianceBootstrap().bootstrap(this.factory);
    }

    public static KeycloakSessionFactory createSessionFactory() {
        ModelProvider provider = ModelProviderUtils.getConfiguredModelProvider();
        if (provider != null) {
            log.debug("Model provider: " + provider.getId());
            return provider.createFactory();
        }
        throw new RuntimeException("Model provider not found");
    }

    public KeycloakSessionFactory getFactory() {
        return this.factory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

