/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.RequestDetails;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

@Path(value="/social")
public class SocialResource {
    protected static Logger logger = Logger.getLogger(SocialResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    private HttpRequest request;
    @Context
    ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;
    private SocialRequestManager socialRequestManager;
    private TokenManager tokenManager;
    private AuthenticationManager authManager = new AuthenticationManager();

    public SocialResource(TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.tokenManager = tokenManager;
        this.socialRequestManager = socialRequestManager;
    }

    @GET
    @Path(value="callback")
    public Response callback() throws URISyntaxException {
        SocialUser socialUser;
        Map<String, String[]> queryParams = this.getQueryParams();
        RequestDetails requestData = this.getRequestDetails(queryParams);
        SocialProvider provider = SocialLoader.load((String)requestData.getProviderId());
        String realmName = requestData.getClientAttribute("realm");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        OAuthFlows oauth = Flows.oauth(realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!realm.isEnabled()) {
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        String clientId = (String)requestData.getClientAttributes().get("clientId");
        UserModel client = realm.getUser(clientId);
        if (client == null) {
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        String key = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".key");
        String secret = (String)realm.getSocialConfig().get(requestData.getProviderId() + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        AuthCallback callback = new AuthCallback(requestData.getSocialAttributes(), queryParams);
        try {
            socialUser = provider.processCallback(config, callback);
        }
        catch (SocialProviderException e) {
            logger.warn("Failed to process social callback", (Throwable)e);
            return oauth.forwardToSecurityFailure("Failed to process social callback");
        }
        SocialLinkModel socialLink = new SocialLinkModel(provider.getId(), socialUser.getUsername());
        UserModel user = realm.getUserBySocialLink(socialLink);
        if (user == null) {
            if (!realm.isRegistrationAllowed()) {
                return oauth.forwardToSecurityFailure("Registration not allowed");
            }
            if (realm.getUser(socialUser.getUsername()) != null) {
                throw new IllegalStateException("Username " + socialUser.getUsername() + " already registered in the realm. TODO: bind accounts...");
            }
            user = realm.addUser(socialUser.getUsername());
            user.setEnabled(true);
            user.setFirstName(socialUser.getFirstName());
            user.setLastName(socialUser.getLastName());
            user.setEmail(socialUser.getEmail());
            if (realm.isUpdateProfileOnInitialSocialLogin()) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
            }
            realm.addSocialLink(user, socialLink);
        }
        if (!user.isEnabled()) {
            return oauth.forwardToSecurityFailure("Your account is not enabled.");
        }
        String scope = (String)requestData.getClientAttributes().get("scope");
        String state = (String)requestData.getClientAttributes().get("state");
        String redirectUri = (String)requestData.getClientAttributes().get("redirectUri");
        return oauth.processAccessCode(scope, state, redirectUri, client, user);
    }

    @GET
    @Path(value="{realm}/login")
    public Response redirectToProviderAuth(@PathParam(value="realm") String realmName, @QueryParam(value="provider_id") String providerId, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scope, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirectUri) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Social provider not found").createErrorPage();
        }
        String key = (String)realm.getSocialConfig().get(providerId + ".key");
        String secret = (String)realm.getSocialConfig().get(providerId + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        UserModel client = realm.getUser(clientId);
        if (client == null) {
            logger.warn("Unknown login requester: " + clientId);
            return Flows.forms(realm, this.request, this.uriInfo).setError("Unknown login requester.").createErrorPage();
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return Flows.forms(realm, this.request, this.uriInfo).setError("Login requester not enabled.").createErrorPage();
        }
        if ((redirectUri = TokenService.verifyRedirectUri(redirectUri, client)) == null) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Invalid redirect_uri.").createErrorPage();
        }
        try {
            AuthRequest authRequest = provider.getAuthUrl(config);
            RequestDetails socialRequest = RequestDetails.create((String)providerId).putSocialAttributes(authRequest.getAttributes()).putClientAttribute("realm", realmName).putClientAttribute("clientId", clientId).putClientAttribute("scope", scope).putClientAttribute("state", state).putClientAttribute("redirectUri", redirectUri).build();
            this.socialRequestManager.addRequest(authRequest.getId(), socialRequest);
            return Response.status((Response.Status)Response.Status.FOUND).location(authRequest.getAuthUri()).build();
        }
        catch (Throwable t) {
            return Flows.forms(realm, this.request, this.uriInfo).setError("Failed to redirect to social auth").createErrorPage();
        }
    }

    private RequestDetails getRequestDetails(Map<String, String[]> queryParams) {
        for (SocialProvider provider : SocialLoader.load()) {
            String requestId;
            if (!queryParams.containsKey(provider.getRequestIdParamName()) || !this.socialRequestManager.isRequestId(requestId = queryParams.get(provider.getRequestIdParamName())[0])) continue;
            return this.socialRequestManager.retrieveData(requestId);
        }
        return null;
    }

    private Map<String, String[]> getQueryParams() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            queryParams.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return queryParams;
    }
}

