/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.LinkedList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.SkeletonKeyToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RequiredActionsService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.validation.Validation;

public class TokenService {
    protected static final Logger logger = Logger.getLogger(TokenService.class);
    protected RealmModel realm;
    protected TokenManager tokenManager;
    protected AuthenticationManager authManager = new AuthenticationManager();
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected KeycloakTransaction transaction;
    @Context
    protected ResourceContext resourceContext;
    private ResourceAdminManager resourceAdminManager = new ResourceAdminManager();

    public TokenService(RealmModel realm, TokenManager tokenManager) {
        this.realm = realm;
        this.tokenManager = tokenManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getTokenService");
        return base;
    }

    public static UriBuilder accessCodeToTokenUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "accessCodeToToken");
    }

    public static UriBuilder grantAccessTokenUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "grantAccessToken");
    }

    public static UriBuilder grantIdentityTokenUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "grantIdentityToken");
    }

    public static UriBuilder loginPageUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "loginPage");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "logout");
    }

    public static UriBuilder processLoginUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "processLogin");
    }

    public static UriBuilder processOAuthUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "processOAuth");
    }

    @Path(value="grants/identity-token")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantIdentityToken(MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            throw new NotAuthorizedException((Object)"No user", new Object[0]);
        }
        if (!this.realm.isEnabled()) {
            throw new NotAuthorizedException((Object)"Disabled realm", new Object[0]);
        }
        UserModel user = this.realm.getUser(username);
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.realm, user, form);
        if (status != AuthenticationManager.AuthenticationStatus.SUCCESS) {
            throw new NotAuthorizedException((Object)status, new Object[0]);
        }
        this.tokenManager = new TokenManager();
        SkeletonKeyToken token = this.authManager.createIdentityToken(this.realm, username);
        String encoded = this.tokenManager.encodeToken(this.realm, token);
        AccessTokenResponse res = this.accessTokenResponse(token, encoded);
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="grants/access")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantAccessToken(MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            throw new NotAuthorizedException((Object)"No user", new Object[0]);
        }
        if (!this.realm.isEnabled()) {
            throw new NotAuthorizedException((Object)"Disabled realm", new Object[0]);
        }
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotAuthorizedException((Object)"No user", new Object[0]);
        }
        if (!user.isEnabled()) {
            throw new NotAuthorizedException((Object)"Disabled user.", new Object[0]);
        }
        if (this.authManager.authenticateForm(this.realm, user, form) != AuthenticationManager.AuthenticationStatus.SUCCESS) {
            throw new NotAuthorizedException((Object)"Auth failed", new Object[0]);
        }
        SkeletonKeyToken token = this.tokenManager.createAccessToken(this.realm, user);
        String encoded = this.tokenManager.encodeToken(this.realm, token);
        AccessTokenResponse res = this.accessTokenResponse(token, encoded);
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="auth/request/login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processLogin(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        logger.debug("TokenService.processLogin");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        UserModel client = this.realm.getUser(clientId);
        if (client == null) {
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (formData.containsKey((Object)"cancel")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
        }
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.realm, user, formData);
        switch (status) {
            case SUCCESS: 
            case ACTIONS_REQUIRED: {
                return oauth.processAccessCode(scopeParam, state, redirect, client, user);
            }
            case ACCOUNT_DISABLED: {
                return Flows.forms(this.realm, this.request, this.uriInfo).setError("accountDisabled").setFormData(formData).createLogin();
            }
            case MISSING_TOTP: {
                return Flows.forms(this.realm, this.request, this.uriInfo).setFormData(formData).createLoginTotp();
            }
        }
        return Flows.forms(this.realm, this.request, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
    }

    @Path(value="auth/request/login-actions")
    public RequiredActionsService getRequiredActionsService() {
        RequiredActionsService service = new RequiredActionsService(this.realm, this.tokenManager);
        this.resourceContext.initResource((Object)service);
        return service;
    }

    @Path(value="registrations")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRegister(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        UserModel client = this.realm.getUser(clientId);
        if (client == null) {
            logger.warn("Unknown login requester.");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn("Registration not allowed");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        LinkedList<String> requiredCredentialTypes = new LinkedList<String>();
        for (RequiredCredentialModel m : this.realm.getRequiredCredentials()) {
            requiredCredentialTypes.add(m.getType());
        }
        String error = Validation.validateRegistrationForm(formData, requiredCredentialTypes);
        if (error == null) {
            error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        }
        if (error != null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError(error).setFormData(formData).createRegistration();
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = this.realm.getUser(username);
        if (user != null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError("usernameExists").setFormData(formData).createRegistration();
        }
        user = this.realm.addUser(username);
        user.setEnabled(true);
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
        if (requiredCredentialTypes.contains("password")) {
            UserCredentialModel credentials = new UserCredentialModel();
            credentials.setType("password");
            credentials.setValue((String)formData.getFirst((Object)"password"));
            this.realm.updateCredential(user, credentials);
        }
        return this.processLogin(clientId, scopeParam, state, redirect, formData);
    }

    @Path(value="access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessCodeToToken(MultivaluedMap<String, String> formData) {
        logger.debug("accessRequest <---");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            throw new NotAuthorizedException((Object)"Realm not enabled", new Object[0]);
        }
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            logger.debug("code not specified");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        String client_id = (String)formData.getFirst((Object)"client_id");
        if (client_id == null) {
            logger.debug("client_id not specified");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "client_id not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        UserModel client = this.realm.getUser(client_id);
        if (client == null) {
            logger.debug("Could not find user");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find user");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        if (!client.isEnabled()) {
            logger.debug("user is not enabled");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "User is not enabled");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.realm, client, formData);
        if (status != AuthenticationManager.AuthenticationStatus.SUCCESS) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Unable to verify code signature");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        String key = input.readContentAsString();
        AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
        if (accessCode == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (accessCode.isExpired()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!accessCode.getToken().isActive()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Token expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!client.getLoginName().equals(accessCode.getClient().getLoginName())) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        logger.debug("accessRequest SUCCESS");
        AccessTokenResponse res = this.accessTokenResponse(this.realm.getPrivateKey(), accessCode.getToken());
        return Cors.add(this.request, Response.ok((Object)res)).allowedOrigins(client).allowedMethods("POST").build();
    }

    protected AccessTokenResponse accessTokenResponse(PrivateKey privateKey, SkeletonKeyToken token) {
        String encodedToken = new JWSBuilder().jsonContent((Object)token).rsa256(privateKey);
        return this.accessTokenResponse(token, encodedToken);
    }

    protected AccessTokenResponse accessTokenResponse(SkeletonKeyToken token, String encodedToken) {
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedToken);
        res.setTokenType("bearer");
        if (token.getExpiration() != 0L) {
            long time = token.getExpiration() - System.currentTimeMillis() / 1000L;
            res.setExpiresIn(time);
        }
        return res;
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="prompt") String prompt) {
        logger.info("TokenService.loginPage");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        UserModel client = this.realm.getUser(clientId);
        if (client == null) {
            logger.warn("Unknown login requester: " + clientId);
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        logger.info("Checking roles...");
        RoleModel resourceRole = this.realm.getRole("KEYCLOAK__APPLICATION");
        RoleModel identityRequestRole = this.realm.getRole("KEYCLOAK__IDENTITY_REQUESTER");
        boolean isResource = this.realm.hasRole(client, resourceRole);
        if (!isResource && !this.realm.hasRole(client, identityRequestRole)) {
            logger.warn("Login requester not allowed to request login.");
            return oauth.forwardToSecurityFailure("Login requester not allowed to request login.");
        }
        logger.info("Checking cookie...");
        UserModel user = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers);
        if (user != null) {
            logger.debug(user.getLoginName() + " already logged in.");
            return oauth.processAccessCode(scopeParam, state, redirect, client, user);
        }
        if (prompt != null && prompt.equals("none")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        logger.info("createLogin() now...");
        return Flows.forms(this.realm, this.request, this.uriInfo).createLogin();
    }

    @Path(value="registrations")
    @GET
    public Response registerPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        logger.info("**********registerPage()");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        UserModel client = this.realm.getUser(clientId);
        if (client == null) {
            logger.warn("Unknown login requester.");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn("Registration not allowed");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
        return Flows.forms(this.realm, this.request, this.uriInfo).createRegistration();
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri) {
        UserModel user = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers);
        if (user != null) {
            logger.debug("Logging out: {0}", new Object[]{user.getLoginName()});
            this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
            this.resourceAdminManager.singleLogOut(this.realm, user.getLoginName());
        }
        return Response.status((int)302).location(UriBuilder.fromUri((String)redirectUri).build(new Object[0])).build();
    }

    @Path(value="oauth/grant")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processOAuth(MultivaluedMap<String, String> formData) {
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        String code = (String)formData.getFirst((Object)"code");
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            return oauth.forwardToSecurityFailure("Illegal access code.");
        }
        String key = input.readContentAsString();
        AccessCodeEntry accessCodeEntry = this.tokenManager.getAccessCode(key);
        if (accessCodeEntry == null) {
            return oauth.forwardToSecurityFailure("Unknown access code.");
        }
        String redirect = accessCodeEntry.getRedirectUri();
        String state = accessCodeEntry.getState();
        if (formData.containsKey((Object)"cancel")) {
            return this.redirectAccessDenied(redirect, state);
        }
        accessCodeEntry.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespan());
        return oauth.redirectAccessCode(accessCodeEntry, state, redirect);
    }

    protected Response redirectAccessDenied(String redirect, String state) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    public static String verifyRedirectUri(String redirectUri, UserModel client) {
        if (redirectUri == null) {
            return client.getRedirectUris().size() == 1 ? (String)client.getRedirectUris().iterator().next() : null;
        }
        if (client.getRedirectUris().isEmpty()) {
            return redirectUri;
        }
        String r = redirectUri.indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
        return client.getRedirectUris().contains(r) ? redirectUri : null;
    }

    private boolean checkSsl() {
        if (this.realm.isSslNotRequired()) {
            return true;
        }
        return this.uriInfo.getBaseUri().getScheme().equals("https");
    }
}

