/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.util.JsonSerialization;

public class ApplicationResource
extends RoleContainerResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected ApplicationModel application;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Application keycloak;

    protected KeycloakApplication getKeycloakApplication() {
        return (KeycloakApplication)this.keycloak;
    }

    public ApplicationResource(RealmModel realm, ApplicationModel applicationModel, KeycloakSession session) {
        super(realm, (RoleContainerModel)applicationModel);
        this.realm = realm;
        this.application = applicationModel;
        this.session = session;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(ApplicationRepresentation rep) {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        applicationManager.updateApplication(rep, this.application);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ApplicationRepresentation getApplication() {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toRepresentation(this.application);
    }

    @GET
    @NoCache
    @Path(value="installation/json")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        ApplicationManager.InstallationAdapterConfig rep = applicationManager.toInstallationRepresentation(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @GET
    @NoCache
    @Path(value="installation/jboss")
    @Produces(value={"text/plain"})
    public String getJBossInstallation() throws IOException {
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toJBossSubsystemConfig(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
    }

    @DELETE
    @NoCache
    public void deleteApplication() {
        this.realm.removeApplication(this.application.getId());
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        logger.debug("regenerateSecret");
        UserCredentialModel cred = new ApplicationManager().generateSecret(this.realm, this.application);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation(cred);
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        logger.debug("getClientSecret");
        UserCredentialModel model = this.realm.getSecret(this.application.getApplicationUser());
        if (model == null) {
            throw new NotFoundException("Application does not have a secret");
        }
        return ModelToRepresentation.toRepresentation(model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.application.getApplicationUser(), this.session);
    }

    @Path(value="allowed-origins")
    @GET
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins() {
        return this.application.getApplicationUser().getWebOrigins();
    }

    @Path(value="allowed-origins")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> allowedOrigins) {
        this.application.getApplicationUser().setWebOrigins(allowedOrigins);
    }

    @Path(value="allowed-origins")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteAllowedOrigins(Set<String> allowedOrigins) {
        for (String origin : allowedOrigins) {
            this.application.getApplicationUser().removeWebOrigin(origin);
        }
    }
}

