/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.util.JsonSerialization;

public class OAuthClientResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected OAuthClientModel oauthClient;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Application application;

    protected KeycloakApplication getApplication() {
        return (KeycloakApplication)this.application;
    }

    public OAuthClientResource(RealmModel realm, OAuthClientModel oauthClient, KeycloakSession session) {
        this.realm = realm;
        this.oauthClient = oauthClient;
        this.session = session;
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(OAuthClientRepresentation rep) {
        OAuthClientManager manager = new OAuthClientManager(this.realm);
        manager.update(rep, this.oauthClient);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public OAuthClientRepresentation getOAuthClient() {
        return OAuthClientManager.toRepresentation(this.oauthClient);
    }

    @GET
    @NoCache
    @Path(value="installation")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        OAuthClientManager manager = new OAuthClientManager(this.realm);
        OAuthClientManager.InstallationAdapterConfig rep = manager.toInstallationRepresentation(this.realm, this.oauthClient, this.getApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @DELETE
    @NoCache
    public void deleteOAuthClient() {
        this.realm.removeOAuthClient(this.oauthClient.getId());
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        logger.debug("regenerateSecret");
        UserCredentialModel cred = UserCredentialModel.generateSecret();
        this.realm.updateCredential(this.oauthClient.getOAuthAgent(), cred);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation(cred);
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        logger.debug("getClientSecret");
        UserCredentialModel model = this.realm.getSecret(this.oauthClient.getOAuthAgent());
        if (model == null) {
            throw new NotFoundException("Application does not have a secret");
        }
        return ModelToRepresentation.toRepresentation(model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.oauthClient.getOAuthAgent(), this.session);
    }
}

