/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.util.GenericType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.admin.AdminService;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.flows.Flows;

public class RealmsAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmsAdminResource.class);
    protected UserModel admin;
    protected TokenManager tokenManager;
    public static final CacheControl noCache = new CacheControl();
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected KeycloakSession session;

    public RealmsAdminResource(UserModel admin, TokenManager tokenManager) {
        this.admin = admin;
        this.tokenManager = tokenManager;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<RealmRepresentation> getRealms() {
        logger.debug("getRealms()");
        RealmManager realmManager = new RealmManager(this.session);
        List realms = this.session.getRealms(this.admin);
        ArrayList<RealmRepresentation> reps = new ArrayList<RealmRepresentation>();
        for (RealmModel realm : realms) {
            reps.add(ModelToRepresentation.toRepresentation(realm));
        }
        return reps;
    }

    public static UriBuilder realmUrl(UriInfo uriInfo) {
        return RealmsAdminResource.realmsUrl(uriInfo).path("{id}");
    }

    public static UriBuilder realmsUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(AdminService.class).path(AdminService.class, "getRealmsAdmin");
    }

    @POST
    @Consumes(value={"application/json"})
    public Response importRealm(@Context UriInfo uriInfo, RealmRepresentation rep) {
        logger.debug("importRealm: {0}", new Object[]{rep.getRealm()});
        RealmManager realmManager = new RealmManager(this.session);
        if (realmManager.getRealmByName(rep.getRealm()) != null) {
            return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
        }
        RealmModel realm = realmManager.importRealm(rep, this.admin);
        URI location = RealmsAdminResource.realmUrl(uriInfo).build(new Object[]{realm.getName()});
        logger.debug("imported realm success, sending back: {0}", new Object[]{location.toString()});
        return Response.created((URI)location).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadRealm(MultipartFormDataInput input) throws IOException {
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        RealmManager realmManager = new RealmManager(this.session);
        for (InputPart inputPart : inputParts) {
            inputPart.setMediaType(MediaType.APPLICATION_JSON_TYPE);
            RealmRepresentation rep = (RealmRepresentation)inputPart.getBody((GenericType)new GenericType<RealmRepresentation>(){});
            realmManager.importRealm(rep, this.admin);
        }
        return Response.noContent().build();
    }

    @Path(value="{realm}")
    public RealmAdminResource getRealmAdmin(@Context HttpHeaders headers, @PathParam(value="realm") String name) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(name);
        if (realm == null) {
            throw new NotFoundException("{realm} = " + name);
        }
        RealmAdminResource adminResource = new RealmAdminResource(this.admin, realm, this.tokenManager);
        this.resourceContext.initResource((Object)adminResource);
        return adminResource;
    }

    static {
        noCache.setNoCache(true);
    }
}

