/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.RoleResource;

public class RoleByIdResource
extends RoleResource {
    public RoleByIdResource(RealmModel realm) {
        super(realm);
    }

    @Path(value="{role-id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-id") String id) {
        RoleModel roleModel = this.getRoleModel(id);
        return this.getRole(roleModel);
    }

    protected RoleModel getRoleModel(String id) {
        RoleModel roleModel = this.realm.getRoleById(id);
        if (roleModel == null || roleModel.getName().startsWith("KEYCLOAK_")) {
            throw new NotFoundException("Could not find role with id: " + id);
        }
        return roleModel;
    }

    @Path(value="{role-id}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.deleteRole(role);
    }

    @Path(value="{role-id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="role-id") String id, RoleRepresentation rep) {
        RoleModel role = this.getRoleModel(id);
        this.updateRole(rep, role);
    }

    @Path(value="{role-id}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.addComposites(roles, role);
    }

    @Path(value="{role-id}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        return this.getRoleComposites(role);
    }

    @Path(value="{role-id}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-id}/composites/applications/{app}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getApplicationRoleComposites(@PathParam(value="role-id") String id, @PathParam(value="app") String appName) {
        RoleModel role = this.getRoleModel(id);
        return this.getApplicationRoleComposites(appName, role);
    }

    @Path(value="{role-id}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.deleteComposites(roles, role);
    }
}

