/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.social.SocialProvider;
import org.keycloak.util.ProviderLoader;

public class ServerInfoAdminResource {
    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        this.setSocialProviders(info);
        this.setThemes(info);
        return info;
    }

    private void setThemes(ServerInfoRepresentation info) {
        Iterable providers = ProviderLoader.load(ThemeProvider.class);
        info.themes = new HashMap();
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themes = new LinkedList();
            for (ThemeProvider p : providers) {
                themes.addAll(p.nameSet(type));
            }
            Collections.sort(themes);
            info.themes.put(type.toString().toLowerCase(), themes);
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.socialProviders = new LinkedList();
        for (SocialProvider p : ProviderLoader.load(SocialProvider.class)) {
            info.socialProviders.add(p.getId());
        }
        Collections.sort(info.socialProviders);
    }

    public static class ServerInfoRepresentation {
        private Map<String, List<String>> themes;
        private List<String> socialProviders;

        public Map<String, List<String>> getThemes() {
            return this.themes;
        }

        public List<String> getSocialProviders() {
            return this.socialProviders;
        }
    }
}

