/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.security.PublicKey;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;

public class AppAuthManager
extends AuthenticationManager {
    protected static Logger logger = Logger.getLogger(AuthenticationManager.class);
    private String cookieName;
    private TokenManager tokenManager;

    public AppAuthManager(String cookieName, TokenManager tokenManager) {
        this.cookieName = cookieName;
        this.tokenManager = tokenManager;
    }

    public NewCookie createCookie(RealmModel realm, ClientModel client, String code, URI uri) {
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            logger.debug("unverified access code");
            throw new BadRequestException();
        }
        String key = input.readContentAsString();
        AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
        if (accessCode == null) {
            logger.debug("bad access code");
            throw new BadRequestException();
        }
        if (accessCode.isExpired()) {
            logger.debug("access code expired");
            throw new BadRequestException();
        }
        if (!accessCode.getToken().isActive()) {
            logger.debug("access token expired");
            throw new BadRequestException();
        }
        if (!accessCode.getRealm().getId().equals(realm.getId())) {
            logger.debug("bad realm");
            throw new BadRequestException();
        }
        if (!client.getClientId().equals(accessCode.getClient().getClientId())) {
            logger.debug("bad client");
            throw new BadRequestException();
        }
        return this.createLoginCookie(realm, accessCode.getUser(), accessCode.getClient(), this.cookieName, uri.getRawPath(), false);
    }

    public NewCookie createRefreshCookie(RealmModel realm, UserModel user, ClientModel client, URI uri) {
        return this.createLoginCookie(realm, user, client, this.cookieName, uri.getRawPath(), false);
    }

    public void expireCookie(URI uri) {
        this.expireCookie(this.cookieName, uri.getRawPath());
    }

    public Auth authenticateCookie(RealmModel realm, HttpHeaders headers) {
        return this.authenticateCookie(realm, headers, this.cookieName, true);
    }

    public Auth authenticate(RealmModel realm, HttpHeaders headers) {
        Auth auth = this.authenticateCookie(realm, headers);
        if (auth != null) {
            return auth;
        }
        return this.authenticateBearerToken(realm, headers);
    }

    private Auth authenticateCookie(RealmModel realm, HttpHeaders headers, String cookieName, boolean checkActive) {
        logger.info("authenticateCookie");
        Cookie cookie = (Cookie)headers.getCookies().get(cookieName);
        if (cookie == null) {
            logger.info("authenticateCookie could not find cookie: {0}", new Object[]{cookieName});
            return null;
        }
        String tokenString = cookie.getValue();
        try {
            AccessToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)realm.getName(), (boolean)checkActive);
            logger.info("token verified");
            if (checkActive && !token.isActive()) {
                logger.info("cookie expired");
                this.expireCookie(cookie.getName(), cookie.getPath());
                return null;
            }
            UserModel user = realm.getUserById(token.getSubject());
            if (user == null || !user.isEnabled()) {
                logger.info("Unknown user in cookie");
                this.expireCookie(cookie.getName(), cookie.getPath());
                return null;
            }
            ClientModel client = null;
            if (!(token.getIssuedFor() == null || (client = realm.findClient(token.getIssuedFor())) != null && client.isEnabled())) {
                logger.info("Unknown client in cookie");
                this.expireCookie(cookie.getName(), cookie.getPath());
                return null;
            }
            return new Auth(realm, user, client);
        }
        catch (VerificationException e) {
            logger.info("Failed to verify cookie", (Throwable)e);
            this.expireCookie(cookie.getName(), cookie.getPath());
            return null;
        }
    }

    private Auth authenticateBearerToken(RealmModel realm, HttpHeaders headers) {
        String authHeader = headers.getHeaderString("Authorization");
        if (authHeader == null) {
            return null;
        }
        String[] split = authHeader.trim().split("\\s+");
        if (split == null || split.length != 2) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (!split[0].equalsIgnoreCase("Bearer")) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        String tokenString = split[1];
        try {
            AccessToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)realm.getName());
            if (!token.isActive()) {
                throw new NotAuthorizedException((Object)"token_expired", new Object[0]);
            }
            UserModel user = realm.getUserById(token.getSubject());
            if (user == null || !user.isEnabled()) {
                throw new NotAuthorizedException((Object)"invalid_user", new Object[0]);
            }
            ClientModel client = null;
            if (!(token.getIssuedFor() == null || (client = realm.findClient(token.getIssuedFor())) != null && client.isEnabled())) {
                throw new NotAuthorizedException((Object)"invalid_user", new Object[0]);
            }
            return new Auth(token, user, client);
        }
        catch (VerificationException e) {
            logger.error("Failed to verify token", (Throwable)e);
            throw new NotAuthorizedException((Object)"invalid_token", new Object[0]);
        }
    }
}

