/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.account.Account;
import org.keycloak.account.AccountLoader;
import org.keycloak.account.AccountPages;
import org.keycloak.jaxrs.JaxrsOAuthClient;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.SocialRequestManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderException;

public class AccountService {
    private static final Logger logger = Logger.getLogger(AccountService.class);
    public static final String KEYCLOAK_ACCOUNT_IDENTITY_COOKIE = "KEYCLOAK_ACCOUNT_IDENTITY";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    private final AppAuthManager authManager;
    private final ApplicationModel application;
    private final SocialRequestManager socialRequestManager;

    public AccountService(RealmModel realm, ApplicationModel application, TokenManager tokenManager, SocialRequestManager socialRequestManager) {
        this.realm = realm;
        this.application = application;
        this.authManager = new AppAuthManager(KEYCLOAK_ACCOUNT_IDENTITY_COOKIE, tokenManager);
        this.socialRequestManager = socialRequestManager;
    }

    public static UriBuilder accountServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
        return base;
    }

    private Response forwardToPage(String path, AccountPages page) {
        Auth auth = this.getAuth(false);
        if (auth != null) {
            try {
                this.require(auth, "manage-account");
            }
            catch (ForbiddenException e) {
                return Flows.forms(this.realm, this.request, this.uriInfo).setError("No access").createErrorPage();
            }
            Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
            String referrer = this.getReferrer();
            if (referrer != null) {
                account.setReferrer(referrer);
            }
            return account.createResponse(page);
        }
        return this.login(path);
    }

    @Path(value="/")
    @OPTIONS
    public Response accountPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    public Response accountPage() {
        List types = this.headers.getAcceptableMediaTypes();
        if (types.contains(MediaType.WILDCARD_TYPE) || types.contains(MediaType.TEXT_HTML_TYPE)) {
            return this.forwardToPage(null, AccountPages.ACCOUNT);
        }
        if (types.contains(MediaType.APPLICATION_JSON_TYPE)) {
            Auth auth = this.getAuth(true);
            this.requireOneOf(auth, "manage-account", "view-profile");
            return Cors.add(this.request, Response.ok((Object)ModelToRepresentation.toRepresentation(auth.getUser()))).auth().allowedOrigins(auth.getClient()).build();
        }
        return Response.notAcceptable((List)Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build()).build();
    }

    @Path(value="totp")
    @GET
    public Response totpPage() {
        return this.forwardToPage("totp", AccountPages.TOTP);
    }

    @Path(value="password")
    @GET
    public Response passwordPage() {
        return this.forwardToPage("password", AccountPages.PASSWORD);
    }

    @Path(value="social")
    @GET
    public Response socialPage() {
        return this.forwardToPage("social", AccountPages.SOCIAL);
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processAccountUpdate(MultivaluedMap<String, String> formData) {
        Auth auth = this.getAuth(true);
        this.require(auth, "manage-account");
        UserModel user = auth.getUser();
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        String error = Validation.validateUpdateProfileForm(formData);
        if (error != null) {
            return account.setError(error).createResponse(AccountPages.ACCOUNT);
        }
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
        return account.setSuccess("accountUpdated").createResponse(AccountPages.ACCOUNT);
    }

    @Path(value="totp-remove")
    @GET
    public Response processTotpRemove() {
        Auth auth = this.getAuth(true);
        this.require(auth, "manage-account");
        UserModel user = auth.getUser();
        user.setTotp(false);
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        return account.setSuccess("successTotpRemoved").createResponse(AccountPages.TOTP);
    }

    @Path(value="totp")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processTotpUpdate(MultivaluedMap<String, String> formData) {
        Auth auth = this.getAuth(true);
        this.require(auth, "manage-account");
        UserModel user = auth.getUser();
        String totp = (String)formData.getFirst((Object)"totp");
        String totpSecret = (String)formData.getFirst((Object)"totpSecret");
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        if (Validation.isEmpty(totp)) {
            return account.setError("missingTotp").createResponse(AccountPages.TOTP);
        }
        if (!new TimeBasedOTP().validate(totp, totpSecret.getBytes())) {
            return account.setError("invalidTotp").createResponse(AccountPages.TOTP);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("totp");
        credentials.setValue(totpSecret);
        this.realm.updateCredential(user, credentials);
        user.setTotp(true);
        return account.setSuccess("successTotp").createResponse(AccountPages.TOTP);
    }

    @Path(value="password")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processPasswordUpdate(MultivaluedMap<String, String> formData) {
        Auth auth = this.getAuth(true);
        this.require(auth, "manage-account");
        UserModel user = auth.getUser();
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        String password = (String)formData.getFirst((Object)"password");
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        if (Validation.isEmpty(passwordNew)) {
            return account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!passwordNew.equals(passwordConfirm)) {
            return account.setError("invalidPasswordConfirm").createResponse(AccountPages.PASSWORD);
        }
        if (Validation.isEmpty(password)) {
            return account.setError("missingPassword").createResponse(AccountPages.PASSWORD);
        }
        if (!this.realm.validatePassword(user, password)) {
            return account.setError("invalidPasswordExisting").createResponse(AccountPages.PASSWORD);
        }
        String error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        if (error != null) {
            return account.setError(error).createResponse(AccountPages.PASSWORD);
        }
        UserCredentialModel credentials = new UserCredentialModel();
        credentials.setType("password");
        credentials.setValue(passwordNew);
        this.realm.updateCredential(user, credentials);
        return account.setSuccess("accountPasswordUpdated").createResponse(AccountPages.PASSWORD);
    }

    @Path(value="social-update")
    @GET
    public Response processSocialUpdate(@QueryParam(value="action") String action, @QueryParam(value="provider_id") String providerId) {
        Auth auth = this.getAuth(true);
        this.require(auth, "manage-account");
        UserModel user = auth.getUser();
        Account account = AccountLoader.load().createAccount(this.uriInfo).setRealm(this.realm).setUser(auth.getUser());
        if (Validation.isEmpty(providerId)) {
            return account.setError("missingSocialProvider").createResponse(AccountPages.SOCIAL);
        }
        AccountSocialAction accountSocialAction = AccountSocialAction.getAction(action);
        if (accountSocialAction == null) {
            return account.setError("invalidSocialAction").createResponse(AccountPages.SOCIAL);
        }
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            return account.setError("socialProviderNotFound").createResponse(AccountPages.SOCIAL);
        }
        if (!user.isEnabled()) {
            return account.setError("accountDisabled").createResponse(AccountPages.SOCIAL);
        }
        switch (accountSocialAction) {
            case ADD: {
                String redirectUri = UriBuilder.fromUri((URI)Urls.accountSocialPage(this.uriInfo.getBaseUri(), this.realm.getName())).build(new Object[0]).toString();
                try {
                    return Flows.social(this.socialRequestManager, this.realm, this.uriInfo, provider).putClientAttribute("realm", this.realm.getName()).putClientAttribute("clientId", "account").putClientAttribute("state", UUID.randomUUID().toString()).putClientAttribute("redirectUri", redirectUri).putClientAttribute("userId", user.getId()).redirectToSocialProvider();
                }
                catch (SocialProviderException spe) {
                    return account.setError("socialRedirectError").createResponse(AccountPages.SOCIAL);
                }
            }
            case REMOVE: {
                if (this.realm.removeSocialLink(user, providerId)) {
                    logger.debug("Social provider " + providerId + " removed successfully from user " + user.getLoginName());
                    return account.setSuccess("socialProviderRemoved").createResponse(AccountPages.SOCIAL);
                }
                return account.setError("socialLinkNotActive").createResponse(AccountPages.SOCIAL);
            }
        }
        logger.warn("Action is null!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @QueryParam(value="referrer") String referrer, @Context HttpHeaders headers) {
        Response response;
        try {
            URI redirectUri;
            if (error != null) {
                logger.debug("error from oauth");
                throw new ForbiddenException("error");
            }
            if (!this.realm.isEnabled()) {
                logger.debug("realm not enabled");
                throw new ForbiddenException();
            }
            if (!this.application.isEnabled()) {
                logger.debug("account management app not enabled");
                throw new ForbiddenException();
            }
            if (code == null) {
                logger.debug("code not specified");
                throw new BadRequestException();
            }
            if (state == null) {
                logger.debug("state not specified");
                throw new BadRequestException();
            }
            URI accountUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()});
            URI uRI = redirectUri = path != null ? accountUri.resolve(path) : accountUri;
            if (referrer != null) {
                redirectUri = redirectUri.resolve("?referrer=" + referrer);
            }
            NewCookie cookie = this.authManager.createCookie(this.realm, (ClientModel)this.application, code, Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()}));
            response = Response.status((int)302).cookie(new NewCookie[]{cookie}).location(redirectUri).build();
        }
        catch (Throwable throwable) {
            this.authManager.expireCookie(Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()}));
            throw throwable;
        }
        this.authManager.expireCookie(Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()}));
        return response;
    }

    @Path(value="logout")
    @GET
    public Response logout() {
        URI baseUri = Urls.accountBase(this.uriInfo.getBaseUri()).build(new Object[]{this.realm.getName()});
        this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
        this.authManager.expireCookie(baseUri);
        return Response.status((int)302).location(baseUri).build();
    }

    private Response login(String path) {
        String referrer;
        JaxrsOAuthClient oauth = new JaxrsOAuthClient();
        String authUrl = Urls.realmLoginPage(this.uriInfo.getBaseUri(), this.realm.getName()).toString();
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("account");
        UriBuilder uriBuilder = Urls.accountPageBuilder(this.uriInfo.getBaseUri()).path(AccountService.class, "loginRedirect");
        if (path != null) {
            uriBuilder.queryParam("path", new Object[]{path});
        }
        if ((referrer = this.getReferrer()) != null) {
            uriBuilder.queryParam("referrer", new Object[]{referrer});
        }
        URI accountUri = uriBuilder.build(new Object[]{this.realm.getName()});
        oauth.setStateCookiePath(accountUri.getRawPath());
        return oauth.redirect(this.uriInfo, accountUri.toString());
    }

    private Auth getAuth(boolean error) {
        Auth auth = this.authManager.authenticate(this.realm, this.headers);
        if (auth == null && error) {
            throw new ForbiddenException();
        }
        return auth;
    }

    private String getReferrer() {
        String referrer = (String)this.uriInfo.getQueryParameters().getFirst((Object)"referrer");
        if (referrer != null) {
            return referrer;
        }
        String referrerUrl = this.headers.getHeaderString("Referer");
        if (referrerUrl != null) {
            for (ApplicationModel a : this.realm.getApplications()) {
                if (a.getBaseUrl() == null || !referrerUrl.startsWith(a.getBaseUrl())) continue;
                return a.getName();
            }
            return null;
        }
        return null;
    }

    public void require(Auth auth, String role) {
        if (!auth.hasAppRole(this.application.getName(), role)) {
            throw new ForbiddenException();
        }
    }

    public void requireOneOf(Auth auth, String ... roles) {
        if (!auth.hasOneOfAppRole(this.application.getName(), roles)) {
            throw new ForbiddenException();
        }
    }

    public static enum AccountSocialAction {
        ADD,
        REMOVE;


        public static AccountSocialAction getAction(String action) {
            if ("add".equalsIgnoreCase(action)) {
                return ADD;
            }
            if ("remove".equalsIgnoreCase(action)) {
                return REMOVE;
            }
            return null;
        }
    }
}

