/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.OAuthErrorException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RequiredActionsService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.BasicAuthHelper;

public class TokenService {
    protected static final Logger logger = Logger.getLogger(TokenService.class);
    protected RealmModel realm;
    protected TokenManager tokenManager;
    protected AuthenticationManager authManager = new AuthenticationManager();
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected KeycloakTransaction transaction;
    @Context
    protected ResourceContext resourceContext;
    private ResourceAdminManager resourceAdminManager = new ResourceAdminManager();

    public TokenService(RealmModel realm, TokenManager tokenManager) {
        this.realm = realm;
        this.tokenManager = tokenManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getTokenService");
        return base;
    }

    public static UriBuilder accessCodeToTokenUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "accessCodeToToken");
    }

    public static UriBuilder grantAccessTokenUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "grantAccessToken");
    }

    public static UriBuilder loginPageUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "loginPage");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "logout");
    }

    public static UriBuilder processLoginUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "processLogin");
    }

    public static UriBuilder processOAuthUrl(UriInfo uriInfo) {
        return TokenService.tokenServiceBaseUrl(uriInfo).path(TokenService.class, "processOAuth");
    }

    @Path(value="grants/access")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        ClientModel client = this.authorizeClient(authorizationHeader, form);
        if (client.isPublicClient()) {
            throw new ForbiddenException("Public clients are not allowed to invoke grants/access");
        }
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            throw new NotAuthorizedException((Object)"No user", new Object[0]);
        }
        if (!this.realm.isEnabled()) {
            throw new NotAuthorizedException((Object)"Disabled realm", new Object[0]);
        }
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotAuthorizedException((Object)"No user", new Object[0]);
        }
        if (!user.isEnabled()) {
            throw new NotAuthorizedException((Object)"Disabled user.", new Object[0]);
        }
        if (this.authManager.authenticateForm(this.realm, user, form) != AuthenticationManager.AuthenticationStatus.SUCCESS) {
            throw new NotAuthorizedException((Object)"Auth failed", new Object[0]);
        }
        String scope = (String)form.getFirst((Object)"scope");
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client).generateAccessToken(scope, client, user).generateIDToken().build();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="refresh")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response refreshAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        logger.info("--> refreshAccessToken");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        ClientModel client = this.authorizeClient(authorizationHeader, form);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        AccessToken accessToken = null;
        try {
            accessToken = this.tokenManager.refreshAccessToken(this.realm, client, refreshToken);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build(), (Throwable)e);
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client).accessToken(accessToken).generateIDToken().generateRefreshToken().build();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="auth/request/login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processLogin(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        logger.debug("TokenService.processLogin");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (formData.containsKey((Object)"cancel")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = this.realm.getUser(username);
        if (user == null && username.contains("@")) {
            user = this.realm.getUserByEmail(username);
        }
        if (user == null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
        }
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.realm, user, formData);
        String rememberMe = (String)formData.getFirst((Object)"rememberMe");
        boolean remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        logger.debug("*** Remember me: " + remember);
        if (remember) {
            NewCookie cookie = this.authManager.createRememberMeCookie(this.realm, this.uriInfo);
            this.response.addNewCookie(cookie);
        } else {
            this.authManager.expireRememberMeCookie(this.realm, this.uriInfo);
        }
        switch (status) {
            case SUCCESS: 
            case ACTIONS_REQUIRED: {
                return oauth.processAccessCode(scopeParam, state, redirect, client, user, remember);
            }
            case ACCOUNT_DISABLED: {
                return Flows.forms(this.realm, this.request, this.uriInfo).setError("accountDisabled").setFormData(formData).createLogin();
            }
            case MISSING_TOTP: {
                return Flows.forms(this.realm, this.request, this.uriInfo).setFormData(formData).createLoginTotp();
            }
        }
        return Flows.forms(this.realm, this.request, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
    }

    @Path(value="auth/request/login-actions")
    public RequiredActionsService getRequiredActionsService() {
        RequiredActionsService service = new RequiredActionsService(this.realm, this.tokenManager);
        this.resourceContext.initResource((Object)service);
        return service;
    }

    @Path(value="registrations")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRegister(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn("Unknown login requester.");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn("Registration not allowed");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        LinkedList<String> requiredCredentialTypes = new LinkedList<String>();
        for (RequiredCredentialModel m : this.realm.getRequiredCredentials()) {
            requiredCredentialTypes.add(m.getType());
        }
        String error = Validation.validateRegistrationForm(formData, requiredCredentialTypes);
        if (error == null) {
            error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        }
        if (error != null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError(error).setFormData(formData).createRegistration();
        }
        String username = (String)formData.getFirst((Object)"username");
        UserModel user = this.realm.getUser(username);
        if (user != null) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError("usernameExists").setFormData(formData).createRegistration();
        }
        user = this.realm.addUser(username);
        user.setEnabled(true);
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail((String)formData.getFirst((Object)"email"));
        if (requiredCredentialTypes.contains("password")) {
            UserCredentialModel credentials = new UserCredentialModel();
            credentials.setType("password");
            credentials.setValue((String)formData.getFirst((Object)"password"));
            this.realm.updateCredential(user, credentials);
        }
        return this.processLogin(clientId, scopeParam, state, redirect, formData);
    }

    @Path(value="access/codes")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response accessCodeToTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessCodeToToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        logger.debug("accessRequest <---");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            throw new NotAuthorizedException((Object)"Realm not enabled", new Object[0]);
        }
        ClientModel client = this.authorizeClient(authorizationHeader, formData);
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            throw new BadRequestException("Code not specified", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Unable to verify code signature");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        String key = input.readContentAsString();
        AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
        if (accessCode == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (accessCode.isExpired()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!accessCode.getToken().isActive()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Token expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!client.getClientId().equals(accessCode.getClient().getClientId())) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        logger.debug("accessRequest SUCCESS");
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client).accessToken(accessCode.getToken()).generateIDToken().generateRefreshToken().build();
        return Cors.add(this.request, Response.ok((Object)res)).auth().allowedOrigins(client).allowedMethods("POST").build();
    }

    protected ClientModel authorizeClient(String authorizationHeader, MultivaluedMap<String, String> formData) {
        String client_id = null;
        String clientSecret = null;
        if (authorizationHeader != null) {
            String[] usernameSecret = BasicAuthHelper.parseHeader((String)authorizationHeader);
            if (usernameSecret == null) {
                throw new NotAuthorizedException("Bad Authorization header", (Object)("Basic realm=\"" + this.realm.getName() + "\""), new Object[0]);
            }
            client_id = usernameSecret[0];
            clientSecret = usernameSecret[1];
        } else {
            logger.info("no authorization header");
            client_id = (String)formData.getFirst((Object)"client_id");
            clientSecret = (String)formData.getFirst((Object)"client_secret");
        }
        if (client_id == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        ClientModel client = this.realm.findClient(client_id);
        if (client == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isEnabled()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Client is not enabled");
            throw new BadRequestException("Client is not enabled", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isPublicClient() && !client.validateSecret(clientSecret)) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            throw new BadRequestException("Unauthorized Client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        return client;
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="prompt") String prompt) {
        logger.info("TokenService.loginPage");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn("Unknown login requester: " + clientId);
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        logger.info("Checking cookie...");
        UserModel user = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers);
        if (user != null) {
            logger.debug(user.getLoginName() + " already logged in.");
            return oauth.processAccessCode(scopeParam, state, redirect, client, user);
        }
        if (prompt != null && prompt.equals("none")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        logger.info("createLogin() now...");
        return Flows.forms(this.realm, this.request, this.uriInfo).createLogin();
    }

    @Path(value="registrations")
    @GET
    public Response registerPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        logger.info("**********registerPage()");
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn("Realm not enabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn("Unknown login requester.");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn("Login requester not enabled.");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(redirect, client)) == null) {
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn("Registration not allowed");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
        return Flows.forms(this.realm, this.request, this.uriInfo).createRegistration();
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri) {
        UserModel user = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers, false);
        if (user != null) {
            logger.info("Logging out: {0}", new Object[]{user.getLoginName()});
            this.authManager.expireIdentityCookie(this.realm, this.uriInfo);
            this.authManager.expireRememberMeCookie(this.realm, this.uriInfo);
            this.resourceAdminManager.logoutUser(this.realm, user);
        } else {
            logger.info("No user logged in for logout");
        }
        return Response.status((int)302).location(UriBuilder.fromUri((String)redirectUri).build(new Object[0])).build();
    }

    @Path(value="oauth/grant")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processOAuth(MultivaluedMap<String, String> formData) {
        OAuthFlows oauth = Flows.oauth(this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        String code = (String)formData.getFirst((Object)"code");
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            return oauth.forwardToSecurityFailure("Illegal access code.");
        }
        String key = input.readContentAsString();
        AccessCodeEntry accessCodeEntry = this.tokenManager.getAccessCode(key);
        if (accessCodeEntry == null) {
            return oauth.forwardToSecurityFailure("Unknown access code.");
        }
        String redirect = accessCodeEntry.getRedirectUri();
        String state = accessCodeEntry.getState();
        if (formData.containsKey((Object)"cancel")) {
            return this.redirectAccessDenied(redirect, state);
        }
        accessCodeEntry.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespan());
        return oauth.redirectAccessCode(accessCodeEntry, state, redirect);
    }

    protected Response redirectAccessDenied(String redirect, String state) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    public static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*")) {
                int length = validRedirect.length() - 1;
                if (redirect.startsWith(validRedirect = validRedirect.substring(0, length))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(redirect)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    public static String verifyRedirectUri(String redirectUri, ClientModel client) {
        if (redirectUri == null) {
            return client.getRedirectUris().size() == 1 ? (String)client.getRedirectUris().iterator().next() : null;
        }
        if (client.getRedirectUris().isEmpty()) {
            if (client.isPublicClient()) {
                logger.error("Client redirect uri must be registered for public client");
                return null;
            }
            return redirectUri;
        }
        String r = redirectUri.indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
        boolean valid = TokenService.matchesRedirects(client.getRedirectUris(), r);
        if (!valid && r.startsWith("http://localhost") && r.indexOf(58, "http://localhost".length()) >= 0) {
            int i = r.indexOf(58, "http://localhost".length());
            StringBuilder sb = new StringBuilder();
            sb.append(r.substring(0, i));
            i = r.indexOf(47, i);
            if (i >= 0) {
                sb.append(r.substring(i));
            }
            r = sb.toString();
            valid = TokenService.matchesRedirects(client.getRedirectUris(), r);
        }
        return valid ? redirectUri : null;
    }

    private boolean checkSsl() {
        if (this.realm.isSslNotRequired()) {
            return true;
        }
        return this.uriInfo.getBaseUri().getScheme().equals("https");
    }
}

