/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.jaxrs.JaxrsOAuthClient;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.TokenService;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.admin.ServerInfoAdminResource;
import org.keycloak.services.resources.flows.Flows;

@Path(value="/admin")
public class AdminService {
    protected static final Logger logger = Logger.getLogger(AdminService.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Providers providers;
    protected String adminPath = "/admin/index.html";
    protected AppAuthManager authManager;
    protected TokenManager tokenManager;

    public AdminService(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
        this.authManager = new AppAuthManager("KEYCLOAK_ADMIN_CONSOLE_IDENTITY", tokenManager);
    }

    public static UriBuilder adminApiUrl(UriInfo uriInfo) {
        UriBuilder base = uriInfo.getBaseUriBuilder().path(AdminService.class).path(AdminService.class, "getRealmsAdmin").path(RealmsAdminResource.class, "getRealmAdmin");
        return base;
    }

    @Path(value="keepalive")
    @GET
    @NoCache
    public Response keepalive(@Context HttpHeaders headers) {
        logger.debug("keepalive");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            throw new NotFoundException();
        }
        Auth auth = this.authManager.authenticateCookie(realm, headers);
        if (auth == null) {
            return Response.status((int)401).build();
        }
        NewCookie refreshCookie = this.authManager.createRefreshCookie(realm, auth.getUser(), auth.getClient(), AdminService.saasCookiePath(this.uriInfo).build(new Object[0]));
        return Response.noContent().cookie(new NewCookie[]{refreshCookie}).build();
    }

    @Path(value="whoami")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response whoAmI(@Context HttpHeaders headers) {
        String displayName;
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            throw new NotFoundException();
        }
        Auth auth = this.authManager.authenticateCookie(realm, headers);
        if (auth == null) {
            logger.debug("No auth cookie");
            return Response.status((int)401).build();
        }
        UserModel user = auth.getUser();
        if (user == null) {
            return Response.status((int)401).build();
        }
        if (user.getFirstName() != null || user.getLastName() != null) {
            displayName = user.getFirstName();
            if (user.getLastName() != null) {
                displayName = displayName != null ? displayName + " " + user.getLastName() : user.getLastName();
            }
        } else {
            displayName = user.getLoginName();
        }
        boolean createRealm = realm.hasRole(user, realm.getRole(AdminRoles.CREATE_REALM));
        HashMap<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();
        this.addRealmAdminAccess(realmAccess, auth.getRealm().getRoleMappings(auth.getUser()));
        return Response.ok((Object)new WhoAmI(user.getId(), Config.getAdminRealm(), displayName, createRealm, realmAccess)).build();
    }

    private void addRealmAdminAccess(Map<String, Set<String>> realmAdminAccess, Set<RoleModel> roles) {
        for (RoleModel r : roles) {
            ApplicationModel app;
            if (r.getContainer() instanceof ApplicationModel && (app = (ApplicationModel)r.getContainer()).getName().endsWith(AdminRoles.APP_SUFFIX)) {
                String realm = app.getName().substring(0, app.getName().length() - AdminRoles.APP_SUFFIX.length());
                if (!realmAdminAccess.containsKey(realm)) {
                    realmAdminAccess.put(realm, new HashSet());
                }
                realmAdminAccess.get(realm).add(r.getName());
            }
            if (!r.isComposite()) continue;
            this.addRealmAdminAccess(realmAdminAccess, r.getComposites());
        }
    }

    @Path(value="isLoggedIn.js")
    @GET
    @Produces(value={"application/javascript"})
    @NoCache
    public String isLoggedIn(@Context HttpHeaders headers) {
        logger.debug("WHOAMI Javascript start.");
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        if (realm == null) {
            return "var keycloakCookieLoggedIn = false;";
        }
        UserModel user = this.authManager.authenticateCookie(realm, headers).getUser();
        if (user == null) {
            return "var keycloakCookieLoggedIn = false;";
        }
        logger.debug("WHOAMI: " + user.getLoginName());
        return "var keycloakCookieLoggedIn = true;";
    }

    public static UriBuilder contextRoot(UriInfo uriInfo) {
        return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).replacePath("/auth");
    }

    public static UriBuilder saasCookiePath(UriInfo uriInfo) {
        return AdminService.contextRoot(uriInfo).path("rest").path(AdminService.class);
    }

    @Path(value="realms")
    public RealmsAdminResource getRealmsAdmin(@Context HttpHeaders headers) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel adminRealm = this.getAdminstrationRealm(realmManager);
        if (adminRealm == null) {
            throw new NotFoundException();
        }
        Auth auth = this.authManager.authenticate(adminRealm, headers);
        if (auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        RealmsAdminResource adminResource = new RealmsAdminResource(auth, this.tokenManager);
        this.resourceContext.initResource((Object)adminResource);
        return adminResource;
    }

    @Path(value="serverinfo")
    public ServerInfoAdminResource getServerInfo(@Context HttpHeaders headers) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel adminRealm = this.getAdminstrationRealm(realmManager);
        if (adminRealm == null) {
            throw new NotFoundException();
        }
        Auth auth = this.authManager.authenticate(adminRealm, headers);
        UserModel admin = auth.getUser();
        if (admin == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        ApplicationModel adminConsole = (ApplicationModel)adminRealm.getApplicationNameMap().get("admin-console");
        if (adminConsole == null) {
            throw new NotFoundException();
        }
        ServerInfoAdminResource adminResource = new ServerInfoAdminResource();
        this.resourceContext.initResource((Object)adminResource);
        return adminResource;
    }

    private void expireCookie() {
        this.authManager.expireCookie(AdminService.saasCookiePath(this.uriInfo).build(new Object[0]));
    }

    @Path(value="login")
    @GET
    @NoCache
    public Response loginPage(@QueryParam(value="path") String path) {
        logger.debug("loginPage ********************** <---");
        this.expireCookie();
        JaxrsOAuthClient oauth = new JaxrsOAuthClient();
        String authUrl = TokenService.loginPageUrl(this.uriInfo).build(new Object[]{Config.getAdminRealm()}).toString();
        logger.debug("authUrl: {0}", new Object[]{authUrl});
        oauth.setAuthUrl(authUrl);
        oauth.setClientId("admin-console");
        UriBuilder redirectBuilder = this.uriInfo.getBaseUriBuilder().path(AdminService.class).path(AdminService.class, "loginRedirect");
        if (path != null) {
            redirectBuilder.queryParam("path", new Object[]{path});
        }
        URI redirectUri = redirectBuilder.build(new Object[0]);
        logger.debug("redirectUri: {0}", new Object[]{redirectUri.toString()});
        oauth.setStateCookiePath(redirectUri.getRawPath());
        return oauth.redirect(this.uriInfo, redirectUri.toString());
    }

    @Path(value="login-error")
    @GET
    @NoCache
    public Response errorOnLoginRedirect(@QueryParam(value="error") String message) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        return Flows.forms(realm, this.request, this.uriInfo).setError(message).createErrorPage();
    }

    protected Response redirectOnLoginError(String message) {
        URI uri = this.uriInfo.getBaseUriBuilder().path(AdminService.class).path(AdminService.class, "errorOnLoginRedirect").queryParam("error", new Object[]{message}).build(new Object[0]);
        URI logout = TokenService.logoutUrl(this.uriInfo).queryParam("redirect_uri", new Object[]{uri.toString()}).build(new Object[]{Config.getAdminRealm()});
        return Response.status((int)302).location(logout).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="login-redirect")
    @GET
    @NoCache
    public Response loginRedirect(@QueryParam(value="code") String code, @QueryParam(value="state") String state, @QueryParam(value="error") String error, @QueryParam(value="path") String path, @Context HttpHeaders headers) {
        try {
            logger.info("loginRedirect ********************** <---");
            if (error != null) {
                logger.debug("error from oauth");
                Response response = this.redirectOnLoginError(error);
                return response;
            }
            RealmManager realmManager = new RealmManager(this.session);
            RealmModel adminRealm = this.getAdminstrationRealm(realmManager);
            if (!adminRealm.isEnabled()) {
                logger.debug("realm not enabled");
                Response response = this.redirectOnLoginError("realm not enabled");
                return response;
            }
            ApplicationModel adminConsole = (ApplicationModel)adminRealm.getApplicationNameMap().get("admin-console");
            if (!adminConsole.isEnabled()) {
                logger.debug("admin app not enabled");
                Response response = this.redirectOnLoginError("admin app not enabled");
                return response;
            }
            if (code == null) {
                logger.debug("code not specified");
                Response response = this.redirectOnLoginError("invalid login data");
                return response;
            }
            if (state == null) {
                logger.debug("state not specified");
                Response response = this.redirectOnLoginError("invalid login data");
                return response;
            }
            new JaxrsOAuthClient().checkStateCookie(this.uriInfo, headers);
            logger.debug("loginRedirect SUCCESS");
            NewCookie cookie = this.authManager.createCookie(adminRealm, (ClientModel)adminConsole, code, AdminService.saasCookiePath(this.uriInfo).build(new Object[0]));
            URI redirectUri = AdminService.contextRoot(this.uriInfo).path(this.adminPath).build(new Object[0]);
            if (path != null) {
                redirectUri = redirectUri.resolve("#" + UriBuilder.fromPath((String)path).build(new Object[0]).toString());
            }
            Response response = Response.status((int)302).cookie(new NewCookie[]{cookie}).location(redirectUri).build();
            return response;
        }
        finally {
            this.expireCookie();
        }
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout() {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = this.getAdminstrationRealm(realmManager);
        this.expireCookie();
        this.authManager.expireIdentityCookie(realm, this.uriInfo);
        return Response.status((int)302).location(this.uriInfo.getBaseUriBuilder().path(AdminService.class).path(AdminService.class, "loginPage").build(new Object[0])).build();
    }

    @Path(value="logout-cookie")
    @GET
    @NoCache
    public void logoutCookie() {
        logger.debug("*** logoutCookie");
        this.expireCookie();
    }

    protected RealmModel getAdminstrationRealm(RealmManager realmManager) {
        return realmManager.getKeycloakAdminstrationRealm();
    }

    public static class WhoAmI {
        protected String userId;
        protected String realm;
        protected String displayName;
        @JsonProperty(value="createRealm")
        protected boolean createRealm;
        @JsonProperty(value="realm_access")
        protected Map<String, Set<String>> realmAccess = new HashMap<String, Set<String>>();

        public WhoAmI() {
        }

        public WhoAmI(String userId, String realm, String displayName, boolean createRealm, Map<String, Set<String>> realmAccess) {
            this.userId = userId;
            this.realm = realm;
            this.displayName = displayName;
            this.createRealm = createRealm;
            this.realmAccess = realmAccess;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getRealm() {
            return this.realm;
        }

        public void setRealm(String realm) {
            this.realm = realm;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean isCreateRealm() {
            return this.createRealm;
        }

        public void setCreateRealm(boolean createRealm) {
            this.createRealm = createRealm;
        }

        public Map<String, Set<String>> getRealmAccess() {
            return this.realmAccess;
        }

        public void setRealmAccess(Map<String, Set<String>> realmAccess) {
            this.realmAccess = realmAccess;
        }
    }
}

