/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.ClaimResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.util.JsonSerialization;

public class ApplicationResource {
    protected static final Logger logger = Logger.getLogger(ApplicationResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    protected ApplicationModel application;
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Application keycloak;

    protected KeycloakApplication getKeycloakApplication() {
        return (KeycloakApplication)this.keycloak;
    }

    public ApplicationResource(RealmModel realm, RealmAuth auth, ApplicationModel applicationModel, KeycloakSession session) {
        this.realm = realm;
        this.auth = auth;
        this.application = applicationModel;
        this.session = session;
        auth.init(RealmAuth.Resource.APPLICATION);
    }

    @Path(value="claims")
    public ClaimResource getClaimResource() {
        return new ClaimResource((ClientModel)this.application);
    }

    @PUT
    @Consumes(value={"application/json"})
    public void update(ApplicationRepresentation rep) {
        this.auth.requireManage();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        applicationManager.updateApplication(rep, this.application);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ApplicationRepresentation getApplication() {
        this.auth.requireView();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toRepresentation(this.application);
    }

    @GET
    @NoCache
    @Path(value="installation/json")
    @Produces(value={"application/json"})
    public String getInstallation() throws IOException {
        this.auth.requireView();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        ApplicationManager.InstallationAdapterConfig rep = applicationManager.toInstallationRepresentation(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
        return JsonSerialization.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rep);
    }

    @GET
    @NoCache
    @Path(value="installation/jboss")
    @Produces(value={"text/plain"})
    public String getJBossInstallation() throws IOException {
        this.auth.requireView();
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        return applicationManager.toJBossSubsystemConfig(this.realm, this.application, this.getKeycloakApplication().getBaseUri(this.uriInfo));
    }

    @DELETE
    @NoCache
    public void deleteApplication() {
        this.auth.requireManage();
        this.realm.removeApplication(this.application.getId());
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.requireManage();
        logger.debug("regenerateSecret");
        UserCredentialModel cred = new ApplicationManager().generateSecret(this.application);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation(cred);
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.requireView();
        logger.debug("getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.application.getSecret());
        if (model == null) {
            throw new NotFoundException("Application does not have a secret");
        }
        return ModelToRepresentation.toRepresentation(model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        return new ScopeMappedResource(this.realm, this.auth, (ClientModel)this.application, this.session);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.realm, this.auth, (RoleContainerModel)this.application);
    }

    @Path(value="allowed-origins")
    @GET
    @Produces(value={"application/json"})
    public Set<String> getAllowedOrigins() {
        this.auth.requireView();
        return this.application.getWebOrigins();
    }

    @Path(value="allowed-origins")
    @PUT
    @Consumes(value={"application/json"})
    public void updateAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        this.application.setWebOrigins(allowedOrigins);
    }

    @Path(value="allowed-origins")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteAllowedOrigins(Set<String> allowedOrigins) {
        this.auth.requireManage();
        for (String origin : allowedOrigins) {
            this.application.removeWebOrigin(origin);
        }
    }

    @Path(value="push-revocation")
    @POST
    public void pushRevocation() {
        this.auth.requireManage();
        new ResourceAdminManager().pushApplicationRevocationPolicy(this.realm, this.application);
    }

    @Path(value="session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public SessionStats getSessionStats(@QueryParam(value="users") @DefaultValue(value="false") boolean users) {
        logger.info("session-stats");
        this.auth.requireView();
        if (this.application.getManagementUrl() == null || this.application.getManagementUrl().trim().equals("")) {
            logger.info("sending empty stats");
            SessionStats stats = new SessionStats();
            if (users) {
                stats.setUsers(new HashMap());
            }
            return stats;
        }
        SessionStats stats = new ResourceAdminManager().getSessionStats(this.realm, this.application, users);
        if (stats == null) {
            logger.info("app returned null stats");
        } else {
            logger.info("activeUsers: " + stats.getActiveUsers());
            logger.info("activeSessions: " + stats.getActiveSessions());
        }
        return stats;
    }

    @Path(value="logout-all")
    @POST
    public void logoutAll() {
        this.auth.requireManage();
        new ResourceAdminManager().logoutApplication(this.realm, this.application, null);
    }

    @Path(value="logout-user/{username}")
    @POST
    public void logout(@PathParam(value="username") String username) {
        this.auth.requireManage();
        UserModel user = this.realm.getUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        new ResourceAdminManager().logoutApplication(this.realm, this.application, user.getId());
    }
}

