/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.flows.Flows;

public class OAuthFlows {
    private static final Logger log = Logger.getLogger(OAuthFlows.class);
    private RealmModel realm;
    private HttpRequest request;
    private UriInfo uriInfo;
    private AuthenticationManager authManager;
    private TokenManager tokenManager;

    OAuthFlows(RealmModel realm, HttpRequest request, UriInfo uriInfo, AuthenticationManager authManager, TokenManager tokenManager) {
        this.realm = realm;
        this.request = request;
        this.uriInfo = uriInfo;
        this.authManager = authManager;
        this.tokenManager = tokenManager;
    }

    public Response redirectAccessCode(AccessCodeEntry accessCode, String state, String redirect) {
        return this.redirectAccessCode(accessCode, state, redirect, false);
    }

    public Response redirectAccessCode(AccessCodeEntry accessCode, String state, String redirect, boolean rememberMe) {
        String code = accessCode.getCode();
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirect)) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode.getId(), code).createCode();
        }
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("code", new Object[]{code});
        log.debug("redirectAccessCode: state: {0}", new Object[]{state});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        Cookie remember = (Cookie)this.request.getHttpHeaders().getCookies().get("KEYCLOAK_REMEMBER_ME");
        rememberMe = rememberMe || remember != null;
        location.cookie(new NewCookie[]{this.authManager.createLoginCookie(this.realm, accessCode.getUser(), this.uriInfo, rememberMe)});
        return location.build();
    }

    public Response redirectError(ClientModel client, String error, String state, String redirect) {
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirect)) {
            return Flows.forms(this.realm, this.request, this.uriInfo).setError(error).createCode();
        }
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{error});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    public Response processAccessCode(String scopeParam, String state, String redirect, ClientModel client, UserModel user) {
        return this.processAccessCode(scopeParam, state, redirect, client, user, false);
    }

    public Response processAccessCode(String scopeParam, String state, String redirect, ClientModel client, UserModel user, boolean rememberMe) {
        this.isTotpConfigurationRequired(user);
        this.isEmailVerificationRequired(user);
        boolean isResource = client instanceof ApplicationModel;
        AccessCodeEntry accessCode = this.tokenManager.createAccessCode(scopeParam, state, redirect, this.realm, client, user);
        log.debug("processAccessCode: isResource: {0}", new Object[]{isResource});
        log.debug("processAccessCode: go to oauth page?: {0}", new Object[]{!isResource && (accessCode.getRealmRolesRequested().size() > 0 || accessCode.getResourceRolesRequested().size() > 0)});
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            accessCode.setRequiredActions(new HashSet<UserModel.RequiredAction>(requiredActions));
            accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespanUserAction());
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode.getId(), accessCode.getCode()).setUser(user).createResponse((UserModel.RequiredAction)user.getRequiredActions().iterator().next());
        }
        if (!(isResource || accessCode.getRealmRolesRequested().size() <= 0 && accessCode.getResourceRolesRequested().size() <= 0)) {
            accessCode.setExpiration(System.currentTimeMillis() / 1000L + (long)this.realm.getAccessCodeLifespanUserAction());
            return Flows.forms(this.realm, this.request, this.uriInfo).setAccessCode(accessCode.getId(), accessCode.getCode()).setAccessRequest(accessCode.getRealmRolesRequested(), accessCode.getResourceRolesRequested()).setClient(client).createOAuthGrant();
        }
        if (redirect != null) {
            return this.redirectAccessCode(accessCode, state, redirect, rememberMe);
        }
        return null;
    }

    public Response forwardToSecurityFailure(String message) {
        return Flows.forms(this.realm, this.request, this.uriInfo).setError(message).createErrorPage();
    }

    private void isTotpConfigurationRequired(UserModel user) {
        for (RequiredCredentialModel c : this.realm.getRequiredCredentials()) {
            if (!c.getType().equals("totp") || user.isTotp()) continue;
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            log.debug("User is required to configure totp");
        }
    }

    private void isEmailVerificationRequired(UserModel user) {
        if (this.realm.isVerifyEmail() && !user.isEmailVerified()) {
            user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            log.debug("User is required to verify email");
        }
    }
}

