/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.representations.adapters.config.BaseRealmConfig;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.managers.ClaimManager;

public class OAuthClientManager {
    protected RealmModel realm;

    public OAuthClientManager(RealmModel realm) {
        this.realm = realm;
    }

    public UserCredentialModel generateSecret(OAuthClientModel app) {
        UserCredentialModel secret = UserCredentialModel.generateSecret();
        app.setSecret(secret.getValue());
        return secret;
    }

    public OAuthClientModel create(String name) {
        OAuthClientModel model = this.realm.addOAuthClient(name);
        this.generateSecret(model);
        return model;
    }

    public OAuthClientModel create(OAuthClientRepresentation rep) {
        OAuthClientModel model = this.create(rep.getName());
        this.update(rep, model);
        return model;
    }

    public void update(OAuthClientRepresentation rep, OAuthClientModel model) {
        List webOrigins;
        List redirectUris;
        if (rep.getName() != null) {
            model.setClientId(rep.getName());
        }
        if (rep.isEnabled() != null) {
            model.setEnabled(rep.isEnabled().booleanValue());
        }
        if (rep.isPublicClient() != null) {
            model.setPublicClient(rep.isPublicClient().booleanValue());
        }
        if (rep.isDirectGrantsOnly() != null) {
            model.setDirectGrantsOnly(rep.isDirectGrantsOnly().booleanValue());
        }
        if (rep.getClaims() != null) {
            ClaimManager.setClaims((ClientModel)model, rep.getClaims());
        }
        if (rep.getNotBefore() != null) {
            model.setNotBefore(rep.getNotBefore().intValue());
        }
        if (rep.getSecret() != null) {
            model.setSecret(rep.getSecret());
        }
        if ((redirectUris = rep.getRedirectUris()) != null) {
            model.setRedirectUris(new HashSet(redirectUris));
        }
        if ((webOrigins = rep.getWebOrigins()) != null) {
            model.setWebOrigins(new HashSet(webOrigins));
        }
        if (rep.getClaims() != null) {
            ClaimManager.setClaims((ClientModel)model, rep.getClaims());
        }
        if (rep.getNotBefore() != null) {
            model.setNotBefore(rep.getNotBefore().intValue());
        }
    }

    public static OAuthClientRepresentation toRepresentation(OAuthClientModel model) {
        Set webOrigins;
        OAuthClientRepresentation rep = new OAuthClientRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getClientId());
        rep.setEnabled(Boolean.valueOf(model.isEnabled()));
        rep.setPublicClient(Boolean.valueOf(model.isPublicClient()));
        rep.setDirectGrantsOnly(Boolean.valueOf(model.isDirectGrantsOnly()));
        Set redirectUris = model.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList(redirectUris));
        }
        if ((webOrigins = model.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList(webOrigins));
        }
        rep.setNotBefore(Integer.valueOf(model.getNotBefore()));
        return rep;
    }

    public InstallationAdapterConfig toInstallationRepresentation(RealmModel realmModel, OAuthClientModel model, URI baseUri) {
        InstallationAdapterConfig rep = new InstallationAdapterConfig();
        rep.setRealm(realmModel.getName());
        rep.setRealmKey(realmModel.getPublicKeyPem());
        rep.setSslNotRequired(realmModel.isSslNotRequired());
        rep.setAuthServerUrl(baseUri.toString());
        if (model.isPublicClient()) {
            rep.setPublicClient(true);
        }
        rep.setResource(model.getClientId());
        if (!model.isPublicClient()) {
            HashMap<String, String> creds = new HashMap<String, String>();
            creds.put("secret", model.getSecret());
            rep.setCredentials(creds);
        }
        return rep;
    }

    @JsonPropertyOrder(value={"realm", "realm-public-key", "auth-server-url", "ssl-not-required", "resource", "public-client", "credentials"})
    public static class InstallationAdapterConfig
    extends BaseRealmConfig {
        @JsonProperty(value="public-client")
        protected Boolean publicClient;
        @JsonProperty(value="resource")
        protected String resource;
        @JsonProperty(value="credentials")
        protected Map<String, String> credentials;

        public String getResource() {
            return this.resource;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }

        public void setCredentials(Map<String, String> credentials) {
            this.credentials = credentials;
        }

        public Boolean getPublicClient() {
            return this.publicClient;
        }

        public void setPublicClient(Boolean publicClient) {
            this.publicClient = publicClient;
        }
    }
}

