/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.ClientConnection;
import org.keycloak.audit.Audit;
import org.keycloak.audit.AuditListener;
import org.keycloak.audit.AuditProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class AuditManager {
    private Logger log = Logger.getLogger(AuditManager.class);
    private RealmModel realm;
    private KeycloakSession session;
    private ClientConnection clientConnection;

    public AuditManager(RealmModel realm, KeycloakSession session, ClientConnection clientConnection) {
        this.realm = realm;
        this.session = session;
        this.clientConnection = clientConnection;
    }

    public Audit createAudit() {
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (this.realm.isAuditEnabled()) {
            AuditProvider auditProvider = (AuditProvider)this.session.getProvider(AuditProvider.class);
            if (auditProvider != null) {
                listeners.add(auditProvider);
            } else {
                this.log.error((Object)"Audit enabled, but no audit provider configured");
            }
        }
        if (this.realm.getAuditListeners() != null) {
            for (String id : this.realm.getAuditListeners()) {
                AuditListener listener = (AuditListener)this.session.getProvider(AuditListener.class, id);
                if (listener != null) {
                    listeners.add(listener);
                    continue;
                }
                this.log.error((Object)("Audit listener '" + id + "' registered, but not found"));
            }
        }
        return new Audit(listeners, this.realm, this.clientConnection.getRemoteAddr());
    }
}

