/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.enums.SslRequired;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.RealmAuditRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ApplicationManager;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    protected KeycloakSession session;
    protected RealmProvider model;
    protected String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RealmManager(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.model.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.model.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupAdminConsole(realm);
        realm.setAuditListeners(Collections.singleton("jboss-logging"));
        return realm;
    }

    protected void setupAdminConsole(RealmModel realm) {
        RoleModel adminRole;
        ApplicationModel adminConsole = realm.getApplicationByName("security-admin-console");
        if (adminConsole == null) {
            adminConsole = new ApplicationManager(this).createApplication(realm, "security-admin-console");
        }
        String baseUrl = this.contextPath + "/admin/" + realm.getName() + "/console";
        adminConsole.setBaseUrl(baseUrl + "/index.html");
        adminConsole.setEnabled(true);
        adminConsole.setPublicClient(true);
        adminConsole.addRedirectUri(baseUrl + "/*");
        adminConsole.setFullScopeAllowed(false);
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
            ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
            adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        }
        adminConsole.addScopeMapping(adminRole);
    }

    public String getRealmAdminApplicationName(RealmModel realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBruteForceProtected(false);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
        realm.setSslRequired(SslRequired.EXTERNAL);
    }

    public boolean removeRealm(RealmModel realm) {
        boolean removed = this.model.removeRealm(realm.getId());
        if (removed) {
            new ApplicationManager(this).removeApplication(this.getKeycloakAdminstrationRealm(), realm.getMasterAdminApp());
            UserSessionProvider sessions = this.session.sessions();
            if (sessions != null) {
                sessions.onRealmRemoved(realm);
            }
        }
        return removed;
    }

    public void updateRealmAudit(RealmAuditRepresentation rep, RealmModel realm) {
        realm.setAuditEnabled(rep.isAuditEnabled());
        realm.setAuditExpiration(rep.getAuditExpiration() != null ? rep.getAuditExpiration() : 0L);
        if (rep.getAuditListeners() != null) {
            realm.setAuditListeners(new HashSet(rep.getAuditListeners()));
        }
    }

    private void setupMasterAdminManagement(RealmModel realm) {
        ImportUtils.setupMasterAdminManagement((RealmProvider)this.model, (RealmModel)realm);
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
        ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
        if (realmAdminApp == null) {
            realmAdminApp = applicationManager.createApplication(realm, realmAdminApplicationName);
        }
        RoleModel adminRole = realmAdminApp.addRole(AdminRoles.REALM_ADMIN);
        realmAdminApp.setBearerOnly(true);
        realmAdminApp.setFullScopeAllowed(false);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            adminRole.addCompositeRole(role);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null) {
            application = new ApplicationManager(this).createApplication(realm, "account");
            application.setEnabled(true);
            application.setFullScopeAllowed(false);
            String base = this.contextPath + "/realms/" + realm.getName() + "/account";
            String redirectUri = base + "/*";
            application.addRedirectUri(redirectUri);
            application.setBaseUrl(base);
            for (String role : AccountRoles.ALL) {
                application.addDefaultRole(role);
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.createRealm(id, rep.getRealm());
        this.importRealm(rep, realm);
        return realm;
    }

    public void importRealm(RealmRepresentation rep, RealmModel newRealm) {
        RepresentationToModel.importRealm((KeycloakSession)this.session, (RealmRepresentation)rep, (RealmModel)newRealm);
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return this.session.users().searchForUser(searchString.trim(), realmModel);
    }
}

