/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import org.keycloak.models.ClientModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClaimResource {
    protected ClientModel model;
    protected RealmAuth auth;

    public ClaimResource(ClientModel model, RealmAuth auth) {
        this.model = model;
        this.auth = auth;
    }

    @GET
    @Produces(value={"application/json"})
    public ClaimRepresentation getClaims() {
        this.auth.requireView();
        return ModelToRepresentation.toRepresentation((ClientModel)this.model);
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateClaims(ClaimRepresentation rep) {
        this.auth.requireManage();
        RepresentationToModel.setClaims((ClientModel)this.model, (ClaimRepresentation)rep);
    }
}

