/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.flows;

import java.util.LinkedList;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.audit.Audit;
import org.keycloak.audit.EventType;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.AccessCode;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.flows.Flows;

public class OAuthFlows {
    private static final Logger log = Logger.getLogger(OAuthFlows.class);
    private final KeycloakSession session;
    private final RealmModel realm;
    private final HttpRequest request;
    private final UriInfo uriInfo;
    private ClientConnection clientConnection;
    private final AuthenticationManager authManager;
    private final TokenManager tokenManager;

    OAuthFlows(KeycloakSession session, RealmModel realm, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection, AuthenticationManager authManager, TokenManager tokenManager) {
        this.session = session;
        this.realm = realm;
        this.request = request;
        this.uriInfo = uriInfo;
        this.clientConnection = clientConnection;
        this.authManager = authManager;
        this.tokenManager = tokenManager;
    }

    public Response redirectAccessCode(AccessCode accessCode, UserSessionModel userSession, String state, String redirect) {
        UserSessionModel oldSession;
        String oldSessionId;
        String code = accessCode.getCode();
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("code", new Object[]{code});
        log.debugv("redirectAccessCode: state: {0}", (Object)state);
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        Cookie remember = (Cookie)this.request.getHttpHeaders().getCookies().get("KEYCLOAK_REMEMBER_ME");
        Cookie sessionCookie = (Cookie)this.request.getHttpHeaders().getCookies().get("KEYCLOAK_SESSION");
        if (sessionCookie != null && !(oldSessionId = sessionCookie.getValue().split("/")[2]).equals(userSession.getId()) && (oldSession = this.session.sessions().getUserSession(this.realm, oldSessionId)) != null) {
            log.debugv("Removing old user session: session: {0}", (Object)oldSessionId);
            this.session.sessions().removeUserSession(this.realm, oldSession);
        }
        this.authManager.createLoginCookie(this.realm, accessCode.getUser(), userSession, this.uriInfo, this.clientConnection);
        if (userSession.isRememberMe()) {
            this.authManager.createRememberMeCookie(this.realm, this.uriInfo, this.clientConnection);
        }
        return location.build();
    }

    public Response redirectError(ClientModel client, String error, String state, String redirect) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{error});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    public Response processAccessCode(String scopeParam, String state, String redirect, ClientModel client, UserModel user, UserSessionModel session, Audit audit) {
        this.isTotpConfigurationRequired(user);
        this.isEmailVerificationRequired(user);
        boolean isResource = client instanceof ApplicationModel;
        AccessCode accessCode = this.tokenManager.createAccessCode(scopeParam, state, redirect, this.session, this.realm, client, user, session);
        log.debugv("processAccessCode: isResource: {0}", (Object)isResource);
        log.debugv("processAccessCode: go to oauth page?: {0}", (Object)(!isResource ? 1 : 0));
        audit.detail("code_id", accessCode.getCodeId());
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            UserModel.RequiredAction action = (UserModel.RequiredAction)user.getRequiredActions().iterator().next();
            accessCode.setRequiredAction(action);
            if (action.equals((Object)UserModel.RequiredAction.VERIFY_EMAIL)) {
                audit.clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", accessCode.getUser().getEmail()).success();
            }
            return Flows.forms(this.session, this.realm, client, this.uriInfo).setAccessCode(accessCode.getCode()).setUser(user).createResponse(action);
        }
        if (!isResource) {
            accessCode.setAction(ClientSessionModel.Action.OAUTH_GRANT);
            LinkedList<RoleModel> realmRoles = new LinkedList<RoleModel>();
            MultivaluedMapImpl resourceRoles = new MultivaluedMapImpl();
            for (RoleModel r : accessCode.getRequestedRoles()) {
                if (r.getContainer() instanceof RealmModel) {
                    realmRoles.add(r);
                    continue;
                }
                resourceRoles.add((Object)((ApplicationModel)r.getContainer()).getName(), (Object)r);
            }
            return Flows.forms(this.session, this.realm, client, this.uriInfo).setAccessCode(accessCode.getCode()).setAccessRequest(realmRoles, (MultivaluedMap)resourceRoles).setClient(client).createOAuthGrant();
        }
        if (redirect != null) {
            audit.success();
            accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN);
            return this.redirectAccessCode(accessCode, session, state, redirect);
        }
        return null;
    }

    public Response forwardToSecurityFailure(String message) {
        return Flows.forms(this.session, this.realm, null, this.uriInfo).setError(message).createErrorPage();
    }

    private void isTotpConfigurationRequired(UserModel user) {
        for (RequiredCredentialModel c : this.realm.getRequiredCredentials()) {
            if (!c.getType().equals("totp") || user.isTotp()) continue;
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            log.debug((Object)"User is required to configure totp");
        }
    }

    private void isEmailVerificationRequired(UserModel user) {
        if (this.realm.isVerifyEmail() && !user.isEmailVerified()) {
            user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            log.debug((Object)"User is required to verify email");
        }
    }
}

