/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.keycloak.audit.AuditProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.scheduled.ScheduledTask;

public class ClearExpiredAuditEvents
implements ScheduledTask {
    @Override
    public void run(KeycloakSession session) {
        AuditProvider audit = (AuditProvider)session.getProvider(AuditProvider.class);
        if (audit != null) {
            for (RealmModel realm : session.realms().getRealms()) {
                if (!realm.isAuditEnabled() || realm.getAuditExpiration() <= 0L) continue;
                long olderThan = System.currentTimeMillis() - realm.getAuditExpiration() * 1000L;
                audit.clear(realm.getId(), olderThan);
            }
        }
    }
}

