/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.enums.SslRequired;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.timer.TimerProvider;

public class RealmManager {
    protected static final Logger logger = Logger.getLogger(RealmManager.class);
    protected KeycloakSession session;
    protected RealmProvider model;
    protected String contextPath = "";

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public RealmManager(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealm(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.model.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.model.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(name, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupAdminConsole(realm);
        return realm;
    }

    protected void setupAdminConsole(RealmModel realm) {
        RoleModel adminRole;
        ApplicationModel adminConsole = realm.getApplicationByName("security-admin-console");
        if (adminConsole == null) {
            adminConsole = new ApplicationManager(this).createApplication(realm, "security-admin-console");
        }
        String baseUrl = this.contextPath + "/admin/" + realm.getName() + "/console";
        adminConsole.setBaseUrl(baseUrl + "/index.html");
        adminConsole.setEnabled(true);
        adminConsole.setPublicClient(true);
        adminConsole.addRedirectUri(baseUrl + "/*");
        adminConsole.setFullScopeAllowed(false);
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRole = realm.getRole(AdminRoles.ADMIN);
        } else {
            String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
            ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
            adminRole = realmAdminApp.getRole(AdminRoles.REALM_ADMIN);
        }
        adminConsole.addScopeMapping(adminRole);
    }

    public String getRealmAdminApplicationName(RealmModel realm) {
        return "realm-management";
    }

    public String getRealmAdminApplicationName(RealmRepresentation realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBrowserSecurityHeaders(BrowserSecurityHeaders.defaultHeaders);
        realm.setBruteForceProtected(false);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
        realm.setSslRequired(SslRequired.EXTERNAL);
    }

    public boolean removeRealm(RealmModel realm) {
        List federationProviders = realm.getUserFederationProviders();
        boolean removed = this.model.removeRealm(realm.getId());
        if (removed) {
            new ApplicationManager(this).removeApplication(this.getKeycloakAdminstrationRealm(), realm.getMasterAdminApp());
            UserSessionProvider sessions = this.session.sessions();
            if (sessions != null) {
                sessions.onRealmRemoved(realm);
            }
            UsersSyncManager usersSyncManager = new UsersSyncManager();
            for (UserFederationProviderModel fedProvider : federationProviders) {
                usersSyncManager.removePeriodicSyncForProvider((TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider);
            }
        }
        return removed;
    }

    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep, RealmModel realm) {
        realm.setEventsEnabled(rep.isEventsEnabled());
        realm.setEventsExpiration(rep.getEventsExpiration() != null ? rep.getEventsExpiration() : 0L);
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
    }

    private void setupMasterAdminManagement(RealmModel realm) {
        ImportUtils.setupMasterAdminManagement((RealmProvider)this.model, (RealmModel)realm);
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        ApplicationManager applicationManager = new ApplicationManager(new RealmManager(this.session));
        String realmAdminApplicationName = this.getRealmAdminApplicationName(realm);
        ApplicationModel realmAdminApp = realm.getApplicationByName(realmAdminApplicationName);
        if (realmAdminApp == null) {
            realmAdminApp = applicationManager.createApplication(realm, realmAdminApplicationName);
        }
        RoleModel adminRole = realmAdminApp.addRole(AdminRoles.REALM_ADMIN);
        adminRole.setDescription("${role_" + AdminRoles.REALM_ADMIN + "}");
        realmAdminApp.setBearerOnly(true);
        realmAdminApp.setFullScopeAllowed(false);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            role.setDescription("${role_" + r + "}");
            adminRole.addCompositeRole(role);
        }
    }

    private void setupAccountManagement(RealmModel realm) {
        ApplicationModel application = (ApplicationModel)realm.getApplicationNameMap().get("account");
        if (application == null) {
            application = new ApplicationManager(this).createApplication(realm, "account");
            application.setEnabled(true);
            application.setFullScopeAllowed(false);
            String base = this.contextPath + "/realms/" + realm.getName() + "/account";
            String redirectUri = base + "/*";
            application.addRedirectUri(redirectUri);
            application.setBaseUrl(base);
            for (String role : AccountRoles.ALL) {
                application.addDefaultRole(role);
                application.getRole(role).setDescription("${role_" + role + "}");
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        String id = rep.getId();
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        RealmModel realm = this.model.createRealm(id, rep.getRealm());
        realm.setName(rep.getRealm());
        this.setupRealmDefaults(realm);
        this.setupMasterAdminManagement(realm);
        if (!this.hasRealmAdminManagementApp(rep)) {
            this.setupRealmAdminManagement(realm);
        }
        if (!this.hasAccountManagementApp(rep)) {
            this.setupAccountManagement(realm);
        }
        if (!this.hasAdminConsoleApp(rep)) {
            this.setupAdminConsole(realm);
        }
        RepresentationToModel.importRealm((KeycloakSession)this.session, (RealmRepresentation)rep, (RealmModel)realm);
        List federationProviders = realm.getUserFederationProviders();
        UsersSyncManager usersSyncManager = new UsersSyncManager();
        for (UserFederationProviderModel fedProvider : federationProviders) {
            usersSyncManager.refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), fedProvider, realm.getId());
        }
        return realm;
    }

    private boolean hasRealmAdminManagementApp(RealmRepresentation rep) {
        if (rep.getApplications() == null) {
            return false;
        }
        for (ApplicationRepresentation app : rep.getApplications()) {
            if (!app.getName().equals(this.getRealmAdminApplicationName(rep))) continue;
            return true;
        }
        return false;
    }

    private boolean hasAccountManagementApp(RealmRepresentation rep) {
        if (rep.getApplications() == null) {
            return false;
        }
        for (ApplicationRepresentation app : rep.getApplications()) {
            if (!app.getName().equals("account")) continue;
            return true;
        }
        return false;
    }

    private boolean hasAdminConsoleApp(RealmRepresentation rep) {
        if (rep.getApplications() == null) {
            return false;
        }
        for (ApplicationRepresentation app : rep.getApplications()) {
            if (!app.getName().equals("security-admin-console")) continue;
            return true;
        }
        return false;
    }

    public List<UserModel> searchUsers(String searchString, RealmModel realmModel) {
        if (searchString == null) {
            return Collections.emptyList();
        }
        return this.session.users().searchForUser(searchString.trim(), realmModel);
    }
}

