/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.FederatedIdentity;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialIdentityProvider;
import org.keycloak.util.ObjectUtil;

public class IdentityBrokerService
implements IdentityProvider.AuthenticationCallback {
    private static final Logger LOGGER = Logger.getLogger(IdentityBrokerService.class);
    public static final String BROKER_PROVIDER_ID = "BROKER_PROVIDER_ID";
    private final RealmModel realmModel;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    private EventBuilder event;

    public IdentityBrokerService(RealmModel realmModel) {
        if (realmModel == null) {
            throw new IllegalArgumentException("Realm can not be null.");
        }
        this.realmModel = realmModel;
    }

    public void init() {
        this.event = new EventBuilder(this.realmModel, this.session, this.clientConnection).event(EventType.IDENTITY_PROVIDER_LOGIN);
    }

    @GET
    @Path(value="/{provider_id}/login")
    public Response performLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        this.event.detail("identity_provider", providerId);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Sending authentication request to identity provider [%s].", (Object)providerId);
        }
        try {
            ClientSessionCode clientSessionCode = this.parseClientSessionCode(code);
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
            Response response = identityProvider.handleRequest(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                this.event.success();
                if (this.isDebugEnabled()) {
                    LOGGER.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage("couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @Path(value="{provider_id}/endpoint")
    public Object getEndpoint(@PathParam(value="provider_id") String providerId) {
        IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
        Object callback = identityProvider.callback(this.realmModel, (IdentityProvider.AuthenticationCallback)this, this.event);
        ResteasyProviderFactory.getInstance().injectProperties(callback);
        return callback;
    }

    @Path(value="{provider_id}/token")
    @OPTIONS
    public Response retrieveTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @Path(value="{provider_id}/token")
    public Response retrieveToken(@PathParam(value="provider_id") String providerId) {
        return this.getToken(providerId, false);
    }

    private Response getToken(String providerId, boolean forceRetrieval) {
        this.event.event(EventType.IDENTITY_PROVIDER_RETRIEVE_TOKEN);
        try {
            AppAuthManager authManager = new AppAuthManager();
            AuthenticationManager.AuthResult authResult = authManager.authenticateBearerToken(this.session, this.realmModel, this.uriInfo, this.clientConnection, this.request.getHttpHeaders());
            if (authResult != null) {
                String audience = authResult.getToken().getAudience();
                ClientModel clientModel = this.realmModel.findClient(audience);
                if (clientModel == null) {
                    return this.badRequest("Invalid client.");
                }
                if (!clientModel.isAllowedRetrieveTokenFromIdentityProvider(providerId)) {
                    return this.corsResponse(this.badRequest("Client [" + audience + "] not authorized to retrieve tokens from identity provider [" + providerId + "]."), clientModel);
                }
                if (OAuthClientModel.class.isInstance(clientModel) && !forceRetrieval) {
                    return this.corsResponse(Flows.forms(this.session, this.realmModel, clientModel, this.uriInfo, this.headers).setClientSessionCode(authManager.extractAuthorizationHeaderToken(this.request.getHttpHeaders())).setAccessRequest("Your information from " + providerId + " identity provider.").setClient(clientModel).setActionUri(this.uriInfo.getRequestUri()).createOAuthGrant(null), clientModel);
                }
                IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
                IdentityProviderModel identityProviderConfig = this.getIdentityProviderConfig(providerId);
                if (identityProviderConfig.isStoreToken()) {
                    FederatedIdentityModel identity = this.session.users().getFederatedIdentity(authResult.getUser(), providerId, this.realmModel);
                    if (identity == null) {
                        return this.corsResponse(this.badRequest("User [" + authResult.getUser().getId() + "] is not associated with identity provider [" + providerId + "]."), clientModel);
                    }
                    this.event.success();
                    return this.corsResponse(identityProvider.retrieveToken(identity), clientModel);
                }
                return this.corsResponse(this.badRequest("Identity Provider [" + providerId + "] does not support this operation."), clientModel);
            }
            return this.badRequest("Invalid token.");
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotObtainTokenMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorRetrievingTokenMessage", e, providerId);
        }
    }

    @POST
    @Path(value="{provider_id}/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response consentTokenRetrieval(@PathParam(value="provider_id") String providerId, MultivaluedMap<String, String> formData) {
        if (formData.containsKey((Object)"cancel")) {
            return this.redirectToErrorPage("permissionNotApprovedMessage", new Object[0]);
        }
        return this.getToken(providerId, true);
    }

    public Response authenticated(Map<String, String> userNotes, IdentityProviderModel identityProviderConfig, FederatedIdentity federatedIdentity, String code) {
        ClientSessionCode clientCode = null;
        try {
            clientCode = this.parseClientSessionCode(code);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("identityProviderAuthenticationFailedMessage", e, identityProviderConfig.getProviderId());
        }
        String providerId = identityProviderConfig.getAlias();
        if (!identityProviderConfig.isStoreToken()) {
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Token will not be stored for identity provider [%s].", (Object)providerId);
            }
            federatedIdentity.setToken(null);
        }
        federatedIdentity.setIdentityProviderId(providerId);
        ClientSessionModel clientSession = clientCode.getClientSession();
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, federatedIdentity.getId(), federatedIdentity.getUsername(), federatedIdentity.getToken());
        this.event.event(EventType.IDENTITY_PROVIDER_LOGIN).detail("redirect_uri", clientSession.getRedirectUri()).detail("identity_provider_identity", federatedIdentity.getUsername());
        UserModel federatedUser = this.session.users().getUserByFederatedIdentity(federatedIdentityModel, this.realmModel);
        if (clientSession.getUserSession() != null) {
            UserSessionModel userSession = clientSession.getUserSession();
            for (Map.Entry<String, String> entry : userNotes.entrySet()) {
                userSession.setNote(entry.getKey(), entry.getValue());
            }
            return this.performAccountLinking(clientSession, providerId, federatedIdentityModel, federatedUser);
        }
        if (federatedUser == null) {
            try {
                federatedUser = this.createUser(federatedIdentity);
                if (identityProviderConfig.isUpdateProfileFirstLogin()) {
                    if (this.isDebugEnabled()) {
                        LOGGER.debugf("Identity provider requires update profile action.", (Object)federatedUser);
                    }
                    federatedUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
                }
            }
            catch (Exception e) {
                return this.redirectToLoginPage(e, clientCode);
            }
        }
        this.updateFederatedIdentity(federatedIdentity, federatedUser);
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realmModel, federatedUser, federatedUser.getUsername(), this.clientConnection.getRemoteAddr(), "broker", false, federatedIdentity.getBrokerSessionId(), federatedIdentity.getBrokerUserId());
        this.event.user(federatedUser);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        for (Map.Entry<String, String> entry : userNotes.entrySet()) {
            userSession.setNote(entry.getKey(), entry.getValue());
        }
        userSession.setNote(BROKER_PROVIDER_ID, providerId);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Performing local authentication for user [%s].", (Object)federatedUser);
        }
        return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
    }

    private Response performAccountLinking(ClientSessionModel clientSession, String providerId, FederatedIdentityModel federatedIdentityModel, UserModel federatedUser) {
        this.event.event(EventType.IDENTITY_PROVIDER_ACCCOUNT_LINKING);
        if (federatedUser != null) {
            return this.redirectToErrorPage("identityProviderAlreadyLinkedMessage", providerId);
        }
        UserModel authenticatedUser = clientSession.getUserSession().getUser();
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Linking account [%s] from identity provider [%s] to user [%s].", (Object)federatedIdentityModel, (Object)providerId, (Object)authenticatedUser);
        }
        if (!authenticatedUser.isEnabled()) {
            this.fireErrorEvent("user_disabled");
            return this.redirectToErrorPage("accountDisabledMessage", new Object[0]);
        }
        if (!authenticatedUser.hasRole(this.realmModel.getApplicationByName("account").getRole("manage-account"))) {
            this.fireErrorEvent("not_allowed");
            return this.redirectToErrorPage("insufficientPermissionMessage", new Object[0]);
        }
        this.session.users().addFederatedIdentity(this.realmModel, authenticatedUser, federatedIdentityModel);
        this.event.success();
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private void updateFederatedIdentity(FederatedIdentity updatedIdentity, UserModel federatedUser) {
        FederatedIdentityModel federatedIdentityModel = this.session.users().getFederatedIdentity(federatedUser, updatedIdentity.getIdentityProviderId(), this.realmModel);
        if (!ObjectUtil.isEqualOrNull((Object)updatedIdentity.getToken(), (Object)federatedIdentityModel.getToken())) {
            federatedIdentityModel.setToken(updatedIdentity.getToken());
            this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)updatedIdentity.getIdentityProviderId());
            }
        }
    }

    private ClientSessionCode parseClientSessionCode(String code) {
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realmModel);
        if (clientCode != null && clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE)) {
            ClientSessionModel clientSession = clientCode.getClientSession();
            if (clientSession != null) {
                ClientModel client = clientSession.getClient();
                if (client == null) {
                    throw new IdentityBrokerException("Invalid client");
                }
                LOGGER.debugf("Got authorization code from client [%s].", (Object)client.getClientId());
                this.event.client(client);
                if (clientSession.getUserSession() != null) {
                    this.event.session(clientSession.getUserSession());
                }
            }
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Authorization code is valid.", new Object[0]);
            }
            return clientCode;
        }
        throw new IdentityBrokerException("Invalid code, please login again through your application.");
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode clientSessionCode) {
        ClientSessionModel clientSession = null;
        String relayState = null;
        if (clientSessionCode != null) {
            clientSession = clientSessionCode.getClientSession();
            relayState = clientSessionCode.getCode();
        }
        return new AuthenticationRequest(this.session, this.realmModel, clientSession, this.request, this.uriInfo, relayState, this.getRedirectUri(providerId));
    }

    private String getRedirectUri(String providerId) {
        return Urls.identityProviderAuthnResponse(this.uriInfo.getBaseUri(), providerId, this.realmModel.getName()).toString();
    }

    private Response redirectToErrorPage(String message, Object ... parameters) {
        return this.redirectToErrorPage(message, null, parameters);
    }

    private Response redirectToErrorPage(String message, Throwable throwable, Object ... parameters) {
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message, throwable);
        return Flows.forwardToSecurityFailurePage(this.session, this.realmModel, this.uriInfo, this.headers, message, parameters);
    }

    private Response redirectToLoginPage(Throwable t, ClientSessionCode clientCode) {
        String message = t.getMessage();
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message);
        return Flows.forms(this.session, this.realmModel, clientCode.getClientSession().getClient(), this.uriInfo, this.headers).setClientSessionCode(clientCode.getCode()).setError(message, new Object[0]).createLogin();
    }

    private Response badRequest(String message) {
        this.fireErrorEvent(message);
        return Flows.errors().error(message, Response.Status.BAD_REQUEST);
    }

    public static IdentityProvider getIdentityProvider(KeycloakSession session, RealmModel realm, String alias) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProviderByAlias(alias);
        if (identityProviderModel != null) {
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(session, identityProviderModel);
            if (providerFactory == null) {
                throw new IdentityBrokerException("Could not find factory for identity provider [" + alias + "].");
            }
            return providerFactory.create(identityProviderModel);
        }
        throw new IdentityBrokerException("Identity Provider [" + alias + "] not found.");
    }

    private static IdentityProviderFactory getIdentityProviderFactory(KeycloakSession session, IdentityProviderModel model) {
        HashMap<String, IdentityProviderFactory> availableProviders = new HashMap<String, IdentityProviderFactory>();
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            availableProviders.put(providerFactory.getId(), (IdentityProviderFactory)providerFactory);
        }
        return (IdentityProviderFactory)availableProviders.get(model.getProviderId());
    }

    private IdentityProviderModel getIdentityProviderConfig(String providerId) {
        for (IdentityProviderModel model : this.realmModel.getIdentityProviders()) {
            if (!model.getAlias().equals(providerId)) continue;
            return model;
        }
        throw new IdentityBrokerException("Configuration for identity provider [" + providerId + "] not found.");
    }

    private UserModel createUser(FederatedIdentity updatedIdentity) {
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(updatedIdentity.getIdentityProviderId(), updatedIdentity.getId(), updatedIdentity.getUsername(), updatedIdentity.getToken());
        UserModel existingUser = null;
        if (updatedIdentity.getEmail() != null) {
            existingUser = this.session.users().getUserByEmail(updatedIdentity.getEmail(), this.realmModel);
        }
        if (existingUser != null) {
            this.fireErrorEvent("federated_identity_email_exists");
            throw new IdentityBrokerException("federatedIdentityEmailExistsMessage");
        }
        String username = updatedIdentity.getUsername();
        username = this.realmModel.isRegistrationEmailAsUsername() && !Validation.isEmpty(updatedIdentity.getEmail()) ? updatedIdentity.getEmail() : (username == null ? updatedIdentity.getIdentityProviderId() + "." + updatedIdentity.getId() : updatedIdentity.getIdentityProviderId() + "." + updatedIdentity.getUsername());
        if (username != null) {
            username = username.trim();
        }
        if ((existingUser = this.session.users().getUserByUsername(username, this.realmModel)) != null) {
            this.fireErrorEvent("federated_identity_username_exists");
            throw new IdentityBrokerException("federatedIdentityUsernameExistsMessage");
        }
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Creating account from identity [%s].", (Object)federatedIdentityModel);
        }
        UserModel federatedUser = this.session.users().addUser(this.realmModel, username);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Account [%s] created.", (Object)federatedUser);
        }
        federatedUser.setEnabled(true);
        federatedUser.setFirstName(updatedIdentity.getFirstName());
        federatedUser.setLastName(updatedIdentity.getLastName());
        federatedUser.setEmail(updatedIdentity.getEmail());
        this.session.users().addFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
        this.event.clone().user(federatedUser).event(EventType.REGISTER).detail("identity_provider", federatedIdentityModel.getIdentityProvider()).detail("identity_provider_identity", updatedIdentity.getUsername()).removeDetail("auth_method").success();
        return federatedUser;
    }

    private Response corsResponse(Response response, ClientModel clientModel) {
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(clientModel).build();
    }

    private void fireErrorEvent(String message, Throwable throwable) {
        if (!this.event.getEvent().getType().toString().endsWith("_ERROR")) {
            boolean newTransaction = !this.session.getTransaction().isActive();
            try {
                if (newTransaction) {
                    this.session.getTransaction().begin();
                }
                this.event.error(message);
                if (newTransaction) {
                    this.session.getTransaction().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Could not fire event.", (Throwable)e);
                this.rollback();
            }
        }
        if (throwable != null) {
            LOGGER.error((Object)message, throwable);
        } else {
            LOGGER.error((Object)message);
        }
    }

    private void fireErrorEvent(String message) {
        this.fireErrorEvent(message, null);
    }

    private boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    private void rollback() {
        if (this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
        }
    }
}

