/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actions;

import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;

public class UpdateProfile
implements RequiredActionProvider,
RequiredActionFactory {
    protected static Logger logger = Logger.getLogger(UpdateProfile.class);

    @Override
    public void evaluateTriggers(RequiredActionContext context) {
        if (context.getRealm().isVerifyEmail() && !context.getUser().isEmailVerified()) {
            context.getUser().addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            logger.debug((Object)"User is required to verify email");
        }
    }

    @Override
    public Response invokeRequiredAction(RequiredActionContext context) {
        LoginFormsProvider loginFormsProvider = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setClientSessionCode(context.generateAccessCode(this.getProviderId())).setUser(context.getUser());
        return loginFormsProvider.createResponse(UserModel.RequiredAction.UPDATE_PROFILE);
    }

    @Override
    public Object jaxrsService(RequiredActionContext context) {
        return null;
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    public String getDisplayText() {
        return "Update Profile";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PROFILE.name();
    }

    @Override
    public String getProviderId() {
        return this.getId();
    }
}

