/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;

public class AbstractFormAuthenticator {
    public static final String LOGIN_FORM_ACTION = "login_form";
    public static final String REGISTRATION_FORM_ACTION = "registration_form";
    public static final String ACTION = "action";

    protected boolean isAction(AuthenticatorContext context, String action) {
        return action.equals(context.getAction());
    }

    protected LoginFormsProvider loginForm(AuthenticatorContext context) {
        ClientSessionCode code = new ClientSessionCode(context.getRealm(), context.getClientSession());
        code.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        URI action = AbstractFormAuthenticator.getActionUrl(context, code, LOGIN_FORM_ACTION);
        LoginFormsProvider provider = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setUser(context.getUser()).setActionUri(action).setClientSessionCode(code.getCode());
        if (context.getForwardedErrorMessage() != null) {
            provider.setError(context.getForwardedErrorMessage(), new Object[0]);
        }
        return provider;
    }

    public static URI getActionUrl(AuthenticatorContext context, ClientSessionCode code, String action) {
        return LoginActionsService.authenticationFormProcessor(context.getUriInfo()).queryParam("code", new Object[]{code.getCode()}).queryParam(ACTION, new Object[]{action}).build(new Object[]{context.getRealm().getName()});
    }

    protected Response invalidUser(AuthenticatorContext context) {
        return this.loginForm(context).setError("invalidUserMessage", new Object[0]).setClientSessionCode(new ClientSessionCode(context.getRealm(), context.getClientSession()).getCode()).createLogin();
    }

    protected Response disabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setClientSessionCode(new ClientSessionCode(context.getRealm(), context.getClientSession()).getCode()).setError("accountDisabledMessage", new Object[0]).createLogin();
    }

    protected Response temporarilyDisabledUser(AuthenticatorContext context) {
        return this.loginForm(context).setClientSessionCode(new ClientSessionCode(context.getRealm(), context.getClientSession()).getCode()).setError("accountTemporarilyDisabledMessage", new Object[0]).createLogin();
    }

    protected Response invalidCredentials(AuthenticatorContext context) {
        return this.loginForm(context).setClientSessionCode(new ClientSessionCode(context.getRealm(), context.getClientSession()).getCode()).setError("invalidUserMessage", new Object[0]).createLogin();
    }

    public boolean invalidUser(AuthenticatorContext context, UserModel user) {
        if (user == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return true;
        }
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            Response challengeResponse = this.disabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_DISABLED, challengeResponse);
            return true;
        }
        if (context.getRealm().isBruteForceProtected() && context.getProtector().isTemporarilyDisabled(context.getSession(), context.getRealm(), user.getUsername())) {
            context.getEvent().user(user);
            context.getEvent().error("user_temporarily_disabled");
            Response challengeResponse = this.temporarilyDisabledUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.USER_TEMPORARILY_DISABLED, challengeResponse);
            return true;
        }
        return false;
    }
}

