/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.LoginFormUsernameAuthenticator;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class LoginFormPasswordAuthenticator
extends LoginFormUsernameAuthenticator {
    public LoginFormPasswordAuthenticator(AuthenticatorModel model) {
        super(model);
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        if (!this.isAction(context, "login_form") && !this.isAction(context, "registration_form")) {
            context.failure(AuthenticationProcessor.Error.INTERNAL_ERROR);
            return;
        }
        this.validatePassword(context);
    }

    public void validatePassword(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"password");
        if (password == null) {
            if (context.getUser() != null) {
                context.getEvent().user(context.getUser());
            }
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.invalidCredentials(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        credentials.add(UserCredentialModel.password((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            context.getEvent().user(context.getUser());
            context.getEvent().error("invalid_user_credentials");
            Response challengeResponse = this.invalidCredentials(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.users().configuredForCredentialType("password", realm, user);
    }

    @Override
    public String getRequiredAction() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }

    @Override
    public void close() {
    }
}

