/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.ClientConnection;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialIdentityProvider;
import org.keycloak.util.ObjectUtil;

public class IdentityBrokerService
implements IdentityProvider.AuthenticationCallback {
    private static final Logger LOGGER = Logger.getLogger(IdentityBrokerService.class);
    public static final String BROKER_PROVIDER_ID = "BROKER_PROVIDER_ID";
    private final RealmModel realmModel;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    private EventBuilder event;

    public IdentityBrokerService(RealmModel realmModel) {
        if (realmModel == null) {
            throw new IllegalArgumentException("Realm can not be null.");
        }
        this.realmModel = realmModel;
    }

    public void init() {
        this.event = new EventBuilder(this.realmModel, this.session, this.clientConnection).event(EventType.IDENTITY_PROVIDER_LOGIN);
    }

    @GET
    @Path(value="/{provider_id}/login")
    public Response performLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        this.event.detail("identity_provider", providerId);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Sending authentication request to identity provider [%s].", (Object)providerId);
        }
        try {
            ClientSessionCode clientSessionCode = this.parseClientSessionCode(code);
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
            Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                this.event.success();
                if (this.isDebugEnabled()) {
                    LOGGER.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage("couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @Path(value="{provider_id}/endpoint")
    public Object getEndpoint(@PathParam(value="provider_id") String providerId) {
        IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
        Object callback = identityProvider.callback(this.realmModel, (IdentityProvider.AuthenticationCallback)this, this.event);
        ResteasyProviderFactory.getInstance().injectProperties(callback);
        return callback;
    }

    @Path(value="{provider_id}/token")
    @OPTIONS
    public Response retrieveTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @Path(value="{provider_id}/token")
    public Response retrieveToken(@PathParam(value="provider_id") String providerId) {
        return this.getToken(providerId, false);
    }

    private Response getToken(String providerId, boolean forceRetrieval) {
        this.event.event(EventType.IDENTITY_PROVIDER_RETRIEVE_TOKEN);
        try {
            AppAuthManager authManager = new AppAuthManager();
            AuthenticationManager.AuthResult authResult = authManager.authenticateBearerToken(this.session, this.realmModel, this.uriInfo, this.clientConnection, this.request.getHttpHeaders());
            if (authResult != null) {
                AccessToken.Access brokerRoles;
                AccessToken token = authResult.getToken();
                String audience = token.getAudience();
                ClientModel clientModel = this.realmModel.getClientByClientId(audience);
                if (clientModel == null) {
                    return this.badRequest("Invalid client.");
                }
                this.session.getContext().setClient(clientModel);
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    return this.corsResponse(this.forbidden("Realm has not migrated to support the broker token exchange service"), clientModel);
                }
                Map resourceAccess = token.getResourceAccess();
                AccessToken.Access access = brokerRoles = resourceAccess == null ? null : (AccessToken.Access)resourceAccess.get("broker");
                if (brokerRoles == null || !brokerRoles.isUserInRole("read-token")) {
                    return this.corsResponse(this.forbidden("Client [" + audience + "] not authorized to retrieve tokens from identity provider [" + providerId + "]."), clientModel);
                }
                IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
                IdentityProviderModel identityProviderConfig = this.getIdentityProviderConfig(providerId);
                if (identityProviderConfig.isStoreToken()) {
                    FederatedIdentityModel identity = this.session.users().getFederatedIdentity(authResult.getUser(), providerId, this.realmModel);
                    if (identity == null) {
                        return this.corsResponse(this.badRequest("User [" + authResult.getUser().getId() + "] is not associated with identity provider [" + providerId + "]."), clientModel);
                    }
                    this.event.success();
                    return this.corsResponse(identityProvider.retrieveToken(identity), clientModel);
                }
                return this.corsResponse(this.badRequest("Identity Provider [" + providerId + "] does not support this operation."), clientModel);
            }
            return this.badRequest("Invalid token.");
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotObtainTokenMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorRetrievingTokenMessage", e, providerId);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Response authenticated(BrokeredIdentityContext context) {
        clientCode = null;
        identityProviderConfig = context.getIdpConfig();
        try {
            clientCode = this.parseClientSessionCode(context.getCode());
        }
        catch (Exception e) {
            return this.redirectToErrorPage("identityProviderAuthenticationFailedMessage", e, new Object[]{identityProviderConfig.getProviderId()});
        }
        providerId = identityProviderConfig.getAlias();
        if (!identityProviderConfig.isStoreToken()) {
            if (this.isDebugEnabled()) {
                IdentityBrokerService.LOGGER.debugf("Token will not be stored for identity provider [%s].", (Object)providerId);
            }
            context.setToken(null);
        }
        clientSession = clientCode.getClientSession();
        context.getIdp().preprocessFederatedIdentity(this.session, this.realmModel, context);
        mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.preprocessFederatedIdentity(this.session, this.realmModel, mapper, context);
            }
        }
        federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
        this.event.event(EventType.IDENTITY_PROVIDER_LOGIN).detail("redirect_uri", clientSession.getRedirectUri()).detail("identity_provider_identity", context.getUsername());
        federatedUser = this.session.users().getUserByFederatedIdentity(federatedIdentityModel, this.realmModel);
        if (clientSession.getUserSession() != null) {
            return this.performAccountLinking(clientSession, context, federatedIdentityModel, federatedUser);
        }
        if (federatedUser == null) {
            try {
                federatedUser = this.createUser(context);
                if ("on".equals(identityProviderConfig.getUpdateProfileFirstLoginMode()) || "missing".equals(identityProviderConfig.getUpdateProfileFirstLoginMode()) && !Validation.validateUserMandatoryFields(this.realmModel, federatedUser)) {
                    if (this.isDebugEnabled()) {
                        IdentityBrokerService.LOGGER.debugf("Identity provider requires update profile action.", (Object)federatedUser);
                    }
                    federatedUser.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
                }
                if (!identityProviderConfig.isTrustEmail() || Validation.isBlank(federatedUser.getEmail())) ** GOTO lbl41
                federatedUser.setEmailVerified(true);
            }
            catch (Exception e) {
                return this.redirectToLoginPage(e, clientCode);
            }
        } else {
            this.updateFederatedIdentity(context, federatedUser);
        }
lbl41:
        // 3 sources

        userSession = this.session.sessions().createUserSession(this.realmModel, federatedUser, federatedUser.getUsername(), this.clientConnection.getRemoteAddr(), "broker", false, context.getBrokerSessionId(), context.getBrokerUserId());
        this.event.user(federatedUser);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        context.getIdp().attachUserSession(userSession, clientSession, context);
        userSession.setNote("BROKER_PROVIDER_ID", providerId);
        if (this.isDebugEnabled()) {
            IdentityBrokerService.LOGGER.debugf("Performing local authentication for user [%s].", (Object)federatedUser);
        }
        return AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
    }

    public Response cancelled(String code) {
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(code).createLogin();
    }

    public Response error(String code, String message) {
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(code).setError(message, new Object[0]).createLogin();
    }

    private Response performAccountLinking(ClientSessionModel clientSession, BrokeredIdentityContext context, FederatedIdentityModel federatedIdentityModel, UserModel federatedUser) {
        this.event.event(EventType.IDENTITY_PROVIDER_ACCCOUNT_LINKING);
        if (federatedUser != null) {
            return this.redirectToErrorPage("identityProviderAlreadyLinkedMessage", context.getIdpConfig().getAlias());
        }
        UserModel authenticatedUser = clientSession.getUserSession().getUser();
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Linking account [%s] from identity provider [%s] to user [%s].", (Object)federatedIdentityModel, (Object)context.getIdpConfig().getAlias(), (Object)authenticatedUser);
        }
        if (!authenticatedUser.isEnabled()) {
            this.fireErrorEvent("user_disabled");
            return this.redirectToErrorPage("accountDisabledMessage", new Object[0]);
        }
        if (!authenticatedUser.hasRole(this.realmModel.getClientByClientId("account").getRole("manage-account"))) {
            this.fireErrorEvent("not_allowed");
            return this.redirectToErrorPage("insufficientPermissionMessage", new Object[0]);
        }
        this.session.users().addFederatedIdentity(this.realmModel, authenticatedUser, federatedIdentityModel);
        context.getIdp().attachUserSession(clientSession.getUserSession(), clientSession, context);
        this.event.success();
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private void updateFederatedIdentity(BrokeredIdentityContext context, UserModel federatedUser) {
        FederatedIdentityModel federatedIdentityModel = this.session.users().getFederatedIdentity(federatedUser, context.getIdpConfig().getAlias(), this.realmModel);
        if (context.getIdpConfig().isStoreToken() && !ObjectUtil.isEqualOrNull((Object)context.getToken(), (Object)federatedIdentityModel.getToken())) {
            federatedIdentityModel.setToken(context.getToken());
            this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
            }
        }
        context.getIdp().updateBrokeredUser(this.session, this.realmModel, federatedUser, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.updateBrokeredUser(this.session, this.realmModel, federatedUser, mapper, context);
            }
        }
    }

    private ClientSessionCode parseClientSessionCode(String code) {
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realmModel);
        if (clientCode != null && clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE)) {
            ClientSessionModel clientSession = clientCode.getClientSession();
            if (clientSession != null) {
                ClientModel client = clientSession.getClient();
                if (client == null) {
                    throw new IdentityBrokerException("Invalid client");
                }
                LOGGER.debugf("Got authorization code from client [%s].", (Object)client.getClientId());
                this.event.client(client);
                if (clientSession.getUserSession() != null) {
                    this.event.session(clientSession.getUserSession());
                }
            }
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Authorization code is valid.", new Object[0]);
            }
            return clientCode;
        }
        throw new IdentityBrokerException("Invalid code, please login again through your client.");
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode clientSessionCode) {
        ClientSessionModel clientSession = null;
        String relayState = null;
        if (clientSessionCode != null) {
            clientSession = clientSessionCode.getClientSession();
            relayState = clientSessionCode.getCode();
        }
        return new AuthenticationRequest(this.session, this.realmModel, clientSession, this.request, this.uriInfo, relayState, this.getRedirectUri(providerId));
    }

    private String getRedirectUri(String providerId) {
        return Urls.identityProviderAuthnResponse(this.uriInfo.getBaseUri(), providerId, this.realmModel.getName()).toString();
    }

    private Response redirectToErrorPage(String message, Object ... parameters) {
        return this.redirectToErrorPage(message, null, parameters);
    }

    private Response redirectToErrorPage(String message, Throwable throwable, Object ... parameters) {
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message, throwable);
        return ErrorPage.error(this.session, message, parameters);
    }

    private Response redirectToLoginPage(Throwable t, ClientSessionCode clientCode) {
        String message = t.getMessage();
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message);
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(clientCode.getCode()).setError(message, new Object[0]).createLogin();
    }

    private Response badRequest(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    private Response forbidden(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.FORBIDDEN);
    }

    public static IdentityProvider getIdentityProvider(KeycloakSession session, RealmModel realm, String alias) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProviderByAlias(alias);
        if (identityProviderModel != null) {
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(session, identityProviderModel);
            if (providerFactory == null) {
                throw new IdentityBrokerException("Could not find factory for identity provider [" + alias + "].");
            }
            return providerFactory.create(identityProviderModel);
        }
        throw new IdentityBrokerException("Identity Provider [" + alias + "] not found.");
    }

    private static IdentityProviderFactory getIdentityProviderFactory(KeycloakSession session, IdentityProviderModel model) {
        HashMap<String, IdentityProviderFactory> availableProviders = new HashMap<String, IdentityProviderFactory>();
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            availableProviders.put(providerFactory.getId(), (IdentityProviderFactory)providerFactory);
        }
        return (IdentityProviderFactory)availableProviders.get(model.getProviderId());
    }

    private IdentityProviderModel getIdentityProviderConfig(String providerId) {
        for (IdentityProviderModel model : this.realmModel.getIdentityProviders()) {
            if (!model.getAlias().equals(providerId)) continue;
            return model;
        }
        throw new IdentityBrokerException("Configuration for identity provider [" + providerId + "] not found.");
    }

    private UserModel createUser(BrokeredIdentityContext context) {
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getUsername(), context.getToken());
        UserModel existingUser = null;
        if (context.getEmail() != null) {
            existingUser = this.session.users().getUserByEmail(context.getEmail(), this.realmModel);
        }
        if (existingUser != null) {
            this.fireErrorEvent("federated_identity_email_exists");
            throw new IdentityBrokerException("federatedIdentityEmailExistsMessage");
        }
        String username = context.getModelUsername();
        if (username == null) {
            username = context.getUsername();
            username = this.realmModel.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (username == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getIdpConfig().getAlias() + "." + context.getUsername());
        }
        if (username == null) {
            LOGGER.warn((Object)"Unknown username");
            this.fireErrorEvent("federated_identity_username_exists");
            throw new IdentityBrokerException("federatedIdentityUsernameExistsMessage");
        }
        username = username.trim();
        existingUser = this.session.users().getUserByUsername(username, this.realmModel);
        if (existingUser != null) {
            this.fireErrorEvent("federated_identity_username_exists");
            throw new IdentityBrokerException("federatedIdentityUsernameExistsMessage");
        }
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Creating account from identity [%s].", (Object)federatedIdentityModel);
        }
        UserModel federatedUser = this.session.users().addUser(this.realmModel, username);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Account [%s] created.", (Object)federatedUser);
        }
        federatedUser.setEnabled(true);
        federatedUser.setEmail(context.getEmail());
        federatedUser.setFirstName(context.getFirstName());
        federatedUser.setLastName(context.getLastName());
        if (context.getIdpConfig().isAddReadTokenRoleOnCreate()) {
            RoleModel readTokenRole = this.realmModel.getClientByClientId("broker").getRole("read-token");
            federatedUser.grantRole(readTokenRole);
        }
        if (context.getIdpConfig().isStoreToken()) {
            federatedIdentityModel.setToken(context.getToken());
        }
        this.session.users().addFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
        context.getIdp().importNewUser(this.session, this.realmModel, federatedUser, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.importNewUser(this.session, this.realmModel, federatedUser, mapper, context);
            }
        }
        this.event.clone().user(federatedUser).event(EventType.REGISTER).detail("identity_provider", federatedIdentityModel.getIdentityProvider()).detail("identity_provider_identity", context.getUsername()).removeDetail("auth_method").success();
        return federatedUser;
    }

    private Response corsResponse(Response response, ClientModel clientModel) {
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(clientModel).build();
    }

    private void fireErrorEvent(String message, Throwable throwable) {
        if (!this.event.getEvent().getType().toString().endsWith("_ERROR")) {
            boolean newTransaction = !this.session.getTransaction().isActive();
            try {
                if (newTransaction) {
                    this.session.getTransaction().begin();
                }
                this.event.error(message);
                if (newTransaction) {
                    this.session.getTransaction().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Could not fire event.", (Throwable)e);
                this.rollback();
            }
        }
        if (throwable != null) {
            LOGGER.error((Object)message, throwable);
        } else {
            LOGGER.error((Object)message);
        }
    }

    private void fireErrorEvent(String message) {
        this.fireErrorEvent(message, null);
    }

    private boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    private void rollback() {
        if (this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
        }
    }
}

