/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.DefaultAuthenticationFlow;
import org.keycloak.authentication.FormAuthenticationFlow;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.util.Time;

public class AuthenticationProcessor {
    public static final String CURRENT_AUTHENTICATION_EXECUTION = "current.authentication.execution";
    protected static Logger logger = Logger.getLogger(AuthenticationProcessor.class);
    protected RealmModel realm;
    protected UserSessionModel userSession;
    protected ClientSessionModel clientSession;
    protected ClientConnection connection;
    protected UriInfo uriInfo;
    protected KeycloakSession session;
    protected BruteForceProtector protector;
    protected EventBuilder event;
    protected HttpRequest request;
    protected String flowId;
    protected String forwardedErrorMessage;
    protected boolean userSessionCreated;

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public boolean isUserSessionCreated() {
        return this.userSessionCreated;
    }

    public AuthenticationProcessor setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AuthenticationProcessor setClientSession(ClientSessionModel clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    public AuthenticationProcessor setConnection(ClientConnection connection) {
        this.connection = connection;
        return this;
    }

    public AuthenticationProcessor setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AuthenticationProcessor setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public AuthenticationProcessor setProtector(BruteForceProtector protector) {
        this.protector = protector;
        return this;
    }

    public AuthenticationProcessor setEventBuilder(EventBuilder eventBuilder) {
        this.event = eventBuilder;
        return this;
    }

    public AuthenticationProcessor setRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public AuthenticationProcessor setFlowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    public AuthenticationProcessor setForwardedErrorMessage(String forwardedErrorMessage) {
        this.forwardedErrorMessage = forwardedErrorMessage;
        return this;
    }

    public String generateCode() {
        ClientSessionCode accessCode = new ClientSessionCode(this.getRealm(), this.getClientSession());
        this.clientSession.setTimestamp(Time.currentTime());
        return accessCode.getCode();
    }

    public EventBuilder newEvent() {
        this.event = new EventBuilder(this.realm, this.session, this.connection);
        return this.event;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setAutheticatedUser(UserModel user) {
        UserModel previousUser = this.clientSession.getAuthenticatedUser();
        if (previousUser != null && !user.getId().equals(previousUser.getId())) {
            throw new AuthException(Error.USER_CONFLICT);
        }
        this.validateUser(user);
        this.getClientSession().setAuthenticatedUser(user);
    }

    public void logFailure() {
        String username;
        if (this.realm.isBruteForceProtected() && (username = this.clientSession.getNote("ATTEMPTED_USERNAME")) != null) {
            this.protector.failedLogin(this.realm, username, this.connection);
        }
    }

    public boolean isSuccessful(AuthenticationExecutionModel model) {
        ClientSessionModel.ExecutionStatus status = (ClientSessionModel.ExecutionStatus)this.clientSession.getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == ClientSessionModel.ExecutionStatus.SUCCESS;
    }

    public Response handleBrowserException(Exception failure) {
        if (failure instanceof AuthException) {
            AuthException e = (AuthException)failure;
            logger.error((Object)("failed authentication: " + e.getError().toString()), (Throwable)e);
            if (e.getError() == Error.INVALID_USER) {
                this.event.error("user_not_found");
                return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == Error.USER_DISABLED) {
                this.event.error("user_disabled");
                return ErrorPage.error(this.session, "accountDisabledMessage", new Object[0]);
            }
            if (e.getError() == Error.USER_TEMPORARILY_DISABLED) {
                this.event.error("user_temporarily_disabled");
                return ErrorPage.error(this.session, "accountTemporarilyDisabledMessage", new Object[0]);
            }
            if (e.getError() == Error.INVALID_CLIENT_SESSION) {
                this.event.error("invalid_code");
                return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
            }
            if (e.getError() == Error.EXPIRED_CODE) {
                this.event.error("expired_code");
                return ErrorPage.error(this.session, "expiredCodeMessage", new Object[0]);
            }
            this.event.error("invalid_user_credentials");
            return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
        }
        logger.error((Object)"failed authentication", (Throwable)failure);
        this.event.error("invalid_user_credentials");
        return ErrorPage.error(this.session, "unexpectedErrorHandlingRequestMessage", new Object[0]);
    }

    public AuthenticationFlow createFlowExecution(String flowId, AuthenticationExecutionModel execution) {
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(flowId);
        if (flow == null) {
            logger.error((Object)"Unknown flow to execute with");
            throw new AuthException(Error.INTERNAL_ERROR);
        }
        if (flow.getProviderId() == null || flow.getProviderId().equals("basic-flow")) {
            DefaultAuthenticationFlow flowExecution = new DefaultAuthenticationFlow(this, flow);
            return flowExecution;
        }
        if (flow.getProviderId().equals("form-flow")) {
            FormAuthenticationFlow flowExecution = new FormAuthenticationFlow(this, execution);
            return flowExecution;
        }
        throw new AuthException("Unknown flow provider type", Error.INTERNAL_ERROR);
    }

    public Response authenticate() throws AuthException {
        this.checkClientSession();
        logger.debug((Object)"AUTHENTICATE");
        this.event.client(this.clientSession.getClient().getClientId()).detail("redirect_uri", this.clientSession.getRedirectUri()).detail("auth_method", this.clientSession.getAuthMethod());
        String authType = this.clientSession.getNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        UserModel authUser = this.clientSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        Response challenge = authenticationFlow.processFlow();
        if (challenge != null) {
            return challenge;
        }
        if (this.clientSession.getAuthenticatedUser() == null) {
            throw new AuthException(Error.UNKNOWN_USER);
        }
        return this.authenticationComplete();
    }

    public static void resetFlow(ClientSessionModel clientSession) {
        clientSession.setTimestamp(Time.currentTime());
        clientSession.setAuthenticatedUser(null);
        clientSession.clearExecutionStatus();
        clientSession.clearUserSessionNotes();
        clientSession.removeNote(CURRENT_AUTHENTICATION_EXECUTION);
    }

    public Response authenticationAction(String execution) {
        AuthenticationFlow authenticationFlow;
        Response challenge;
        this.checkClientSession();
        String current = this.clientSession.getNote(CURRENT_AUTHENTICATION_EXECUTION);
        if (!execution.equals(current)) {
            logger.debug((Object)"Current execution does not equal executed execution.  Might be a page refresh");
            this.logFailure();
            AuthenticationProcessor.resetFlow(this.clientSession);
            return this.authenticate();
        }
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            logger.debug((Object)"Cannot find execution, reseting flow");
            this.logFailure();
            AuthenticationProcessor.resetFlow(this.clientSession);
            return this.authenticate();
        }
        this.event.client(this.clientSession.getClient().getClientId()).detail("redirect_uri", this.clientSession.getRedirectUri()).detail("auth_method", this.clientSession.getAuthMethod());
        String authType = this.clientSession.getNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        if ((challenge = (authenticationFlow = this.createFlowExecution(this.flowId, model)).processAction(execution)) != null) {
            return challenge;
        }
        if (this.clientSession.getAuthenticatedUser() == null) {
            throw new AuthException(Error.UNKNOWN_USER);
        }
        return this.authenticationComplete();
    }

    public void checkClientSession() {
        ClientSessionCode code = new ClientSessionCode(this.realm, this.clientSession);
        if (!code.isValidAction(ClientSessionModel.Action.AUTHENTICATE.name())) {
            throw new AuthException(Error.INVALID_CLIENT_SESSION);
        }
        if (!code.isActionActive(ClientSessionModel.Action.AUTHENTICATE.name())) {
            throw new AuthException(Error.EXPIRED_CODE);
        }
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public Response authenticateOnly() throws AuthException {
        this.checkClientSession();
        this.event.client(this.clientSession.getClient().getClientId()).detail("redirect_uri", this.clientSession.getRedirectUri()).detail("auth_method", this.clientSession.getAuthMethod());
        String authType = this.clientSession.getNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        UserModel authUser = this.clientSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        Response challenge = authenticationFlow.processFlow();
        return challenge;
    }

    public Response attachSessionExecutionRequiredActions() {
        this.attachSession();
        return AuthenticationManager.actionRequired(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public void attachSession() {
        String username = this.clientSession.getAuthenticatedUser().getUsername();
        String attemptedUsername = this.clientSession.getNote("ATTEMPTED_USERNAME");
        if (attemptedUsername != null) {
            username = attemptedUsername;
        }
        if (this.userSession == null) {
            boolean remember = "true".equals(this.clientSession.getNote("remember_me"));
            this.userSession = this.session.sessions().createUserSession(this.realm, this.clientSession.getAuthenticatedUser(), username, this.connection.getRemoteAddr(), "form", remember, null, null);
            this.userSession.setState(UserSessionModel.State.LOGGING_IN);
            this.userSessionCreated = true;
        }
        TokenManager.attachClientSession(this.userSession, this.clientSession);
        this.event.user(this.userSession.getUser()).detail("username", username).session(this.userSession);
    }

    public void evaluateRequiredActionTriggers() {
        AuthenticationManager.evaluateRequiredActionTriggers(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event, this.realm, this.clientSession.getAuthenticatedUser());
    }

    public Response finishAuthentication() {
        this.event.success();
        RealmModel realm = this.clientSession.getRealm();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, realm, this.userSession, this.clientSession, this.request, this.uriInfo, this.connection);
    }

    public void validateUser(UserModel authenticatedUser) {
        if (authenticatedUser == null) {
            return;
        }
        if (!authenticatedUser.isEnabled()) {
            throw new AuthException(Error.USER_DISABLED);
        }
        if (this.realm.isBruteForceProtected() && this.protector.isTemporarilyDisabled(this.session, this.realm, authenticatedUser.getUsername())) {
            throw new AuthException(Error.USER_TEMPORARILY_DISABLED);
        }
    }

    protected Response authenticationComplete() {
        boolean remember;
        String username = this.clientSession.getAuthenticatedUser().getUsername();
        String rememberMe = this.clientSession.getNote("remember_me");
        boolean bl = remember = rememberMe != null && rememberMe.equalsIgnoreCase("true");
        if (this.userSession == null) {
            this.userSession = this.session.sessions().createUserSession(this.realm, this.clientSession.getAuthenticatedUser(), username, this.connection.getRemoteAddr(), this.clientSession.getAuthMethod(), remember, null, null);
            this.userSession.setState(UserSessionModel.State.LOGGING_IN);
        }
        if (remember) {
            this.event.detail("remember_me", "true");
        }
        TokenManager.attachClientSession(this.userSession, this.clientSession);
        this.event.user(this.userSession.getUser()).detail("username", username).session(this.userSession);
        return AuthenticationManager.nextActionAfterAuthentication(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public AuthenticatorContext createAuthenticatorContext(AuthenticationExecutionModel model, Authenticator authenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, authenticator, executions);
    }

    public static class AuthException
    extends RuntimeException {
        private Error error;

        public AuthException(Error error) {
            this.error = error;
        }

        public AuthException(String message, Error error) {
            super(message);
            this.error = error;
        }

        public AuthException(String message, Throwable cause, Error error) {
            super(message, cause);
            this.error = error;
        }

        public AuthException(Throwable cause, Error error) {
            super(cause);
            this.error = error;
        }

        public AuthException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Error error) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.error = error;
        }

        public Error getError() {
            return this.error;
        }
    }

    private class Result
    implements AuthenticatorContext {
        AuthenticatorConfigModel authenticatorConfig;
        AuthenticationExecutionModel execution;
        Authenticator authenticator;
        Status status;
        Response challenge;
        Error error;
        List<AuthenticationExecutionModel> currentExecutions;

        private Result(AuthenticationExecutionModel execution, Authenticator authenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.authenticator = authenticator;
            this.currentExecutions = currentExecutions;
        }

        @Override
        public EventBuilder newEvent() {
            return AuthenticationProcessor.this.newEvent();
        }

        @Override
        public AuthenticationExecutionModel.Requirement getCategoryRequirementFromCurrentFlow(String authenticatorCategory) {
            List executions = AuthenticationProcessor.this.realm.getAuthenticationExecutions(this.execution.getParentFlow());
            for (AuthenticationExecutionModel exe : executions) {
                AuthenticatorFactory factory = (AuthenticatorFactory)this.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator());
                if (factory == null || !factory.getReferenceCategory().equals(authenticatorCategory)) continue;
                return exe.getRequirement();
            }
            return null;
        }

        @Override
        public AuthenticationExecutionModel getExecution() {
            return this.execution;
        }

        @Override
        public void setExecution(AuthenticationExecutionModel execution) {
            this.execution = execution;
        }

        @Override
        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.execution.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = AuthenticationProcessor.this.realm.getAuthenticatorConfigById(this.execution.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        @Override
        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        @Override
        public void setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public void success() {
            this.status = Status.SUCCESS;
        }

        @Override
        public void failure(Error error) {
            this.status = Status.FAILED;
            this.error = error;
        }

        @Override
        public void challenge(Response challenge) {
            this.status = Status.CHALLENGE;
            this.challenge = challenge;
        }

        @Override
        public void forceChallenge(Response challenge) {
            this.status = Status.FORCE_CHALLENGE;
            this.challenge = challenge;
        }

        @Override
        public void failureChallenge(Error error, Response challenge) {
            this.error = error;
            this.status = Status.FAILURE_CHALLENGE;
            this.challenge = challenge;
        }

        @Override
        public void failure(Error error, Response challenge) {
            this.error = error;
            this.status = Status.FAILED;
            this.challenge = challenge;
        }

        @Override
        public void attempted() {
            this.status = Status.ATTEMPTED;
        }

        @Override
        public UserModel getUser() {
            return this.getClientSession().getAuthenticatedUser();
        }

        @Override
        public void setUser(UserModel user) {
            AuthenticationProcessor.this.setAutheticatedUser(user);
        }

        @Override
        public RealmModel getRealm() {
            return AuthenticationProcessor.this.getRealm();
        }

        @Override
        public ClientSessionModel getClientSession() {
            return AuthenticationProcessor.this.getClientSession();
        }

        @Override
        public ClientConnection getConnection() {
            return AuthenticationProcessor.this.getConnection();
        }

        @Override
        public UriInfo getUriInfo() {
            return AuthenticationProcessor.this.getUriInfo();
        }

        @Override
        public KeycloakSession getSession() {
            return AuthenticationProcessor.this.getSession();
        }

        @Override
        public HttpRequest getHttpRequest() {
            return AuthenticationProcessor.this.request;
        }

        @Override
        public void attachUserSession(UserSessionModel userSession) {
            AuthenticationProcessor.this.userSession = userSession;
        }

        @Override
        public BruteForceProtector getProtector() {
            return AuthenticationProcessor.this.protector;
        }

        @Override
        public EventBuilder getEvent() {
            return AuthenticationProcessor.this.event;
        }

        @Override
        public String getForwardedErrorMessage() {
            return AuthenticationProcessor.this.forwardedErrorMessage;
        }

        @Override
        public String generateAccessCode() {
            return AuthenticationProcessor.this.generateCode();
        }

        @Override
        public Response getChallenge() {
            return this.challenge;
        }

        @Override
        public Error getError() {
            return this.error;
        }
    }

    public static enum Error {
        EXPIRED_CODE,
        INVALID_CLIENT_SESSION,
        INVALID_USER,
        INVALID_CREDENTIALS,
        CREDENTIAL_SETUP_REQUIRED,
        USER_DISABLED,
        USER_CONFLICT,
        USER_TEMPORARILY_DISABLED,
        INTERNAL_ERROR,
        UNKNOWN_USER;

    }

    public static enum Status {
        SUCCESS,
        CHALLENGE,
        FORCE_CHALLENGE,
        FAILURE_CHALLENGE,
        FAILED,
        ATTEMPTED;

    }
}

