/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.services.managers.AuthenticationManager;

public class TermsAndConditions
implements RequiredActionProvider,
RequiredActionFactory {
    public static final String PROVIDER_ID = "terms_and_conditions";

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getProviderId() {
        return this.getId();
    }

    @Override
    public void evaluateTriggers(RequiredActionContext context) {
    }

    @Override
    public Response invokeRequiredAction(RequiredActionContext context) {
        return ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setClientSessionCode(context.generateAccessCode(this.getProviderId())).setUser(context.getUser()).createForm("terms.ftl", new HashMap());
    }

    @Override
    public Object jaxrsService(RequiredActionContext context) {
        return new Resource(context);
    }

    @Override
    public String getDisplayText() {
        return "Terms and Conditions";
    }

    public void close() {
    }

    public static class Resource {
        protected RequiredActionContext context;

        public Resource(RequiredActionContext context) {
            this.context = context;
        }

        @POST
        @Consumes(value={"application/x-www-form-urlencoded"})
        public Response agree(MultivaluedMap<String, String> formData) throws URISyntaxException, IOException, FreeMarkerException {
            if (formData.containsKey((Object)"cancel")) {
                LoginProtocol protocol = (LoginProtocol)this.context.getSession().getProvider(LoginProtocol.class, this.context.getClientSession().getAuthMethod());
                protocol.setRealm(this.context.getRealm()).setHttpHeaders(this.context.getHttpRequest().getHttpHeaders()).setUriInfo(this.context.getUriInfo());
                this.context.getEvent().error("rejected_by_user");
                return protocol.consentDenied(this.context.getClientSession());
            }
            this.context.getUser().removeRequiredAction(TermsAndConditions.PROVIDER_ID);
            return AuthenticationManager.nextActionAfterAuthentication(this.context.getSession(), this.context.getUserSession(), this.context.getClientSession(), this.context.getConnection(), this.context.getHttpRequest(), this.context.getUriInfo(), this.context.getEvent());
        }
    }
}

