/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;

public class ServiceAccountManager {
    protected static final Logger logger = Logger.getLogger(ServiceAccountManager.class);
    private TokenManager tokenManager;
    private AuthenticationManager authManager;
    private EventBuilder event;
    private HttpRequest request;
    private MultivaluedMap<String, String> formParams;
    private KeycloakSession session;
    private RealmModel realm;
    private HttpHeaders headers;
    private UriInfo uriInfo;
    private ClientConnection clientConnection;
    private ClientModel client;
    private UserModel clientUser;

    public ServiceAccountManager(TokenManager tokenManager, AuthenticationManager authManager, EventBuilder event, HttpRequest request, MultivaluedMap<String, String> formParams, KeycloakSession session) {
        this.tokenManager = tokenManager;
        this.authManager = authManager;
        this.event = event;
        this.request = request;
        this.formParams = formParams;
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.headers = session.getContext().getRequestHeaders();
        this.uriInfo = session.getContext().getUri();
        this.clientConnection = session.getContext().getConnection();
    }

    public Response buildClientCredentialsGrant() {
        this.authenticateClient();
        this.checkClient();
        return this.finishClientAuthorization();
    }

    protected void authenticateClient() {
        String authorizationHeader = (String)this.headers.getRequestHeaders().getFirst((Object)"Authorization");
        this.client = AuthorizeClientUtil.authorizeClient(authorizationHeader, this.formParams, this.event, this.realm);
        this.event.detail("client_auth_method", "client_credentials");
    }

    protected void checkClient() {
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
    }

    protected Response finishClientAuthorization() {
        this.event.detail("response_type", "client_auth");
        this.clientUser = this.session.users().getUserByServiceAccountClient(this.client);
        if (this.clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.infof("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            this.clientUser = this.session.users().getUserByServiceAccountClient(this.client);
        }
        String clientUsername = this.clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(this.clientUser);
        if (!this.clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        UserSessionProvider sessions = this.session.sessions();
        ClientSessionModel clientSession = sessions.createClientSession(this.realm, this.client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        UserSessionModel userSession = sessions.createUserSession(this.realm, this.clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken(this.session, scope, this.client, this.clientUser, userSession, clientSession).generateRefreshToken().generateIDToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }
}

