/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.ClientsManagementService;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.wellknown.WellKnownProvider;

@Path(value="/realms")
public class RealmsResource {
    protected static Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected BruteForceProtector protector;

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    public static UriBuilder protocolUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder clientRegistrationUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getClientsService");
    }

    public static UriBuilder brokerUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getBrokerService");
    }

    @Path(value="{realm}/login-status-iframe.html")
    @Deprecated
    public Object getLoginStatusIframe(@PathParam(value="realm") String name, @QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "openid-connect");
        OIDCLoginProtocolService endpoint = (OIDCLoginProtocolService)factory.createProtocolEndpoint(realm, event, authManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint.getLoginStatusIframe();
    }

    @Path(value="{realm}/protocol/{protocol}")
    public Object getProtocol(@PathParam(value="realm") String name, @PathParam(value="protocol") String protocol) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        Object endpoint = factory.createProtocolEndpoint(realm, event, authManager);
        ResteasyProviderFactory.getInstance().injectProperties(endpoint);
        return endpoint;
    }

    @Path(value="{realm}/tokens")
    @Deprecated
    public Object getTokenService(@PathParam(value="realm") String name) {
        return this.getProtocol(name, "openid-connect");
    }

    @Path(value="{realm}/login-actions")
    public LoginActionsService getLoginActionsService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        AuthenticationManager authManager = new AuthenticationManager(this.protector);
        LoginActionsService service = new LoginActionsService(realm, authManager, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/clients")
    public ClientRegistrationService getClientsService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        ClientRegistrationService service = new ClientRegistrationService(event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/clients-managements")
    public ClientsManagementService getClientsManagementService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        ClientsManagementService service = new ClientsManagementService(realm, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    private RealmModel init(String realmName) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm does not exist");
        }
        this.session.getContext().setRealm(realm);
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        ClientModel client = (ClientModel)realm.getClientNameMap().get("account");
        if (client == null || !client.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        AccountService accountService = new AccountService(realm, client, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountService);
        accountService.init();
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)realmResource);
        return realmResource;
    }

    @Path(value="{realm}/broker")
    public IdentityBrokerService getBrokerService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        IdentityBrokerService brokerService = new IdentityBrokerService(realm, this.protector);
        ResteasyProviderFactory.getInstance().injectProperties((Object)brokerService);
        brokerService.init();
        return brokerService;
    }

    @GET
    @Path(value="{realm}/.well-known/{provider}")
    @Produces(value={"application/json"})
    public Response getWellKnown(@PathParam(value="realm") String name, @PathParam(value="provider") String providerName) {
        this.init(name);
        WellKnownProvider wellKnown = (WellKnownProvider)this.session.getProvider(WellKnownProvider.class, providerName);
        return Response.ok((Object)wellKnown.getConfig()).cacheControl(CacheControlUtil.getDefaultCacheControl()).build();
    }
}

