/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.annotate.JsonProperty;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.HMACProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CookieHelper;

public class RestartLoginCookie {
    private static final Logger logger = Logger.getLogger(RestartLoginCookie.class);
    public static final String KC_RESTART = "KC_RESTART";
    @JsonProperty(value="cs")
    protected String clientSession;
    @JsonProperty(value="cid")
    protected String clientId;
    @JsonProperty(value="pty")
    protected String authMethod;
    @JsonProperty(value="ruri")
    protected String redirectUri;
    @JsonProperty(value="act")
    protected String action;
    @JsonProperty(value="notes")
    protected Map<String, String> notes = new HashMap<String, String>();

    public String getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(String clientSession) {
        this.clientSession = clientSession;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String encode(RealmModel realm) {
        JWSBuilder builder = new JWSBuilder();
        return builder.jsonContent((Object)this).hmac256((SecretKey)realm.getCodeSecretKey());
    }

    public RestartLoginCookie() {
    }

    public RestartLoginCookie(ClientSessionModel clientSession) {
        this.action = clientSession.getAction();
        this.clientId = clientSession.getClient().getClientId();
        this.authMethod = clientSession.getAuthMethod();
        this.redirectUri = clientSession.getRedirectUri();
        this.clientSession = clientSession.getId();
        for (Map.Entry entry : clientSession.getNotes().entrySet()) {
            this.notes.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setRestartCookie(RealmModel realm, ClientConnection connection, UriInfo uriInfo, ClientSessionModel clientSession) {
        RestartLoginCookie restart = new RestartLoginCookie(clientSession);
        String encoded = restart.encode(realm);
        int keySize = realm.getCodeSecret().length();
        int size = encoded.length();
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KC_RESTART, encoded, path, null, null, -1, secureOnly, true);
    }

    public static void expireRestartCookie(RealmModel realm, ClientConnection connection, UriInfo uriInfo) {
        String path = AuthenticationManager.getRealmCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KC_RESTART, "", path, null, null, 0, secureOnly, true);
    }

    public static ClientSessionModel restartSession(KeycloakSession session, RealmModel realm, String code) throws Exception {
        Cookie cook = (Cookie)session.getContext().getRequestHeaders().getCookies().get(KC_RESTART);
        if (cook == null) {
            logger.debug((Object)"KC_RESTART cookie doesn't exist");
            return null;
        }
        String encodedCookie = cook.getValue();
        JWSInput input = new JWSInput(encodedCookie);
        if (!HMACProvider.verify((JWSInput)input, (SecretKey)((SecretKey)realm.getCodeSecretKey()))) {
            logger.debug((Object)"Failed to verify encoded RestartLoginCookie");
            return null;
        }
        RestartLoginCookie cookie = (RestartLoginCookie)input.readJsonContent(RestartLoginCookie.class);
        String[] parts = code.split("\\.");
        String clientSessionId = parts[1];
        if (!clientSessionId.equals(cookie.getClientSession())) {
            logger.debug((Object)"RestartLoginCookie clientSession does not match code's clientSession");
            return null;
        }
        ClientModel client = realm.getClientByClientId(cookie.getClientId());
        if (client == null) {
            return null;
        }
        ClientSessionModel clientSession = session.sessions().createClientSession(realm, client);
        clientSession.setAuthMethod(cookie.getAuthMethod());
        clientSession.setRedirectUri(cookie.getRedirectUri());
        clientSession.setAction(cookie.getAction());
        for (Map.Entry<String, String> entry : cookie.getNotes().entrySet()) {
            clientSession.setNote(entry.getKey(), entry.getValue());
        }
        return clientSession;
    }
}

