/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class ExportImportManager {
    private static final Logger logger = Logger.getLogger(ExportImportManager.class);
    private KeycloakSessionFactory sessionFactory;
    private final String realmName;
    private ExportProvider exportProvider;
    private ImportProvider importProvider;

    public ExportImportManager(KeycloakSession session) {
        this.sessionFactory = session.getKeycloakSessionFactory();
        this.realmName = ExportImportConfig.getRealmName();
        String providerId = ExportImportConfig.getProvider();
        String exportImportAction = ExportImportConfig.getAction();
        if ("export".equals(exportImportAction)) {
            this.exportProvider = (ExportProvider)session.getProvider(ExportProvider.class, providerId);
            if (this.exportProvider == null) {
                throw new RuntimeException("Export provider not found");
            }
        } else if ("import".equals(exportImportAction)) {
            this.importProvider = (ImportProvider)session.getProvider(ImportProvider.class, providerId);
            if (this.importProvider == null) {
                throw new RuntimeException("Import provider not found");
            }
        }
    }

    public boolean isRunImport() {
        return this.importProvider != null;
    }

    public boolean isImportMasterIncluded() {
        if (!this.isRunImport()) {
            throw new IllegalStateException("Import not enabled");
        }
        try {
            return this.importProvider.isMasterRealmExported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunExport() {
        return this.exportProvider != null;
    }

    public void runImport() {
        try {
            Strategy strategy = ExportImportConfig.getStrategy();
            if (this.realmName == null) {
                logger.infof("Full model import requested. Strategy: %s", (Object)strategy.toString());
                this.importProvider.importModel(this.sessionFactory, strategy);
            } else {
                logger.infof("Import of realm '%s' requested. Strategy: %s", (Object)this.realmName, (Object)strategy.toString());
                this.importProvider.importRealm(this.sessionFactory, this.realmName, strategy);
            }
            logger.info((Object)"Import finished successfully");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run import", e);
        }
    }

    public void runExport() {
        try {
            if (this.realmName == null) {
                logger.info((Object)"Full model export requested");
                this.exportProvider.exportModel(this.sessionFactory);
            } else {
                logger.infof("Export of realm '%s' requested", (Object)this.realmName);
                this.exportProvider.exportRealm(this.sessionFactory, this.realmName);
            }
            logger.info((Object)"Export finished successfully");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run export");
        }
    }
}

