/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.security.PublicKey;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.OAuthErrorException;
import org.keycloak.RSATokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.Urls;

@Deprecated
public class ValidateTokenEndpoint {
    private static final Logger logger = Logger.getLogger(ValidateTokenEndpoint.class);
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;
    private TokenManager tokenManager;
    private RealmModel realm;
    private EventBuilder event;

    public ValidateTokenEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response validateAccessToken(@QueryParam(value="access_token") String tokenString) {
        this.checkSsl();
        this.event.event(EventType.VALIDATE_ACCESS_TOKEN);
        AccessToken token = null;
        try {
            token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)this.realm.getPublicKey(), (String)Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        }
        catch (Exception e) {
            HashMap<String, String> err = new HashMap<String, String>();
            err.put("error", "invalid_grant");
            err.put("error_description", "Token invalid");
            logger.error((Object)"Invalid token. Token verification failed.");
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
        }
        this.event.user(token.getSubject()).session(token.getSessionState()).detail("validate_access_token", token.getId());
        try {
            this.tokenManager.validateToken(this.session, this.uriInfo, this.clientConnection, this.realm, token, this.headers);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.event.error("invalid_token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        this.event.success();
        return Response.ok((Object)token, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

