/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.social.SocialIdentityProvider;

public class IdentityProviderResource {
    private static Logger logger = Logger.getLogger(IdentityProviderResource.class);
    private final RealmAuth auth;
    private final RealmModel realm;
    private final KeycloakSession session;
    private final IdentityProviderModel identityProviderModel;
    private final AdminEventBuilder adminEvent;
    @Context
    private UriInfo uriInfo;

    public IdentityProviderResource(RealmAuth auth, RealmModel realm, KeycloakSession session, IdentityProviderModel identityProviderModel, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.identityProviderModel = identityProviderModel;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public IdentityProviderRepresentation getIdentityProvider() {
        this.auth.requireView();
        IdentityProviderRepresentation rep = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)this.identityProviderModel);
        return rep;
    }

    @DELETE
    @NoCache
    public Response delete() {
        this.auth.requireManage();
        this.realm.removeIdentityProviderByAlias(this.identityProviderModel.getAlias());
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    public Response update(IdentityProviderRepresentation providerRep) {
        try {
            this.auth.requireManage();
            IdentityProviderResource.updateIdpFromRep(providerRep, this.realm, this.session);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(providerRep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Identity Provider " + providerRep.getAlias() + " already exists");
        }
    }

    public static void updateIdpFromRep(IdentityProviderRepresentation providerRep, RealmModel realm, KeycloakSession session) {
        String internalId = providerRep.getInternalId();
        String newProviderId = providerRep.getAlias();
        String oldProviderId = IdentityProviderResource.getProviderIdByInternalId(realm, internalId);
        realm.updateIdentityProvider(RepresentationToModel.toModel((RealmModel)realm, (IdentityProviderRepresentation)providerRep));
        if (oldProviderId != null && !oldProviderId.equals(newProviderId)) {
            logger.debug((Object)("Changing providerId in all clients and linked users. oldProviderId=" + oldProviderId + ", newProviderId=" + newProviderId));
            IdentityProviderResource.updateUsersAfterProviderAliasChange(session.users().getUsers(realm, false), oldProviderId, newProviderId, realm, session);
        }
    }

    private static String getProviderIdByInternalId(RealmModel realm, String providerInternalId) {
        List providerModels = realm.getIdentityProviders();
        for (IdentityProviderModel providerModel : providerModels) {
            if (!providerModel.getInternalId().equals(providerInternalId)) continue;
            return providerModel.getAlias();
        }
        return null;
    }

    private static void updateUsersAfterProviderAliasChange(List<UserModel> users, String oldProviderId, String newProviderId, RealmModel realm, KeycloakSession session) {
        for (UserModel user : users) {
            FederatedIdentityModel federatedIdentity = session.users().getFederatedIdentity(user, oldProviderId, realm);
            if (federatedIdentity == null) continue;
            session.users().removeFederatedIdentity(realm, user, oldProviderId);
            FederatedIdentityModel newFederatedIdentity = new FederatedIdentityModel(newProviderId, federatedIdentity.getUserId(), federatedIdentity.getUserName(), federatedIdentity.getToken());
            session.users().addFederatedIdentity(realm, user, newFederatedIdentity);
        }
    }

    private IdentityProviderFactory getIdentityProviderFactory() {
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            if (!providerFactory.getId().equals(this.identityProviderModel.getProviderId())) continue;
            return (IdentityProviderFactory)providerFactory;
        }
        return null;
    }

    @GET
    @Path(value="export")
    @NoCache
    public Response export(@Context UriInfo uriInfo, @QueryParam(value="format") String format) {
        try {
            this.auth.requireView();
            IdentityProviderFactory factory = this.getIdentityProviderFactory();
            return factory.create(this.identityProviderModel).export(uriInfo, this.realm, format);
        }
        catch (Exception e) {
            return ErrorResponse.error("Could not export public broker configuration for identity provider [" + this.identityProviderModel.getProviderId() + "].", Response.Status.NOT_FOUND);
        }
    }

    @GET
    @Path(value="mapper-types")
    @NoCache
    public Map<String, IdentityProviderMapperTypeRepresentation> getMapperTypes() {
        this.auth.requireView();
        KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
        HashMap<String, IdentityProviderMapperTypeRepresentation> types = new HashMap<String, IdentityProviderMapperTypeRepresentation>();
        List factories = sessionFactory.getProviderFactories(IdentityProviderMapper.class);
        block0: for (ProviderFactory factory : factories) {
            IdentityProviderMapper mapper = (IdentityProviderMapper)factory;
            for (String type : mapper.getCompatibleProviders()) {
                if (!"*".equals(type) && !type.equals(this.identityProviderModel.getProviderId())) continue;
                IdentityProviderMapperTypeRepresentation rep = new IdentityProviderMapperTypeRepresentation();
                rep.setId(mapper.getId());
                rep.setCategory(mapper.getDisplayCategory());
                rep.setName(mapper.getDisplayType());
                rep.setHelpText(mapper.getHelpText());
                List configProperties = mapper.getConfigProperties();
                for (ProviderConfigProperty prop : configProperties) {
                    ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
                    propRep.setName(prop.getName());
                    propRep.setLabel(prop.getLabel());
                    propRep.setType(prop.getType());
                    propRep.setDefaultValue(prop.getDefaultValue());
                    propRep.setHelpText(prop.getHelpText());
                    rep.getProperties().add(propRep);
                }
                types.put(rep.getId(), rep);
                continue block0;
            }
        }
        return types;
    }

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    @NoCache
    public List<IdentityProviderMapperRepresentation> getMappers() {
        this.auth.requireView();
        LinkedList<IdentityProviderMapperRepresentation> mappers = new LinkedList<IdentityProviderMapperRepresentation>();
        for (IdentityProviderMapperModel model : this.realm.getIdentityProviderMappersByAlias(this.identityProviderModel.getAlias())) {
            mappers.add(ModelToRepresentation.toRepresentation((IdentityProviderMapperModel)model));
        }
        return mappers;
    }

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    public Response addMapper(IdentityProviderMapperRepresentation mapper) {
        this.auth.requireManage();
        IdentityProviderMapperModel model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)mapper);
        model = this.realm.addIdentityProviderMapper(model);
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, model.getId()).representation(mapper).success();
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @NoCache
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    public IdentityProviderMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        this.auth.requireView();
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return ModelToRepresentation.toRepresentation((IdentityProviderMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, IdentityProviderMapperRepresentation rep) {
        this.auth.requireManage();
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((IdentityProviderMapperRepresentation)rep);
        this.realm.updateIdentityProviderMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="mappers/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        IdentityProviderMapperModel model = this.realm.getIdentityProviderMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.realm.removeIdentityProviderMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }
}

