/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.OIDCRedirectUriBuilder;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.ResourceAdminManager;

public class OIDCLoginProtocol
implements LoginProtocol {
    public static final String LOGIN_PROTOCOL = "openid-connect";
    public static final String STATE_PARAM = "state";
    public static final String LOGOUT_STATE_PARAM = "OIDC_LOGOUT_STATE_PARAM";
    public static final String SCOPE_PARAM = "scope";
    public static final String CODE_PARAM = "code";
    public static final String RESPONSE_TYPE_PARAM = "response_type";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String NONCE_PARAM = "nonce";
    public static final String PROMPT_PARAM = "prompt";
    public static final String LOGIN_HINT_PARAM = "login_hint";
    public static final String LOGOUT_REDIRECT_URI = "OIDC_LOGOUT_REDIRECT_URI";
    public static final String ISSUER = "iss";
    public static final String RESPONSE_MODE_PARAM = "response_mode";
    private static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected KeycloakSession session;
    protected RealmModel realm;
    protected UriInfo uriInfo;
    protected HttpHeaders headers;
    protected EventBuilder event;
    protected OIDCResponseType responseType;
    protected OIDCResponseMode responseMode;

    public OIDCLoginProtocol(KeycloakSession session, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, EventBuilder event) {
        this.session = session;
        this.realm = realm;
        this.uriInfo = uriInfo;
        this.headers = headers;
        this.event = event;
    }

    public OIDCLoginProtocol() {
    }

    private void setupResponseTypeAndMode(ClientSessionModel clientSession) {
        String responseType = clientSession.getNote(RESPONSE_TYPE_PARAM);
        String responseMode = clientSession.getNote(RESPONSE_MODE_PARAM);
        this.responseType = OIDCResponseType.parse(responseType);
        this.responseMode = OIDCResponseMode.parse(responseMode, this.responseType);
        this.event.detail(RESPONSE_TYPE_PARAM, responseType);
        this.event.detail(RESPONSE_MODE_PARAM, this.responseMode.toString().toLowerCase());
    }

    public OIDCLoginProtocol setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public OIDCLoginProtocol setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public OIDCLoginProtocol setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public OIDCLoginProtocol setHttpHeaders(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public OIDCLoginProtocol setEventBuilder(EventBuilder event) {
        this.event = event;
        return this;
    }

    public Response authenticated(UserSessionModel userSession, ClientSessionCode accessCode) {
        ClientSessionModel clientSession = accessCode.getClientSession();
        this.setupResponseTypeAndMode(clientSession);
        String redirect = clientSession.getRedirectUri();
        OIDCRedirectUriBuilder redirectUri = OIDCRedirectUriBuilder.fromUri(redirect, this.responseMode);
        String state = clientSession.getNote(STATE_PARAM);
        logger.debugv("redirectAccessCode: state: {0}", state);
        if (state != null) {
            redirectUri.addParam(STATE_PARAM, state);
        }
        if (this.responseType.hasResponseType(CODE_PARAM)) {
            accessCode.setAction(ClientSessionModel.Action.CODE_TO_TOKEN.name());
            redirectUri.addParam(CODE_PARAM, accessCode.getCode());
        }
        if (this.responseType.isImplicitOrHybridFlow()) {
            TokenManager tokenManager = new TokenManager();
            AccessTokenResponse res = tokenManager.responseBuilder(this.realm, clientSession.getClient(), this.event, this.session, userSession, clientSession).generateAccessToken().generateIDToken().build();
            if (this.responseType.hasResponseType("id_token")) {
                redirectUri.addParam("id_token", res.getIdToken());
            }
            if (this.responseType.hasResponseType("token")) {
                redirectUri.addParam("access_token", res.getToken());
                redirectUri.addParam("token_type", res.getTokenType());
                redirectUri.addParam("session-state", res.getSessionState());
                redirectUri.addParam("expires_in", String.valueOf(res.getExpiresIn()));
            }
            redirectUri.addParam("not-before-policy", String.valueOf(res.getNotBeforePolicy()));
        }
        return redirectUri.build();
    }

    public Response sendError(ClientSessionModel clientSession, LoginProtocol.Error error) {
        this.setupResponseTypeAndMode(clientSession);
        String redirect = clientSession.getRedirectUri();
        String state = clientSession.getNote(STATE_PARAM);
        OIDCRedirectUriBuilder redirectUri = OIDCRedirectUriBuilder.fromUri(redirect, this.responseMode).addParam("error", this.translateError(error));
        if (state != null) {
            redirectUri.addParam(STATE_PARAM, state);
        }
        this.session.sessions().removeClientSession(this.realm, clientSession);
        RestartLoginCookie.expireRestartCookie(this.realm, this.session.getContext().getConnection(), this.uriInfo);
        return redirectUri.build();
    }

    private String translateError(LoginProtocol.Error error) {
        switch (error) {
            case CANCELLED_BY_USER: 
            case CONSENT_DENIED: {
                return "access_denied";
            }
            case PASSIVE_INTERACTION_REQUIRED: {
                return "interaction_required";
            }
            case PASSIVE_LOGIN_REQUIRED: {
                return "login_required";
            }
        }
        logger.untranslatedProtocol(error.name());
        return "access_denied";
    }

    public void backchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        ClientModel client = clientSession.getClient();
        new ResourceAdminManager(this.session).logoutClientSession(this.uriInfo.getRequestUri(), this.realm, client, clientSession);
    }

    public Response frontchannelLogout(UserSessionModel userSession, ClientSessionModel clientSession) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public Response finishLogout(UserSessionModel userSession) {
        String redirectUri = userSession.getNote(LOGOUT_REDIRECT_URI);
        String state = userSession.getNote(LOGOUT_STATE_PARAM);
        this.event.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.event.detail(REDIRECT_URI_PARAM, redirectUri);
        }
        this.event.user(userSession.getUser()).session(userSession).success();
        if (redirectUri != null) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectUri);
            if (state != null) {
                uriBuilder.queryParam(STATE_PARAM, new Object[]{state});
            }
            return Response.status((int)302).location(uriBuilder.build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    public void close() {
    }
}

