/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;

public class SpnegoAuthenticator
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    public static final String KERBEROS_DISABLED = "kerberos_disabled";
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    public static boolean bypassChallengeJavascript = false;

    public boolean requiresUser() {
        return false;
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        context.attempted();
    }

    public void authenticate(AuthenticationFlowContext context) {
        HttpRequest request = context.getHttpRequest();
        String authHeader = (String)request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            Response challenge = this.challengeNegotiation(context, null);
            context.forceChallenge(challenge);
            return;
        }
        String[] tokens = authHeader.split(" ");
        if (tokens.length == 0) {
            logger.debug("Invalid length of tokens: " + tokens.length);
            context.attempted();
            return;
        }
        if (!"Negotiate".equalsIgnoreCase(tokens[0])) {
            logger.debug("Unknown scheme " + tokens[0]);
            context.attempted();
            return;
        }
        if (tokens.length != 2) {
            context.failure(AuthenticationFlowError.INVALID_CREDENTIALS);
            return;
        }
        String spnegoToken = tokens[1];
        UserCredentialModel spnegoCredential = UserCredentialModel.kerberos((String)spnegoToken);
        CredentialValidationOutput output = context.getSession().users().validCredentials(context.getSession(), context.getRealm(), new UserCredentialModel[]{spnegoCredential});
        if (output.getAuthStatus() == CredentialValidationOutput.Status.AUTHENTICATED) {
            context.setUser(output.getAuthenticatedUser());
            if (output.getState() != null && !output.getState().isEmpty()) {
                for (Map.Entry entry : output.getState().entrySet()) {
                    context.getClientSession().setUserSessionNote((String)entry.getKey(), (String)entry.getValue());
                }
            }
            context.success();
        } else if (output.getAuthStatus() == CredentialValidationOutput.Status.CONTINUE) {
            String spnegoResponseToken = (String)output.getState().get("SpnegoResponseToken");
            Response challenge = this.challengeNegotiation(context, spnegoResponseToken);
            context.challenge(challenge);
        } else {
            context.getEvent().error("invalid_user_credentials");
            context.failure(AuthenticationFlowError.INVALID_CREDENTIALS);
        }
    }

    private Response challengeNegotiation(AuthenticationFlowContext context, String negotiateToken) {
        String negotiateHeader;
        String string = negotiateHeader = negotiateToken == null ? "Negotiate" : "Negotiate " + negotiateToken;
        if (logger.isTraceEnabled()) {
            logger.trace("Sending back WWW-Authenticate: " + negotiateHeader);
        }
        if (context.getExecution().isRequired()) {
            return ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setStatus(Response.Status.UNAUTHORIZED).setResponseHeader("WWW-Authenticate", negotiateHeader).setError("kerberosNotSetUp", new Object[0]).createErrorPage();
        }
        return this.optionalChallengeRedirect(context, negotiateHeader);
    }

    protected Response optionalChallengeRedirect(AuthenticationFlowContext context, String negotiateHeader) {
        String accessCode = context.generateAccessCode();
        URI action = context.getActionUrl(accessCode);
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        builder.append("<TITLE>Kerberos Unsupported</TITLE>");
        builder.append("</HEAD>");
        if (bypassChallengeJavascript) {
            builder.append("<BODY>");
        } else {
            builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        }
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + action.toString() + "\">");
        builder.append("<NOSCRIPT>");
        builder.append("<P>JavaScript is disabled. We strongly recommend to enable it. You were unable to login via Kerberos.  Click the button below to login via an alternative method .</P>");
        builder.append("<INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("</NOSCRIPT>");
        builder.append("</FORM></BODY></HTML>");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)negotiateHeader).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }
}

