/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.mappers.FederationConfigValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserFederationValidatingProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.UserFederationProviderResource;
import org.keycloak.utils.CredentialHelper;

public class UserFederationProvidersResource {
    protected static final ServicesLogger logger = ServicesLogger.ROOT_LOGGER;
    protected RealmModel realm;
    protected RealmAuth auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public UserFederationProvidersResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    public static boolean checkKerberosCredential(KeycloakSession session, RealmModel realm, UserFederationProviderModel model) {
        String allowKerberosCfg = (String)model.getConfig().get("allowKerberosAuthentication");
        if (Boolean.valueOf(allowKerberosCfg).booleanValue()) {
            CredentialHelper.setAlternativeCredential(session, "kerberos", realm);
            return true;
        }
        return false;
    }

    public static void validateFederationProviderConfig(KeycloakSession session, RealmAuth auth, RealmModel realm, UserFederationProviderModel model) {
        UserFederationProviderFactory providerFactory = KeycloakModelUtils.getFederationProviderFactory((KeycloakSession)session, (UserFederationProviderModel)model);
        if (providerFactory instanceof UserFederationValidatingProviderFactory) {
            try {
                ((UserFederationValidatingProviderFactory)providerFactory).validateConfig(realm, model);
            }
            catch (FederationConfigValidationException fcve) {
                logger.error(fcve.getMessage());
                Properties messages = AdminRoot.getMessages(session, realm, auth.getAuth().getToken().getLocale());
                throw new ErrorResponseException(fcve.getMessage(), MessageFormat.format(messages.getProperty(fcve.getMessage(), fcve.getMessage()), fcve.getParameters()), Response.Status.BAD_REQUEST);
            }
        }
    }

    @GET
    @NoCache
    @Path(value="providers")
    @Produces(value={"application/json"})
    public List<UserFederationProviderFactoryRepresentation> getProviders() {
        this.auth.requireView();
        LinkedList<UserFederationProviderFactoryRepresentation> providers = new LinkedList<UserFederationProviderFactoryRepresentation>();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            providers.add(rep);
        }
        return providers;
    }

    @GET
    @NoCache
    @Path(value="providers/{id}")
    @Produces(value={"application/json"})
    public UserFederationProviderFactoryRepresentation getProvider(@PathParam(value="id") String id) {
        this.auth.requireView();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            if (!factory.getId().equals(id)) continue;
            if (factory instanceof ConfiguredProvider) {
                UserFederationProviderFactoryDescription rep = new UserFederationProviderFactoryDescription();
                rep.setId(factory.getId());
                ConfiguredProvider cp = (ConfiguredProvider)factory;
                rep.setHelpText(cp.getHelpText());
                rep.setProperties(this.toConfigPropertyRepresentationList(cp.getConfigProperties()));
                return rep;
            }
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            return rep;
        }
        throw new NotFoundException("Could not find provider");
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    public Response createProviderInstance(UserFederationProviderRepresentation rep) {
        this.auth.requireManage();
        String displayName = rep.getDisplayName();
        if (displayName != null && displayName.trim().equals("")) {
            displayName = null;
        }
        UserFederationProviderModel tempModel = new UserFederationProviderModel(null, rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        UserFederationProvidersResource.validateFederationProviderConfig(this.session, this.auth, this.realm, tempModel);
        UserFederationProviderModel model = this.realm.addUserFederationProvider(rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        new UsersSyncManager().notifyToRefreshPeriodicSync(this.session, this.realm, model, false);
        boolean kerberosCredsAdded = UserFederationProvidersResource.checkKerberosCredential(this.session, this.realm, model);
        if (kerberosCredsAdded) {
            logger.addedKerberosToRealmCredentials();
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(rep).success();
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @Path(value="instances")
    @Produces(value={"application/json"})
    @NoCache
    public List<UserFederationProviderRepresentation> getUserFederationInstances() {
        this.auth.requireView();
        LinkedList<UserFederationProviderRepresentation> reps = new LinkedList<UserFederationProviderRepresentation>();
        for (UserFederationProviderModel model : this.realm.getUserFederationProviders()) {
            UserFederationProviderRepresentation rep = ModelToRepresentation.toRepresentation((UserFederationProviderModel)model);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="instances/{id}")
    public UserFederationProviderResource getUserFederationInstance(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserFederationProviderModel model = KeycloakModelUtils.findUserFederationProviderById((String)id, (RealmModel)this.realm);
        UserFederationProviderResource instanceResource = new UserFederationProviderResource(this.session, this.realm, this.auth, model, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)instanceResource);
        return instanceResource;
    }

    private ConfigPropertyRepresentation toConfigPropertyRepresentation(ProviderConfigProperty prop) {
        ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
        propRep.setName(prop.getName());
        propRep.setLabel(prop.getLabel());
        propRep.setType(prop.getType());
        propRep.setDefaultValue(prop.getDefaultValue());
        propRep.setHelpText(prop.getHelpText());
        return propRep;
    }

    private List<ConfigPropertyRepresentation> toConfigPropertyRepresentationList(List<ProviderConfigProperty> props) {
        ArrayList<ConfigPropertyRepresentation> reps = new ArrayList<ConfigPropertyRepresentation>(props.size());
        for (ProviderConfigProperty prop : props) {
            reps.add(this.toConfigPropertyRepresentation(prop));
        }
        return reps;
    }

    public static class UserFederationProviderFactoryDescription
    extends UserFederationProviderFactoryRepresentation {
        protected String name;
        protected String helpText;
        protected List<ConfigPropertyRepresentation> properties;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public void setHelpText(String helpText) {
            this.helpText = helpText;
        }

        public List<ConfigPropertyRepresentation> getProperties() {
            return this.properties;
        }

        public void setProperties(List<ConfigPropertyRepresentation> properties) {
            this.properties = properties;
        }
    }
}

