/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.resources.AttributeFormDataProcessor;
import org.keycloak.services.validation.Validation;

public class IdpReviewProfileAuthenticator
extends AbstractIdpAuthenticator {
    private static final Logger logger = Logger.getLogger(IdpReviewProfileAuthenticator.class);

    public boolean requiresUser() {
        return false;
    }

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext userCtx, BrokeredIdentityContext brokerContext) {
        IdentityProviderModel idpConfig = brokerContext.getIdpConfig();
        if (this.requiresUpdateProfilePage(context, userCtx, brokerContext)) {
            logger.debugf("Identity provider '%s' requires update profile action for broker user '%s'.", (Object)idpConfig.getAlias(), (Object)userCtx.getUsername());
            Response challengeResponse = context.form().setAttribute("updateProfileCtx", (Object)userCtx).setFormData(null).createUpdateProfilePage();
            context.challenge(challengeResponse);
        } else {
            context.success();
        }
    }

    protected boolean requiresUpdateProfilePage(AuthenticationFlowContext context, SerializedBrokeredIdentityContext userCtx, BrokeredIdentityContext brokerContext) {
        String enforceUpdateProfile = context.getAuthenticationSession().getAuthNote("ENFORCE_UPDATE_PROFILE");
        if (Boolean.parseBoolean(enforceUpdateProfile)) {
            return true;
        }
        AuthenticatorConfigModel authenticatorConfig = context.getAuthenticatorConfig();
        String updateProfileFirstLogin = authenticatorConfig == null || !authenticatorConfig.getConfig().containsKey("update.profile.on.first.login") ? "missing" : (String)authenticatorConfig.getConfig().get("update.profile.on.first.login");
        RealmModel realm = context.getRealm();
        return "on".equals(updateProfileFirstLogin) || "missing".equals(updateProfileFirstLogin) && !Validation.validateUserMandatoryFields(realm, userCtx);
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext userCtx, BrokeredIdentityContext brokerContext) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_PROFILE);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        RealmModel realm = context.getRealm();
        List<FormMessage> errors = Validation.validateUpdateProfileForm(realm, (MultivaluedMap<String, String>)formData, userCtx.isEditUsernameAllowed());
        if (errors != null && !errors.isEmpty()) {
            Response challenge = context.form().setErrors(errors).setAttribute("updateProfileCtx", (Object)userCtx).setFormData(formData).createUpdateProfilePage();
            context.challenge(challenge);
            return;
        }
        String username = realm.isRegistrationEmailAsUsername() ? (String)formData.getFirst((Object)"email") : (String)formData.getFirst((Object)"username");
        userCtx.setUsername(username);
        userCtx.setFirstName((String)formData.getFirst((Object)"firstName"));
        userCtx.setLastName((String)formData.getFirst((Object)"lastName"));
        String email = (String)formData.getFirst((Object)"email");
        if (!ObjectUtil.isEqualOrBothNull((Object)email, (Object)userCtx.getEmail())) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Email updated on updateProfile page to '%s' ", (Object)email);
            }
            userCtx.setEmail(email);
            context.getAuthenticationSession().setAuthNote("UPDATE_PROFILE_EMAIL_CHANGED", "true");
        }
        AttributeFormDataProcessor.process((MultivaluedMap<String, String>)formData, realm, userCtx);
        userCtx.saveToAuthenticationSession(context.getAuthenticationSession(), "BROKERED_CONTEXT");
        logger.debugf("Profile updated successfully after first authentication with identity provider '%s' for broker user '%s'.", (Object)brokerContext.getIdpConfig().getAlias(), (Object)userCtx.getUsername());
        event.detail("updated_email", email);
        context.getAuthenticationSession().setAuthNote("ENFORCE_UPDATE_PROFILE", "true");
        context.success();
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }
}

