/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.net.URI;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.services.util.IframeUtil;

public class LoginStatusIframeEndpoint {
    @Context
    private KeycloakSession session;

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getLoginStatusIframe(@QueryParam(value="version") String version) {
        return IframeUtil.returnIframeFromResources("login-status-iframe.html", version, this.session);
    }

    @GET
    @Path(value="init")
    public Response preCheck(@QueryParam(value="client_id") String clientId, @QueryParam(value="origin") String origin) {
        try {
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel client = this.session.clients().getClientByClientId(realm, clientId);
            if (client != null && client.isEnabled()) {
                Set<String> validWebOrigins = WebOriginsUtils.resolveValidWebOrigins(this.session, client);
                validWebOrigins.add(UriUtils.getOrigin((URI)uriInfo.getRequestUri()));
                if (validWebOrigins.contains("*") || validWebOrigins.contains(origin)) {
                    return Response.noContent().build();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

