/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.LinkedList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.vault.VaultConfigurationException;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultProviderFactory;

public abstract class AbstractVaultProviderFactory
implements VaultProviderFactory {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String KEY_RESOLVERS = "keyResolvers";
    protected List<VaultKeyResolver> keyResolvers = new LinkedList<VaultKeyResolver>();

    public void init(Config.Scope config) {
        String resolverNames = config.get(KEY_RESOLVERS);
        if (resolverNames != null) {
            for (String resolverName : resolverNames.split(",")) {
                VaultKeyResolver resolver = this.getVaultKeyResolver(resolverName);
                if (resolver == null) continue;
                this.keyResolvers.add(resolver);
            }
            if (this.keyResolvers.isEmpty()) {
                throw new VaultConfigurationException("Unable to initialize factory - all provided key resolvers are invalid");
            }
        }
        if (this.keyResolvers.isEmpty()) {
            logger.debugf("Key resolver is undefined - using %s by default", (Object)AvailableResolvers.REALM_UNDERSCORE_KEY.name());
            this.keyResolvers.add(AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver());
        }
    }

    protected VaultKeyResolver getFactoryResolver() {
        throw new UnsupportedOperationException("getFactoryResolver not implemented by factory " + this.getClass().getName());
    }

    protected String getRealmName(KeycloakSession session) {
        return session.getContext().getRealm().getName();
    }

    private VaultKeyResolver getVaultKeyResolver(String resolverName) {
        try {
            AvailableResolvers value = AvailableResolvers.valueOf(resolverName.trim().toUpperCase());
            return value == AvailableResolvers.FACTORY_PROVIDED ? this.getFactoryResolver() : value.getVaultKeyResolver();
        }
        catch (Exception e) {
            logger.debugf((Throwable)e, "Invalid key resolver: %s - skipping", (Object)resolverName);
            return null;
        }
    }

    protected static enum AvailableResolvers {
        KEY_ONLY((realm, key) -> key),
        REALM_UNDERSCORE_KEY((realm, key) -> realm.replaceAll("_", "__") + "_" + key.replaceAll("_", "__")),
        REALM_FILESEPARATOR_KEY((realm, key) -> realm + File.separator + key),
        FACTORY_PROVIDED(null);

        private VaultKeyResolver resolver;

        private AvailableResolvers(VaultKeyResolver resolver) {
            this.resolver = resolver;
        }

        VaultKeyResolver getVaultKeyResolver() {
            return this.resolver;
        }
    }
}

