/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.OAuthErrorException;
import org.keycloak.Token;
import org.keycloak.TokenCategory;
import org.keycloak.TokenVerifier;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.HashProvider;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.jose.jws.crypto.HashUtils;
import org.keycloak.migration.migrators.MigrationUtils;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.TokenRevocationStoreProvider;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.protocol.oidc.LogoutTokenValidationCode;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenResponseMapper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.util.DefaultClientSessionContext;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class TokenManager {
    private static final Logger logger = Logger.getLogger(TokenManager.class);
    private static final String JWT = "JWT";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TokenValidation validateToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, RefreshToken oldToken, HttpHeaders headers) throws OAuthErrorException {
        DefaultClientSessionContext clientSessionCtx;
        UserModel user;
        UserSessionModel userSession = null;
        boolean offline = "Offline".equals(oldToken.getType());
        if (offline) {
            UserSessionManager sessionManager = new UserSessionManager(session);
            userSession = sessionManager.findOfflineUserSession(realm, oldToken.getSessionState());
            if (userSession == null) throw new OAuthErrorException("invalid_grant", "Offline user session not found", "Offline user session not found");
            if (!AuthenticationManager.isOfflineSessionValid(realm, userSession)) {
                sessionManager.revokeOfflineUserSession(userSession);
                throw new OAuthErrorException("invalid_grant", "Offline session not active", "Offline session not active");
            }
        } else {
            userSession = session.sessions().getUserSession(realm, oldToken.getSessionState());
            if (!AuthenticationManager.isSessionValid(realm, userSession)) {
                AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                throw new OAuthErrorException("invalid_grant", "Session not active", "Session not active");
            }
        }
        if ((user = userSession.getUser()) == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", "Unknown user");
        }
        if (!user.isEnabled()) {
            throw new OAuthErrorException("invalid_grant", "User disabled", "User disabled");
        }
        if (oldToken.getIssuedAt() + 1 < userSession.getStarted()) {
            logger.debug((Object)"Refresh toked issued before the user session started");
            throw new OAuthErrorException("invalid_grant", "Refresh toked issued before the user session started");
        }
        ClientModel client = session.getContext().getClient();
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession == null) {
            if ((userSession = new UserSessionCrossDCManager(session).getUserSessionWithClient(realm, userSession.getId(), offline, client.getId())) == null) throw new OAuthErrorException("invalid_grant", "Session doesn't have required client", "Session doesn't have required client");
            clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        }
        if (!client.getClientId().equals(oldToken.getIssuedFor())) {
            throw new OAuthErrorException("invalid_grant", "Unmatching clients", "Unmatching clients");
        }
        try {
            TokenVerifier.createWithoutSignature((JsonWebToken)oldToken).withChecks(new TokenVerifier.Predicate[]{NotBeforeCheck.forModel(client), NotBeforeCheck.forModel(session, realm, user)}).verify();
        }
        catch (VerificationException e) {
            throw new OAuthErrorException("invalid_grant", "Stale token");
        }
        String oldTokenScope = oldToken.getScope();
        if (oldTokenScope == null && userSession.isOffline()) {
            logger.debugf("Migrating offline token of user '%s' for client '%s' of realm '%s'", (Object)user.getUsername(), (Object)client.getClientId(), (Object)realm.getName());
            MigrationUtils.migrateOldOfflineToken((KeycloakSession)session, (RealmModel)realm, (ClientModel)client, (UserModel)user);
            oldTokenScope = "offline_access";
        }
        if (!TokenManager.verifyConsentStillAvailable(session, user, client, (clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, oldTokenScope, session)).getClientScopesStream())) {
            throw new OAuthErrorException("invalid_scope", "Client no longer has requested consent from user");
        }
        clientSessionCtx.setAttribute("nonce", oldToken.getNonce());
        AccessToken newToken = this.createClientAccessToken(session, realm, client, user, userSession, clientSessionCtx);
        return new TokenValidation(user, userSession, clientSessionCtx, newToken);
    }

    public boolean checkTokenValidForIntrospection(KeycloakSession session, RealmModel realm, AccessToken token) throws OAuthErrorException {
        ClientModel client = realm.getClientByClientId(token.getIssuedFor());
        if (client == null || !client.isEnabled()) {
            return false;
        }
        try {
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(new TokenVerifier.Predicate[]{NotBeforeCheck.forModel(client), TokenVerifier.IS_ACTIVE}).verify();
        }
        catch (VerificationException e) {
            return false;
        }
        TokenRevocationStoreProvider revocationStore = (TokenRevocationStoreProvider)session.getProvider(TokenRevocationStoreProvider.class);
        if (revocationStore.isRevoked(token.getId())) {
            return false;
        }
        boolean valid = false;
        if (token.getSessionState() == null) {
            UserModel user = TokenManager.lookupUserFromStatelessToken(session, realm, token);
            valid = this.isUserValid(session, realm, token, user);
        } else {
            UserSessionModel userSession = new UserSessionCrossDCManager(session).getUserSessionWithClient(realm, token.getSessionState(), false, client.getId());
            if (AuthenticationManager.isSessionValid(realm, userSession)) {
                valid = this.isUserValid(session, realm, token, userSession.getUser());
            } else {
                userSession = new UserSessionCrossDCManager(session).getUserSessionWithClient(realm, token.getSessionState(), true, client.getId());
                if (AuthenticationManager.isOfflineSessionValid(realm, userSession)) {
                    valid = this.isUserValid(session, realm, token, userSession.getUser());
                }
            }
            if (valid && token.getIssuedAt() + 1 < userSession.getStarted()) {
                valid = false;
            }
            if (valid) {
                int currentTime = Time.currentTime();
                userSession.setLastSessionRefresh(currentTime);
                AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
                if (clientSession != null) {
                    clientSession.setTimestamp(currentTime);
                }
            }
        }
        return valid;
    }

    private boolean isUserValid(KeycloakSession session, RealmModel realm, AccessToken token, UserModel user) {
        if (user == null) {
            return false;
        }
        if (!user.isEnabled()) {
            return false;
        }
        try {
            TokenVerifier.createWithoutSignature((JsonWebToken)token).withChecks(new TokenVerifier.Predicate[]{NotBeforeCheck.forModel(session, realm, user)}).verify();
        }
        catch (VerificationException e) {
            return false;
        }
        return true;
    }

    public static UserModel lookupUserFromStatelessToken(KeycloakSession session, RealmModel realm, AccessToken token) {
        UserModel user = session.users().getUserById(realm, token.getSubject());
        if (user != null) {
            return user;
        }
        if (token.getPreferredUsername() != null && (user = session.users().getUserByUsername(realm, token.getPreferredUsername())) != null) {
            return user;
        }
        return user;
    }

    public RefreshResult refreshAccessToken(KeycloakSession session, UriInfo uriInfo, ClientConnection connection, RealmModel realm, ClientModel authorizedClient, String encodedRefreshToken, EventBuilder event, HttpHeaders headers, HttpRequest request) throws OAuthErrorException {
        String scopeParam;
        AccessToken.CertConf certConf;
        RefreshToken refreshToken = this.verifyRefreshToken(session, realm, authorizedClient, request, encodedRefreshToken, true);
        event.user(refreshToken.getSubject()).session(refreshToken.getSessionState()).detail("refresh_token_id", refreshToken.getId()).detail("refresh_token_type", refreshToken.getType());
        TokenValidation validation = this.validateToken(session, uriInfo, connection, realm, refreshToken, headers);
        AuthenticatedClientSessionModel clientSession = validation.clientSessionCtx.getClientSession();
        if (!clientSession.getClient().getId().equals(authorizedClient.getId())) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token. Token client and authorized client don't match");
        }
        this.validateTokenReuse(session, realm, refreshToken, validation);
        int currentTime = Time.currentTime();
        clientSession.setTimestamp(currentTime);
        validation.userSession.setLastSessionRefresh(currentTime);
        if (refreshToken.getAuthorization() != null) {
            validation.newToken.setAuthorization(refreshToken.getAuthorization());
        }
        AccessTokenResponseBuilder responseBuilder = this.responseBuilder(realm, authorizedClient, event, session, validation.userSession, validation.clientSessionCtx).accessToken(validation.newToken);
        if (OIDCAdvancedConfigWrapper.fromClientModel(authorizedClient).isUseRefreshToken()) {
            responseBuilder.generateRefreshToken();
        }
        if (validation.newToken.getAuthorization() != null && OIDCAdvancedConfigWrapper.fromClientModel(authorizedClient).isUseRefreshToken()) {
            responseBuilder.getRefreshToken().setAuthorization(validation.newToken.getAuthorization());
        }
        if ((certConf = refreshToken.getCertConf()) != null) {
            responseBuilder.getAccessToken().setCertConf(certConf);
            if (OIDCAdvancedConfigWrapper.fromClientModel(authorizedClient).isUseRefreshToken()) {
                responseBuilder.getRefreshToken().setCertConf(certConf);
            }
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSession.getNote("scope")))) {
            responseBuilder.generateIDToken();
        }
        AccessTokenResponse res = responseBuilder.build();
        return new RefreshResult(res, "Offline".equals(refreshToken.getType()));
    }

    private void validateTokenReuse(KeycloakSession session, RealmModel realm, RefreshToken refreshToken, TokenValidation validation) throws OAuthErrorException {
        if (realm.isRevokeRefreshToken()) {
            int currentCount;
            AuthenticatedClientSessionModel clientSession = validation.clientSessionCtx.getClientSession();
            int clusterStartupTime = ((ClusterProvider)session.getProvider(ClusterProvider.class)).getClusterStartupTime();
            if (clientSession.getCurrentRefreshToken() != null && !refreshToken.getId().equals(clientSession.getCurrentRefreshToken()) && refreshToken.getIssuedAt() < clientSession.getTimestamp() && clusterStartupTime <= clientSession.getTimestamp()) {
                throw new OAuthErrorException("invalid_grant", "Stale token");
            }
            if (!refreshToken.getId().equals(clientSession.getCurrentRefreshToken())) {
                clientSession.setCurrentRefreshToken(refreshToken.getId());
                clientSession.setCurrentRefreshTokenUseCount(0);
            }
            if ((currentCount = clientSession.getCurrentRefreshTokenUseCount()) > realm.getRefreshTokenMaxReuse()) {
                throw new OAuthErrorException("invalid_grant", "Maximum allowed refresh token reuse exceeded", "Maximum allowed refresh token reuse exceeded");
            }
            clientSession.setCurrentRefreshTokenUseCount(currentCount + 1);
        }
    }

    public RefreshToken verifyRefreshToken(KeycloakSession session, RealmModel realm, ClientModel client, HttpRequest request, String encodedRefreshToken, boolean checkExpiration) throws OAuthErrorException {
        try {
            RefreshToken refreshToken = this.toRefreshToken(session, encodedRefreshToken);
            if (!"Refresh".equals(refreshToken.getType()) && !"Offline".equals(refreshToken.getType())) {
                throw new OAuthErrorException("invalid_grant", "Invalid refresh token");
            }
            if (checkExpiration) {
                try {
                    TokenVerifier.createWithoutSignature((JsonWebToken)refreshToken).withChecks(new TokenVerifier.Predicate[]{NotBeforeCheck.forModel(realm), TokenVerifier.IS_ACTIVE}).verify();
                }
                catch (VerificationException e) {
                    throw new OAuthErrorException("invalid_grant", e.getMessage());
                }
            }
            if (!client.getClientId().equals(refreshToken.getIssuedFor())) {
                throw new OAuthErrorException("invalid_grant", "Invalid refresh token. Token client and authorized client don't match");
            }
            if (OIDCAdvancedConfigWrapper.fromClientModel(client).isUseMtlsHokToken() && !MtlsHoKTokenUtil.verifyTokenBindingWithClientCertificate((AccessToken)refreshToken, request, session)) {
                throw new OAuthErrorException("unauthorized_client", "Client certificate missing, or its thumbprint and one in the refresh token did NOT match");
            }
            return refreshToken;
        }
        catch (JWSInputException e) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", (Throwable)e);
        }
    }

    public RefreshToken toRefreshToken(KeycloakSession session, String encodedRefreshToken) throws JWSInputException, OAuthErrorException {
        RefreshToken refreshToken = (RefreshToken)session.tokens().decode(encodedRefreshToken, RefreshToken.class);
        if (refreshToken == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token");
        }
        return refreshToken;
    }

    public IDToken verifyIDToken(KeycloakSession session, RealmModel realm, String encodedIDToken) throws OAuthErrorException {
        IDToken idToken = (IDToken)session.tokens().decode(encodedIDToken, IDToken.class);
        try {
            TokenVerifier.createWithoutSignature((JsonWebToken)idToken).withChecks(new TokenVerifier.Predicate[]{NotBeforeCheck.forModel(realm), TokenVerifier.IS_ACTIVE}).verify();
        }
        catch (VerificationException e) {
            throw new OAuthErrorException("invalid_grant", e.getMessage());
        }
        return idToken;
    }

    public IDToken verifyIDTokenSignature(KeycloakSession session, String encodedIDToken) throws OAuthErrorException {
        IDToken idToken = (IDToken)session.tokens().decode(encodedIDToken, IDToken.class);
        if (idToken == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid IDToken");
        }
        return idToken;
    }

    public AccessToken createClientAccessToken(KeycloakSession session, RealmModel realm, ClientModel client, UserModel user, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AccessToken token = this.initToken(realm, client, user, userSession, clientSessionCtx, (UriInfo)session.getContext().getUri());
        token = this.transformAccessToken(session, token, userSession, clientSessionCtx);
        return token;
    }

    public static ClientSessionContext attachAuthenticationSession(KeycloakSession session, UserSessionModel userSession, AuthenticationSessionModel authSession) {
        ClientModel client = authSession.getClient();
        AuthenticatedClientSessionModel clientSession = userSession.getAuthenticatedClientSessionByClient(client.getId());
        if (clientSession == null) {
            clientSession = session.sessions().createClientSession(userSession.getRealm(), client, userSession);
        }
        clientSession.setRedirectUri(authSession.getRedirectUri());
        clientSession.setProtocol(authSession.getProtocol());
        Set clientScopeIds = authSession.getClientScopes();
        Map transferredNotes = authSession.getClientNotes();
        for (Map.Entry entry : transferredNotes.entrySet()) {
            clientSession.setNote((String)entry.getKey(), (String)entry.getValue());
        }
        Map transferredUserSessionNotes = authSession.getUserSessionNotes();
        for (Map.Entry entry : transferredUserSessionNotes.entrySet()) {
            userSession.setNote((String)entry.getKey(), (String)entry.getValue());
        }
        clientSession.setTimestamp(Time.currentTime());
        new AuthenticationSessionManager(session).removeAuthenticationSession(userSession.getRealm(), authSession, true);
        DefaultClientSessionContext defaultClientSessionContext = DefaultClientSessionContext.fromClientSessionAndClientScopeIds(clientSession, clientScopeIds, session);
        return defaultClientSessionContext;
    }

    public static void dettachClientSession(AuthenticatedClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession == null) {
            return;
        }
        clientSession.detachFromUserSession();
    }

    public static Set<RoleModel> getAccess(UserModel user, ClientModel client, Stream<ClientScopeModel> clientScopes) {
        Set roleMappings = RoleUtils.getDeepUserRoleMappings((UserModel)user);
        if (client.isFullScopeAllowed()) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Using full scope for client %s", (Object)client.getClientId());
            }
            return roleMappings;
        }
        Stream scopeMappings = client.getRolesStream();
        Stream clientScopesMappings = !logger.isTraceEnabled() ? clientScopes.flatMap(clientScope -> clientScope.getScopeMappingsStream()) : clientScopes.flatMap(clientScope -> {
            logger.tracef("Adding client scope role mappings of client scope '%s' to client '%s'", (Object)clientScope.getName(), (Object)client.getClientId());
            return clientScope.getScopeMappingsStream();
        });
        scopeMappings = Stream.concat(scopeMappings, clientScopesMappings);
        scopeMappings = RoleUtils.expandCompositeRolesStream(scopeMappings);
        roleMappings.retainAll(scopeMappings.collect(Collectors.toSet()));
        return roleMappings;
    }

    public static Stream<ClientScopeModel> getRequestedClientScopes(String scopeParam, ClientModel client) {
        Stream<ClientModel> clientScopes = Stream.concat(client.getClientScopes(true).values().stream(), Stream.of(client)).distinct();
        if (scopeParam == null) {
            return clientScopes;
        }
        Map allOptionalScopes = client.getClientScopes(false);
        return Stream.concat(TokenManager.parseScopeParameter(scopeParam).map(allOptionalScopes::get).filter(Objects::nonNull), clientScopes).distinct();
    }

    public static boolean isValidScope(String scopes, ClientModel client) {
        if (scopes == null) {
            return true;
        }
        Set clientScopes = TokenManager.getRequestedClientScopes(scopes, client).filter(((Predicate<ClientScopeModel>)ClientModel.class::isInstance).negate()).map(ClientScopeModel::getName).collect(Collectors.toSet());
        Collection requestedScopes = TokenManager.parseScopeParameter(scopes).collect(Collectors.toSet());
        if (TokenUtil.isOIDCRequest((String)scopes)) {
            requestedScopes.remove("openid");
        }
        if (!requestedScopes.isEmpty() && clientScopes.isEmpty()) {
            return false;
        }
        for (String requestedScope : requestedScopes) {
            if (clientScopes.contains(requestedScope) || client.getDynamicClientScope(requestedScope) != null) continue;
            return false;
        }
        return true;
    }

    public static Stream<String> parseScopeParameter(String scopeParam) {
        return Arrays.stream(scopeParam.split(" ")).distinct();
    }

    public static boolean verifyConsentStillAvailable(KeycloakSession session, UserModel user, ClientModel client, Stream<ClientScopeModel> requestedClientScopes) {
        if (!client.isConsentRequired()) {
            return true;
        }
        UserConsentModel grantedConsent = session.users().getConsentByClient(client.getRealm(), user.getId(), client.getId());
        return requestedClientScopes.filter(ClientScopeModel::isDisplayOnConsentScreen).noneMatch(requestedScope -> {
            if (grantedConsent == null || !grantedConsent.getGrantedClientScopes().contains(requestedScope)) {
                logger.debugf("Client '%s' no longer has requested consent from user '%s' for client scope '%s'", (Object)client.getClientId(), (Object)user.getUsername(), (Object)requestedScope.getName());
                return true;
            }
            return false;
        });
    }

    public AccessToken transformAccessToken(KeycloakSession session, AccessToken token, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AtomicReference<AccessToken> finalToken = new AtomicReference<AccessToken>(token);
        ProtocolMapperUtils.getSortedProtocolMappers(session, clientSessionCtx).filter(mapper -> mapper.getValue() instanceof OIDCAccessTokenMapper).forEach(mapper -> finalToken.set(((OIDCAccessTokenMapper)mapper.getValue()).transformAccessToken((AccessToken)finalToken.get(), (ProtocolMapperModel)mapper.getKey(), session, userSession, clientSessionCtx)));
        return finalToken.get();
    }

    public AccessTokenResponse transformAccessTokenResponse(KeycloakSession session, AccessTokenResponse accessTokenResponse, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AtomicReference<AccessTokenResponse> finalResponseToken = new AtomicReference<AccessTokenResponse>(accessTokenResponse);
        ProtocolMapperUtils.getSortedProtocolMappers(session, clientSessionCtx).filter(mapper -> mapper.getValue() instanceof OIDCAccessTokenResponseMapper).forEach(mapper -> finalResponseToken.set(((OIDCAccessTokenResponseMapper)mapper.getValue()).transformAccessTokenResponse((AccessTokenResponse)finalResponseToken.get(), (ProtocolMapperModel)mapper.getKey(), session, userSession, clientSessionCtx)));
        return finalResponseToken.get();
    }

    public AccessToken transformUserInfoAccessToken(KeycloakSession session, AccessToken token, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AtomicReference<AccessToken> finalToken = new AtomicReference<AccessToken>(token);
        ProtocolMapperUtils.getSortedProtocolMappers(session, clientSessionCtx).filter(mapper -> mapper.getValue() instanceof UserInfoTokenMapper).forEach(mapper -> finalToken.set(((UserInfoTokenMapper)mapper.getValue()).transformUserInfoToken((AccessToken)finalToken.get(), (ProtocolMapperModel)mapper.getKey(), session, userSession, clientSessionCtx)));
        return finalToken.get();
    }

    public Map<String, Object> generateUserInfoClaims(AccessToken userInfo, UserModel userModel) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userModel.getId());
        claims.putAll(userInfo.getOtherClaims());
        if (userInfo.getRealmAccess() != null) {
            HashMap<String, Set> realmAccess = new HashMap<String, Set>();
            realmAccess.put("roles", userInfo.getRealmAccess().getRoles());
            claims.put("realm_access", realmAccess);
        }
        if (userInfo.getResourceAccess() != null && !userInfo.getResourceAccess().isEmpty()) {
            HashMap resourceAccessMap = new HashMap();
            for (Map.Entry resourceAccessMapEntry : userInfo.getResourceAccess().entrySet()) {
                HashMap<String, Set> resourceAccess = new HashMap<String, Set>();
                resourceAccess.put("roles", ((AccessToken.Access)resourceAccessMapEntry.getValue()).getRoles());
                resourceAccessMap.put(resourceAccessMapEntry.getKey(), resourceAccess);
            }
            claims.put("resource_access", resourceAccessMap);
        }
        return claims;
    }

    public void transformIDToken(KeycloakSession session, IDToken token, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AtomicReference<IDToken> finalToken = new AtomicReference<IDToken>(token);
        ProtocolMapperUtils.getSortedProtocolMappers(session, clientSessionCtx).filter(mapper -> mapper.getValue() instanceof OIDCIDTokenMapper).forEach(mapper -> finalToken.set(((OIDCIDTokenMapper)mapper.getValue()).transformIDToken((IDToken)finalToken.get(), (ProtocolMapperModel)mapper.getKey(), session, userSession, clientSessionCtx)));
    }

    protected AccessToken initToken(RealmModel realm, ClientModel client, UserModel user, UserSessionModel session, ClientSessionContext clientSessionCtx, UriInfo uriInfo) {
        AccessToken token = new AccessToken();
        token.id(KeycloakModelUtils.generateId());
        token.type("Bearer");
        token.subject(user.getId());
        token.issuedNow();
        token.issuedFor(client.getClientId());
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        token.issuer(clientSession.getNote("iss"));
        token.setNonce((String)clientSessionCtx.getAttribute("nonce", String.class));
        token.setScope(clientSessionCtx.getScopeString());
        String acr = AuthenticationManager.isSSOAuthentication(clientSession) ? "0" : "1";
        token.setAcr(acr);
        String authTime = session.getNote("AUTH_TIME");
        if (authTime != null) {
            token.setAuthTime(Integer.parseInt(authTime));
        }
        token.setSessionState(session.getId());
        ClientScopeModel offlineAccessScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"offline_access");
        boolean offlineTokenRequested = offlineAccessScope == null ? false : clientSessionCtx.getClientScopeIds().contains(offlineAccessScope.getId());
        token.expiration(this.getTokenExpiration(realm, client, session, clientSession, offlineTokenRequested));
        return token;
    }

    private int getTokenExpiration(RealmModel realm, ClientModel client, UserSessionModel userSession, AuthenticatedClientSessionModel clientSession, boolean offlineTokenRequested) {
        String clientLifespan;
        boolean implicitFlow = false;
        String responseType = clientSession.getNote("response_type");
        if (responseType != null) {
            implicitFlow = OIDCResponseType.parse(responseType).isImplicitFlow();
        }
        int tokenLifespan = implicitFlow ? realm.getAccessTokenLifespanForImplicitFlow() : ((clientLifespan = client.getAttribute("access.token.lifespan")) != null && !clientLifespan.trim().isEmpty() ? Integer.parseInt(clientLifespan) : realm.getAccessTokenLifespan());
        int expiration = tokenLifespan == -1 ? userSession.getStarted() + (userSession.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan()) : Time.currentTime() + tokenLifespan;
        if (userSession.isOffline() || offlineTokenRequested) {
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                int sessionExpires = userSession.getStarted() + realm.getOfflineSessionMaxLifespan();
                expiration = expiration <= sessionExpires ? expiration : sessionExpires;
                String clientOfflineSessionMaxLifespanPerClient = client.getAttribute("client.offline.session.max.lifespan");
                int clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty() ? Integer.parseInt(clientOfflineSessionMaxLifespanPerClient) : realm.getClientOfflineSessionMaxLifespan();
                if (clientOfflineSessionMaxLifespan > 0) {
                    int clientOfflineSessionExpiration = userSession.getStarted() + clientOfflineSessionMaxLifespan;
                    return expiration < clientOfflineSessionExpiration ? expiration : clientOfflineSessionExpiration;
                }
            }
        } else {
            int sessionExpires = userSession.getStarted() + (userSession.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
            expiration = expiration <= sessionExpires ? expiration : sessionExpires;
            String clientSessionMaxLifespanPerClient = client.getAttribute("client.session.max.lifespan");
            int clientSessionMaxLifespan = clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty() ? Integer.parseInt(clientSessionMaxLifespanPerClient) : realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0) {
                int clientSessionExpiration = clientSession.getTimestamp() + clientSessionMaxLifespan;
                return expiration < clientSessionExpiration ? expiration : clientSessionExpiration;
            }
        }
        return expiration;
    }

    public AccessTokenResponseBuilder responseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        return new AccessTokenResponseBuilder(realm, client, event, session, userSession, clientSessionCtx);
    }

    public LogoutTokenValidationCode verifyLogoutToken(KeycloakSession session, RealmModel realm, String encodedLogoutToken) {
        Optional<LogoutToken> logoutTokenOptional = this.toLogoutToken(encodedLogoutToken);
        if (!logoutTokenOptional.isPresent()) {
            return LogoutTokenValidationCode.DECODE_TOKEN_FAILED;
        }
        LogoutToken logoutToken = logoutTokenOptional.get();
        List identityProviders = this.getOIDCIdentityProviders(realm, session).collect(Collectors.toList());
        if (identityProviders.isEmpty()) {
            return LogoutTokenValidationCode.COULD_NOT_FIND_IDP;
        }
        Stream<OIDCIdentityProvider> validOidcIdentityProviders = this.validateLogoutTokenAgainstIdpProvider(identityProviders.stream(), encodedLogoutToken, logoutToken);
        if (validOidcIdentityProviders.count() == 0L) {
            return LogoutTokenValidationCode.TOKEN_VERIFICATION_WITH_IDP_FAILED;
        }
        if (logoutToken.getSubject() == null && logoutToken.getSid() == null) {
            return LogoutTokenValidationCode.MISSING_SID_OR_SUBJECT;
        }
        if (!this.checkLogoutTokenForEvents(logoutToken)) {
            return LogoutTokenValidationCode.BACKCHANNEL_LOGOUT_EVENT_MISSING;
        }
        if (logoutToken.getOtherClaims().get("nonce") != null) {
            return LogoutTokenValidationCode.NONCE_CLAIM_IN_TOKEN;
        }
        if (logoutToken.getId() == null) {
            return LogoutTokenValidationCode.LOGOUT_TOKEN_ID_MISSING;
        }
        if (logoutToken.getIat() == null) {
            return LogoutTokenValidationCode.MISSING_IAT_CLAIM;
        }
        return LogoutTokenValidationCode.VALIDATION_SUCCESS;
    }

    public Optional<LogoutToken> toLogoutToken(String encodedLogoutToken) {
        try {
            JWSInput jws = new JWSInput(encodedLogoutToken);
            return Optional.of(jws.readJsonContent(LogoutToken.class));
        }
        catch (JWSInputException e) {
            return Optional.empty();
        }
    }

    public Stream<OIDCIdentityProvider> getValidOIDCIdentityProvidersForBackchannelLogout(RealmModel realm, KeycloakSession session, String encodedLogoutToken, LogoutToken logoutToken) {
        return this.validateLogoutTokenAgainstIdpProvider(this.getOIDCIdentityProviders(realm, session), encodedLogoutToken, logoutToken);
    }

    public Stream<OIDCIdentityProvider> validateLogoutTokenAgainstIdpProvider(Stream<OIDCIdentityProvider> oidcIdps, String encodedLogoutToken, LogoutToken logoutToken) {
        return oidcIdps.filter(oidcIdp -> ((OIDCIdentityProviderConfig)oidcIdp.getConfig()).getIssuer() != null).filter(oidcIdp -> oidcIdp.isIssuer(logoutToken.getIssuer(), null)).filter(oidcIdp -> {
            try {
                oidcIdp.validateToken(encodedLogoutToken);
                return true;
            }
            catch (IdentityBrokerException e) {
                logger.debugf("LogoutToken verification with identity provider failed", (Object)e.getMessage());
                return false;
            }
        });
    }

    private Stream<OIDCIdentityProvider> getOIDCIdentityProviders(RealmModel realm, KeycloakSession session) {
        try {
            return realm.getIdentityProvidersStream().map(idpModel -> IdentityBrokerService.getIdentityProviderFactory(session, idpModel).create(session, idpModel)).filter(OIDCIdentityProvider.class::isInstance).map(OIDCIdentityProvider.class::cast);
        }
        catch (IdentityBrokerException e) {
            logger.warnf("LogoutToken verification with identity provider failed", (Object)e.getMessage());
            return Stream.empty();
        }
    }

    private boolean checkLogoutTokenForEvents(LogoutToken logoutToken) {
        for (String eventKey : logoutToken.getEvents().keySet()) {
            if (!"http://schemas.openid.net/event/backchannel-logout".equals(eventKey)) continue;
            return true;
        }
        return false;
    }

    public static class NotBeforeCheck
    implements TokenVerifier.Predicate<JsonWebToken> {
        private final int notBefore;

        public NotBeforeCheck(int notBefore) {
            this.notBefore = notBefore;
        }

        public boolean test(JsonWebToken t) throws VerificationException {
            if (t.getIssuedAt() < this.notBefore) {
                throw new VerificationException("Stale token");
            }
            return true;
        }

        public static NotBeforeCheck forModel(ClientModel clientModel) {
            if (clientModel != null) {
                int notBeforeClient = clientModel.getNotBefore();
                int notBeforeRealm = clientModel.getRealm().getNotBefore();
                int notBefore = notBeforeClient == 0 ? notBeforeRealm : (notBeforeRealm == 0 ? notBeforeClient : Math.min(notBeforeClient, notBeforeRealm));
                return new NotBeforeCheck(notBefore);
            }
            return new NotBeforeCheck(0);
        }

        public static NotBeforeCheck forModel(RealmModel realmModel) {
            return new NotBeforeCheck(realmModel == null ? 0 : realmModel.getNotBefore());
        }

        public static NotBeforeCheck forModel(KeycloakSession session, RealmModel realmModel, UserModel userModel) {
            return new NotBeforeCheck(session.users().getNotBeforeOfUser(realmModel, userModel));
        }
    }

    public static class RefreshResult {
        private final AccessTokenResponse response;
        private final boolean offlineToken;

        private RefreshResult(AccessTokenResponse response, boolean offlineToken) {
            this.response = response;
            this.offlineToken = offlineToken;
        }

        public AccessTokenResponse getResponse() {
            return this.response;
        }

        public boolean isOfflineToken() {
            return this.offlineToken;
        }
    }

    public class AccessTokenResponseBuilder {
        RealmModel realm;
        ClientModel client;
        EventBuilder event;
        KeycloakSession session;
        UserSessionModel userSession;
        ClientSessionContext clientSessionCtx;
        AccessToken accessToken;
        RefreshToken refreshToken;
        IDToken idToken;
        boolean generateAccessTokenHash = false;
        String codeHash;
        String stateHash;

        public AccessTokenResponseBuilder(RealmModel realm, ClientModel client, EventBuilder event, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
            this.realm = realm;
            this.client = client;
            this.event = event;
            this.session = session;
            this.userSession = userSession;
            this.clientSessionCtx = clientSessionCtx;
        }

        public AccessToken getAccessToken() {
            return this.accessToken;
        }

        public RefreshToken getRefreshToken() {
            return this.refreshToken;
        }

        public IDToken getIdToken() {
            return this.idToken;
        }

        public AccessTokenResponseBuilder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AccessTokenResponseBuilder refreshToken(RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AccessTokenResponseBuilder generateAccessToken() {
            UserModel user = this.userSession.getUser();
            this.accessToken = TokenManager.this.createClientAccessToken(this.session, this.realm, this.client, user, this.userSession, this.clientSessionCtx);
            return this;
        }

        public AccessTokenResponseBuilder generateRefreshToken() {
            boolean offlineTokenRequested;
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            ClientScopeModel offlineAccessScope = KeycloakModelUtils.getClientScopeByName((RealmModel)this.realm, (String)"offline_access");
            boolean bl = offlineTokenRequested = offlineAccessScope == null ? false : this.clientSessionCtx.getClientScopeIds().contains(offlineAccessScope.getId());
            if (offlineTokenRequested) {
                UserSessionManager sessionManager = new UserSessionManager(this.session);
                if (!sessionManager.isOfflineTokenAllowed(this.clientSessionCtx)) {
                    this.event.error("not_allowed");
                    throw new ErrorResponseException("not_allowed", "Offline tokens not allowed for the user or client", Response.Status.BAD_REQUEST);
                }
                this.refreshToken = new RefreshToken(this.accessToken);
                this.refreshToken.type("Offline");
                if (this.realm.isOfflineSessionMaxLifespanEnabled()) {
                    this.refreshToken.expiration(this.getOfflineExpiration());
                }
                sessionManager.createOrUpdateOfflineSession(this.clientSessionCtx.getClientSession(), this.userSession);
            } else {
                this.refreshToken = new RefreshToken(this.accessToken);
                this.refreshToken.expiration(this.getRefreshExpiration());
            }
            this.refreshToken.id(KeycloakModelUtils.generateId());
            this.refreshToken.issuedNow();
            return this;
        }

        private int getRefreshExpiration() {
            int sessionExpires = this.userSession.getStarted() + (this.userSession.isRememberMe() && this.realm.getSsoSessionMaxLifespanRememberMe() > 0 ? this.realm.getSsoSessionMaxLifespanRememberMe() : this.realm.getSsoSessionMaxLifespan());
            String clientSessionMaxLifespanPerClient = this.client.getAttribute("client.session.max.lifespan");
            int clientSessionMaxLifespan = clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty() ? Integer.parseInt(clientSessionMaxLifespanPerClient) : this.realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0) {
                int clientSessionMaxExpiration = this.userSession.getStarted() + clientSessionMaxLifespan;
                sessionExpires = sessionExpires < clientSessionMaxExpiration ? sessionExpires : clientSessionMaxExpiration;
            }
            int expiration = Time.currentTime() + (this.userSession.isRememberMe() && this.realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? this.realm.getSsoSessionIdleTimeoutRememberMe() : this.realm.getSsoSessionIdleTimeout());
            String clientSessionIdleTimeoutPerClient = this.client.getAttribute("client.session.idle.timeout");
            int clientSessionIdleTimeout = clientSessionIdleTimeoutPerClient != null && !clientSessionIdleTimeoutPerClient.trim().isEmpty() ? Integer.parseInt(clientSessionIdleTimeoutPerClient) : this.realm.getClientSessionIdleTimeout();
            if (clientSessionIdleTimeout > 0) {
                int clientSessionIdleExpiration = Time.currentTime() + clientSessionIdleTimeout;
                expiration = expiration < clientSessionIdleExpiration ? expiration : clientSessionIdleExpiration;
            }
            return expiration <= sessionExpires ? expiration : sessionExpires;
        }

        private int getOfflineExpiration() {
            int sessionExpires = this.userSession.getStarted() + this.realm.getOfflineSessionMaxLifespan();
            String clientOfflineSessionMaxLifespanPerClient = this.client.getAttribute("client.offline.session.max.lifespan");
            int clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty() ? Integer.parseInt(clientOfflineSessionMaxLifespanPerClient) : this.realm.getClientOfflineSessionMaxLifespan();
            if (clientOfflineSessionMaxLifespan > 0) {
                int clientOfflineSessionMaxExpiration = this.userSession.getStarted() + clientOfflineSessionMaxLifespan;
                sessionExpires = sessionExpires < clientOfflineSessionMaxExpiration ? sessionExpires : clientOfflineSessionMaxExpiration;
            }
            int expiration = Time.currentTime() + this.realm.getOfflineSessionIdleTimeout();
            String clientOfflineSessionIdleTimeoutPerClient = this.client.getAttribute("client.offline.session.idle.timeout");
            int clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeoutPerClient != null && !clientOfflineSessionIdleTimeoutPerClient.trim().isEmpty() ? Integer.parseInt(clientOfflineSessionIdleTimeoutPerClient) : this.realm.getClientOfflineSessionIdleTimeout();
            if (clientOfflineSessionIdleTimeout > 0) {
                int clientOfflineSessionIdleExpiration = Time.currentTime() + clientOfflineSessionIdleTimeout;
                expiration = expiration < clientOfflineSessionIdleExpiration ? expiration : clientOfflineSessionIdleExpiration;
            }
            return expiration <= sessionExpires ? expiration : sessionExpires;
        }

        public AccessTokenResponseBuilder generateIDToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.idToken = new IDToken();
            this.idToken.id(KeycloakModelUtils.generateId());
            this.idToken.type("ID");
            this.idToken.subject(this.accessToken.getSubject());
            this.idToken.audience(new String[]{this.client.getClientId()});
            this.idToken.issuedNow();
            this.idToken.issuedFor(this.accessToken.getIssuedFor());
            this.idToken.issuer(this.accessToken.getIssuer());
            this.idToken.setNonce(this.accessToken.getNonce());
            this.idToken.setAuthTime(this.accessToken.getAuthTime());
            this.idToken.setSessionState(this.accessToken.getSessionState());
            this.idToken.expiration(this.accessToken.getExpiration());
            this.idToken.setAcr(this.accessToken.getAcr());
            TokenManager.this.transformIDToken(this.session, this.idToken, this.userSession, this.clientSessionCtx);
            return this;
        }

        public AccessTokenResponseBuilder generateAccessTokenHash() {
            this.generateAccessTokenHash = true;
            return this;
        }

        public AccessTokenResponseBuilder generateCodeHash(String code) {
            this.codeHash = this.generateOIDCHash(code);
            return this;
        }

        public AccessTokenResponseBuilder generateStateHash(String state) {
            this.stateHash = this.generateOIDCHash(state);
            return this;
        }

        public AccessTokenResponse build() {
            int userNotBefore;
            String encodedToken;
            if (this.accessToken != null) {
                this.event.detail("token_id", this.accessToken.getId());
            }
            if (this.refreshToken != null) {
                if (this.event.getEvent().getDetails().containsKey("refresh_token_id")) {
                    this.event.detail("updated_refresh_token_id", this.refreshToken.getId());
                } else {
                    this.event.detail("refresh_token_id", this.refreshToken.getId());
                }
                this.event.detail("refresh_token_type", this.refreshToken.getType());
            }
            AccessTokenResponse res = new AccessTokenResponse();
            if (this.accessToken != null) {
                encodedToken = this.session.tokens().encode((Token)this.accessToken);
                res.setToken(encodedToken);
                res.setTokenType("Bearer");
                res.setSessionState(this.accessToken.getSessionState());
                if (this.accessToken.getExpiration() != 0) {
                    res.setExpiresIn((long)(this.accessToken.getExpiration() - Time.currentTime()));
                }
            }
            if (this.generateAccessTokenHash) {
                String atHash = this.generateOIDCHash(res.getToken());
                this.idToken.setAccessTokenHash(atHash);
            }
            if (this.codeHash != null) {
                this.idToken.setCodeHash(this.codeHash);
            }
            if (this.stateHash != null) {
                this.idToken.setStateHash(this.stateHash);
            }
            if (this.idToken != null) {
                encodedToken = this.session.tokens().encodeAndEncrypt((Token)this.idToken);
                res.setIdToken(encodedToken);
            }
            if (this.refreshToken != null) {
                encodedToken = this.session.tokens().encode((Token)this.refreshToken);
                res.setRefreshToken(encodedToken);
                if (this.refreshToken.getExpiration() != 0) {
                    res.setRefreshExpiresIn((long)(this.refreshToken.getExpiration() - Time.currentTime()));
                }
            }
            int notBefore = this.realm.getNotBefore();
            if (this.client.getNotBefore() > notBefore) {
                notBefore = this.client.getNotBefore();
            }
            if ((userNotBefore = this.session.users().getNotBeforeOfUser(this.realm, this.userSession.getUser())) > notBefore) {
                notBefore = userNotBefore;
            }
            res.setNotBeforePolicy(notBefore);
            TokenManager.this.transformAccessTokenResponse(this.session, res, this.userSession, this.clientSessionCtx);
            String responseScope = this.clientSessionCtx.getScopeString();
            res.setScope(responseScope);
            this.event.detail("scope", responseScope);
            return res;
        }

        private String generateOIDCHash(String input) {
            String signatureAlgorithm = this.session.tokens().signatureAlgorithm(TokenCategory.ID);
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, signatureAlgorithm);
            String hashAlgorithm = signatureProvider.signer().getHashAlgorithm();
            HashProvider hashProvider = (HashProvider)this.session.getProvider(HashProvider.class, hashAlgorithm);
            byte[] hash = hashProvider.hash(input);
            return HashUtils.encodeHashToOIDC((byte[])hash);
        }
    }

    public static class TokenValidation {
        public final UserModel user;
        public final UserSessionModel userSession;
        public final ClientSessionContext clientSessionCtx;
        public final AccessToken newToken;

        public TokenValidation(UserModel user, UserSessionModel userSession, ClientSessionContext clientSessionCtx, AccessToken newToken) {
            this.user = user;
            this.userSession = userSession;
            this.clientSessionCtx = clientSessionCtx;
            this.newToken = newToken;
        }
    }
}

