/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionConfiguration;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class AnyClientCondition
implements ClientPolicyConditionProvider<Configuration> {
    private Configuration configuration = new Configuration();

    public AnyClientCondition(KeycloakSession session) {
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public boolean isNegativeLogic() {
        return Optional.ofNullable(this.configuration.isNegativeLogic()).orElse(Boolean.FALSE);
    }

    public String getProviderId() {
        return "anyclient-condition";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        return ClientPolicyVote.YES;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Configuration
    extends ClientPolicyConditionConfiguration {
        @JsonProperty(value="is-negative-logic")
        protected Boolean negativeLogic;

        public Boolean isNegativeLogic() {
            return this.negativeLogic;
        }

        public void setNegativeLogic(Boolean negativeLogic) {
            this.negativeLogic = negativeLogic;
        }
    }
}

